/*
 * Decompiled with CFR 0.152.
 */
package infra.web.i18n;

import infra.core.i18n.LocaleContext;
import infra.core.i18n.TimeZoneAwareLocaleContext;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.session.SessionManager;
import infra.session.WebSession;
import infra.web.RequestContext;
import infra.web.RequestContextUtils;
import infra.web.i18n.AbstractLocaleContextResolver;
import java.util.Locale;
import java.util.TimeZone;

public class SessionLocaleResolver
extends AbstractLocaleContextResolver {
    public static final String LOCALE_SESSION_ATTRIBUTE_NAME = SessionLocaleResolver.class.getName() + ".LOCALE";
    public static final String TIME_ZONE_SESSION_ATTRIBUTE_NAME = SessionLocaleResolver.class.getName() + ".TIME_ZONE";
    private String localeAttributeName = LOCALE_SESSION_ATTRIBUTE_NAME;
    private String timeZoneAttributeName = TIME_ZONE_SESSION_ATTRIBUTE_NAME;
    @Nullable
    private SessionManager sessionManager;

    public void setLocaleAttributeName(String localeAttributeName) {
        Assert.notNull((Object)localeAttributeName, (String)"localeAttributeName is required");
        this.localeAttributeName = localeAttributeName;
    }

    public void setTimeZoneAttributeName(String timeZoneAttributeName) {
        Assert.notNull((Object)timeZoneAttributeName, (String)"timeZoneAttributeName is required");
        this.timeZoneAttributeName = timeZoneAttributeName;
    }

    public void setSessionManager(@Nullable SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Nullable
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public Locale resolveLocale(RequestContext request) {
        Locale locale = (Locale)this.getSessionAttribute(request, this.localeAttributeName);
        if (locale == null) {
            locale = this.determineDefaultLocale(request);
        }
        return locale;
    }

    @Override
    public LocaleContext resolveLocaleContext(final RequestContext request) {
        return new TimeZoneAwareLocaleContext(){

            public Locale getLocale() {
                Locale locale = (Locale)SessionLocaleResolver.this.getSessionAttribute(request, SessionLocaleResolver.this.localeAttributeName);
                if (locale == null) {
                    locale = SessionLocaleResolver.this.determineDefaultLocale(request);
                }
                return locale;
            }

            @Nullable
            public TimeZone getTimeZone() {
                TimeZone timeZone = (TimeZone)SessionLocaleResolver.this.getSessionAttribute(request, SessionLocaleResolver.this.timeZoneAttributeName);
                if (timeZone == null) {
                    timeZone = SessionLocaleResolver.this.determineDefaultTimeZone(request);
                }
                return timeZone;
            }
        };
    }

    @Override
    public void setLocaleContext(RequestContext request, @Nullable LocaleContext localeContext) {
        Locale locale = null;
        TimeZone timeZone = null;
        if (localeContext != null) {
            locale = localeContext.getLocale();
            if (localeContext instanceof TimeZoneAwareLocaleContext) {
                timeZone = ((TimeZoneAwareLocaleContext)localeContext).getTimeZone();
            }
        }
        this.setSessionAttribute(request, this.localeAttributeName, locale);
        this.setSessionAttribute(request, this.timeZoneAttributeName, timeZone);
    }

    @Nullable
    private <T> T getSessionAttribute(RequestContext request, String attributeName) {
        WebSession session;
        SessionManager sessionManager = this.getSessionManager(request);
        if (sessionManager != null && (session = sessionManager.getSession(request, false)) != null) {
            return (T)session.getAttribute(attributeName);
        }
        return null;
    }

    private void setSessionAttribute(RequestContext request, String attributeName, @Nullable Object attribute) {
        SessionManager sessionManager = this.getSessionManager(request);
        if (sessionManager != null) {
            WebSession session = sessionManager.getSession(request);
            session.setAttribute(attributeName, attribute);
        }
    }

    @Nullable
    private SessionManager getSessionManager(RequestContext request) {
        SessionManager sessionManager = this.getSessionManager();
        if (sessionManager == null) {
            sessionManager = RequestContextUtils.getSessionManager(request);
        }
        return sessionManager;
    }

    protected Locale determineDefaultLocale(RequestContext request) {
        Locale defaultLocale = this.getDefaultLocale();
        if (defaultLocale == null) {
            defaultLocale = request.getLocale();
        }
        return defaultLocale;
    }

    @Nullable
    protected TimeZone determineDefaultTimeZone(RequestContext request) {
        return this.getDefaultTimeZone();
    }
}

