/*
 * Decompiled with CFR 0.152.
 */
package infra.web.i18n;

import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.util.ObjectUtils;
import infra.util.StringUtils;
import infra.web.HandlerInterceptor;
import infra.web.LocaleResolver;
import infra.web.RequestContext;
import infra.web.RequestContextUtils;
import java.util.Locale;

public class LocaleChangeInterceptor
implements HandlerInterceptor {
    public static final String DEFAULT_PARAM_NAME = "locale";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String paramName = "locale";
    @Nullable
    private String[] httpMethods;
    private boolean ignoreInvalidLocale = false;
    @Nullable
    private LocaleResolver localeResolver;

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setHttpMethods(String ... httpMethods) {
        this.httpMethods = httpMethods;
    }

    @Nullable
    public String[] getHttpMethods() {
        return this.httpMethods;
    }

    public void setIgnoreInvalidLocale(boolean ignoreInvalidLocale) {
        this.ignoreInvalidLocale = ignoreInvalidLocale;
    }

    public boolean isIgnoreInvalidLocale() {
        return this.ignoreInvalidLocale;
    }

    public void setLocaleResolver(@Nullable LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }

    @Nullable
    public LocaleResolver getLocaleResolver() {
        return this.localeResolver;
    }

    @Override
    public boolean beforeProcess(RequestContext request, Object handler) {
        String newLocale = request.getParameter(this.getParamName());
        if (newLocale != null && this.checkHttpMethod(request.getMethodValue())) {
            LocaleResolver localeResolver = this.getLocaleResolver();
            if (localeResolver == null && (localeResolver = RequestContextUtils.getLocaleResolver(request)) == null) {
                throw new IllegalStateException("No LocaleResolver found");
            }
            try {
                localeResolver.setLocale(request, this.parseLocaleValue(newLocale));
            }
            catch (IllegalArgumentException ex) {
                if (this.isIgnoreInvalidLocale()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Ignoring invalid locale value [{}]: {}", (Object)newLocale, (Object)ex.getMessage());
                    }
                }
                throw ex;
            }
        }
        return true;
    }

    private boolean checkHttpMethod(String currentMethod) {
        Object[] configuredMethods = this.getHttpMethods();
        if (ObjectUtils.isEmpty((Object[])configuredMethods)) {
            return true;
        }
        for (Object configuredMethod : configuredMethods) {
            if (!((String)configuredMethod).equalsIgnoreCase(currentMethod)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected Locale parseLocaleValue(String localeValue) {
        return StringUtils.parseLocale((String)localeValue);
    }
}

