/*
 * Decompiled with CFR 0.152.
 */
package infra.web.i18n;

import infra.core.i18n.LocaleContext;
import infra.core.i18n.TimeZoneAwareLocaleContext;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.i18n.AbstractLocaleContextResolver;
import java.util.Locale;
import java.util.TimeZone;

public class FixedLocaleResolver
extends AbstractLocaleContextResolver {
    public FixedLocaleResolver() {
        this.setDefaultLocale(Locale.getDefault());
    }

    public FixedLocaleResolver(@Nullable Locale locale) {
        this.setDefaultLocale(locale);
    }

    public FixedLocaleResolver(@Nullable Locale locale, @Nullable TimeZone timeZone) {
        this.setDefaultLocale(locale);
        this.setDefaultTimeZone(timeZone);
    }

    @Override
    public Locale resolveLocale(RequestContext request) {
        Locale locale = this.getDefaultLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    @Override
    public LocaleContext resolveLocaleContext(RequestContext request) {
        return new TimeZoneAwareLocaleContext(){

            @Nullable
            public Locale getLocale() {
                return FixedLocaleResolver.this.getDefaultLocale();
            }

            public TimeZone getTimeZone() {
                return FixedLocaleResolver.this.getDefaultTimeZone();
            }
        };
    }

    @Override
    public void setLocaleContext(RequestContext request, @Nullable LocaleContext localeContext) {
        throw new UnsupportedOperationException("Cannot change fixed locale - use a different locale resolution strategy");
    }
}

