/*
 * Decompiled with CFR 0.152.
 */
package infra.web.i18n;

import infra.core.i18n.LocaleContext;
import infra.core.i18n.SimpleLocaleContext;
import infra.core.i18n.TimeZoneAwareLocaleContext;
import infra.http.HttpCookie;
import infra.lang.Nullable;
import infra.util.StringUtils;
import infra.web.LocaleContextResolver;
import infra.web.RequestContext;
import infra.web.i18n.CookieGenerator;
import infra.web.util.WebUtils;
import java.util.Locale;
import java.util.TimeZone;

public class CookieLocaleResolver
extends CookieGenerator
implements LocaleContextResolver {
    public static final String LOCALE_REQUEST_ATTRIBUTE_NAME = CookieLocaleResolver.class.getName() + ".LOCALE";
    public static final String TIME_ZONE_REQUEST_ATTRIBUTE_NAME = CookieLocaleResolver.class.getName() + ".TIME_ZONE";
    public static final String DEFAULT_COOKIE_NAME = CookieLocaleResolver.class.getName() + ".LOCALE";
    private boolean languageTagCompliant = true;
    private boolean rejectInvalidCookies = true;
    @Nullable
    private Locale defaultLocale;
    @Nullable
    private TimeZone defaultTimeZone;

    public CookieLocaleResolver() {
        this.setCookieName(DEFAULT_COOKIE_NAME);
    }

    public void setLanguageTagCompliant(boolean languageTagCompliant) {
        this.languageTagCompliant = languageTagCompliant;
    }

    public boolean isLanguageTagCompliant() {
        return this.languageTagCompliant;
    }

    public void setRejectInvalidCookies(boolean rejectInvalidCookies) {
        this.rejectInvalidCookies = rejectInvalidCookies;
    }

    public boolean isRejectInvalidCookies() {
        return this.rejectInvalidCookies;
    }

    public void setDefaultLocale(@Nullable Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    @Nullable
    protected Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultTimeZone(@Nullable TimeZone defaultTimeZone) {
        this.defaultTimeZone = defaultTimeZone;
    }

    @Nullable
    protected TimeZone getDefaultTimeZone() {
        return this.defaultTimeZone;
    }

    @Override
    public Locale resolveLocale(RequestContext request) {
        this.parseLocaleCookieIfNecessary(request);
        return (Locale)request.getAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME);
    }

    @Override
    public LocaleContext resolveLocaleContext(final RequestContext request) {
        this.parseLocaleCookieIfNecessary(request);
        return new TimeZoneAwareLocaleContext(){

            @Nullable
            public Locale getLocale() {
                return (Locale)request.getAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME);
            }

            @Nullable
            public TimeZone getTimeZone() {
                return (TimeZone)request.getAttribute(TIME_ZONE_REQUEST_ATTRIBUTE_NAME);
            }
        };
    }

    private void parseLocaleCookieIfNecessary(RequestContext request) {
        if (request.getAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME) == null) {
            HttpCookie cookie;
            Locale locale = null;
            TimeZone timeZone = null;
            String cookieName = this.getCookieName();
            if (cookieName != null && (cookie = request.getCookie(cookieName)) != null) {
                block9: {
                    String value;
                    String localePart = value = cookie.getValue();
                    String timeZonePart = null;
                    int separatorIndex = localePart.indexOf(47);
                    if (separatorIndex == -1) {
                        separatorIndex = localePart.indexOf(32);
                    }
                    if (separatorIndex >= 0) {
                        localePart = value.substring(0, separatorIndex);
                        timeZonePart = value.substring(separatorIndex + 1);
                    }
                    try {
                        Locale locale2 = locale = !"-".equals(localePart) ? this.parseLocaleValue(localePart) : null;
                        if (timeZonePart != null) {
                            timeZone = StringUtils.parseTimeZoneString((String)timeZonePart);
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        if (this.isRejectInvalidCookies() && request.getAttribute(WebUtils.ERROR_EXCEPTION_ATTRIBUTE) == null) {
                            throw new IllegalStateException("Encountered invalid locale cookie '" + cookieName + "': [" + value + "] due to: " + ex.getMessage());
                        }
                        if (!this.logger.isDebugEnabled()) break block9;
                        this.logger.debug("Ignoring invalid locale cookie '{}': [{}] due to: {}", new Object[]{cookieName, value, ex.getMessage()});
                    }
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Parsed cookie value [{}] into locale '{}'{}", new Object[]{cookie.getValue(), locale, timeZone != null ? " and time zone '" + timeZone.getID() + "'" : ""});
                }
            }
            request.setAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME, locale != null ? locale : this.determineDefaultLocale(request));
            request.setAttribute(TIME_ZONE_REQUEST_ATTRIBUTE_NAME, timeZone != null ? timeZone : this.determineDefaultTimeZone(request));
        }
    }

    @Override
    public void setLocale(RequestContext request, @Nullable Locale locale) {
        this.setLocaleContext(request, (LocaleContext)(locale != null ? new SimpleLocaleContext(locale) : null));
    }

    @Override
    public void setLocaleContext(RequestContext request, @Nullable LocaleContext localeContext) {
        Locale locale = null;
        TimeZone timeZone = null;
        if (localeContext != null) {
            locale = localeContext.getLocale();
            if (localeContext instanceof TimeZoneAwareLocaleContext) {
                timeZone = ((TimeZoneAwareLocaleContext)localeContext).getTimeZone();
            }
            this.addCookie(request, (locale != null ? this.toLocaleValue(locale) : "-") + (String)(timeZone != null ? "/" + timeZone.getID() : ""));
        } else {
            this.removeCookie(request);
        }
        request.setAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME, locale != null ? locale : this.determineDefaultLocale(request));
        request.setAttribute(TIME_ZONE_REQUEST_ATTRIBUTE_NAME, timeZone != null ? timeZone : this.determineDefaultTimeZone(request));
    }

    @Nullable
    protected Locale parseLocaleValue(String localeValue) {
        return StringUtils.parseLocale((String)localeValue);
    }

    protected String toLocaleValue(Locale locale) {
        return this.isLanguageTagCompliant() ? locale.toLanguageTag() : locale.toString();
    }

    protected Locale determineDefaultLocale(RequestContext request) {
        Locale defaultLocale = this.getDefaultLocale();
        if (defaultLocale == null) {
            defaultLocale = request.getLocale();
        }
        return defaultLocale;
    }

    @Nullable
    protected TimeZone determineDefaultTimeZone(RequestContext request) {
        return this.getDefaultTimeZone();
    }
}

