/*
 * Decompiled with CFR 0.152.
 */
package infra.web.i18n;

import infra.http.ResponseCookie;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.web.RequestContext;

public class CookieGenerator {
    public static final String DEFAULT_COOKIE_PATH = "/";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nullable
    private String cookieName;
    @Nullable
    private String cookieDomain;
    private String cookiePath = "/";
    @Nullable
    private Integer cookieMaxAge;
    private boolean cookieSecure = false;
    private boolean cookieHttpOnly = false;
    @Nullable
    private String cookieSameSite;

    public void setCookieName(@Nullable String cookieName) {
        this.cookieName = cookieName;
    }

    @Nullable
    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieDomain(@Nullable String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    @Nullable
    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public void setCookieMaxAge(@Nullable Integer cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }

    @Nullable
    public Integer getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    public void setCookieSecure(boolean cookieSecure) {
        this.cookieSecure = cookieSecure;
    }

    public boolean isCookieSecure() {
        return this.cookieSecure;
    }

    public void setCookieHttpOnly(boolean cookieHttpOnly) {
        this.cookieHttpOnly = cookieHttpOnly;
    }

    public void setCookieSameSite(String cookieSameSite) {
        Assert.notNull((Object)cookieSameSite, (String)"cookieSameSite is required");
        this.cookieSameSite = cookieSameSite;
    }

    @Nullable
    public String getCookieSameSite() {
        return this.cookieSameSite;
    }

    public boolean isCookieHttpOnly() {
        return this.cookieHttpOnly;
    }

    public void addCookie(RequestContext response, String cookieValue) {
        Assert.notNull((Object)response, (String)"RequestContext is required");
        ResponseCookie.ResponseCookieBuilder cookie = this.createCookie(cookieValue);
        Integer maxAge = this.getCookieMaxAge();
        if (maxAge != null) {
            cookie.maxAge(maxAge.intValue());
        }
        response.addCookie(cookie.build());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Added cookie [{}={}]", (Object)this.getCookieName(), (Object)cookieValue);
        }
    }

    public void removeCookie(RequestContext response) {
        Assert.notNull((Object)response, (String)"RequestContext is required");
        ResponseCookie.ResponseCookieBuilder cookie = this.createCookie("");
        cookie.maxAge(0L);
        response.addCookie(cookie.build());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Removed cookie '{}'", (Object)this.getCookieName());
        }
    }

    protected ResponseCookie.ResponseCookieBuilder createCookie(String cookieValue) {
        String sameSite;
        ResponseCookie.ResponseCookieBuilder builder = ResponseCookie.from(this.getCookieName(), cookieValue);
        if (this.getCookieDomain() != null) {
            builder.domain(this.getCookieDomain());
        }
        builder.path(this.getCookiePath());
        if (this.isCookieHttpOnly()) {
            builder.httpOnly(true);
        }
        if (this.isCookieSecure()) {
            builder.secure(true);
        }
        if ((sameSite = this.getCookieSameSite()) != null) {
            builder.sameSite(sameSite);
        }
        return builder;
    }
}

