/*
 * Decompiled with CFR 0.152.
 */
package infra.web.i18n;

import infra.lang.Nullable;
import infra.util.StringUtils;
import infra.web.LocaleResolver;
import infra.web.RequestContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class AcceptHeaderLocaleResolver
implements LocaleResolver {
    private final List<Locale> supportedLocales = new ArrayList<Locale>(4);
    @Nullable
    private Locale defaultLocale;

    public void setSupportedLocales(List<Locale> locales) {
        this.supportedLocales.clear();
        this.supportedLocales.addAll(locales);
    }

    public List<Locale> getSupportedLocales() {
        return this.supportedLocales;
    }

    public void setDefaultLocale(@Nullable Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    @Nullable
    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    @Override
    public Locale resolveLocale(RequestContext request) {
        Locale defaultLocale = this.getDefaultLocale();
        if (defaultLocale != null && request.requestHeaders().get("Accept-Language") == null) {
            return defaultLocale;
        }
        Locale requestLocale = request.getLocale();
        List<Locale> supportedLocales = this.getSupportedLocales();
        if (supportedLocales.isEmpty() || supportedLocales.contains(requestLocale)) {
            return requestLocale;
        }
        Locale supportedLocale = this.findSupportedLocale(request, supportedLocales);
        if (supportedLocale != null) {
            return supportedLocale;
        }
        return defaultLocale != null ? defaultLocale : requestLocale;
    }

    @Nullable
    private Locale findSupportedLocale(RequestContext request, List<Locale> supportedLocales) {
        Locale languageMatch = null;
        List<Locale> requestLocales = request.requestHeaders().getAcceptLanguageAsLocales();
        block0: for (Locale locale : requestLocales) {
            if (supportedLocales.contains(locale)) {
                if (languageMatch != null && !languageMatch.getLanguage().equals(locale.getLanguage())) continue;
                return locale;
            }
            if (languageMatch != null) continue;
            for (Locale candidate : supportedLocales) {
                if (!StringUtils.isEmpty((CharSequence)candidate.getCountry()) || !candidate.getLanguage().equals(locale.getLanguage())) continue;
                languageMatch = candidate;
                continue block0;
            }
        }
        return languageMatch;
    }

    @Override
    public void setLocale(RequestContext request, @Nullable Locale locale) {
        throw new UnsupportedOperationException("Cannot change HTTP accept header - use a different locale resolution strategy");
    }
}

