/*
 * Decompiled with CFR 0.152.
 */
package infra.web.i18n;

import infra.core.i18n.LocaleContext;
import infra.core.i18n.SimpleLocaleContext;
import infra.lang.Nullable;
import infra.web.LocaleContextResolver;
import infra.web.RequestContext;
import infra.web.i18n.AbstractLocaleResolver;
import java.util.Locale;
import java.util.TimeZone;

public abstract class AbstractLocaleContextResolver
extends AbstractLocaleResolver
implements LocaleContextResolver {
    @Nullable
    private TimeZone defaultTimeZone;

    public void setDefaultTimeZone(@Nullable TimeZone defaultTimeZone) {
        this.defaultTimeZone = defaultTimeZone;
    }

    @Nullable
    public TimeZone getDefaultTimeZone() {
        return this.defaultTimeZone;
    }

    @Override
    public Locale resolveLocale(RequestContext request) {
        Locale locale = this.resolveLocaleContext(request).getLocale();
        return locale != null ? locale : request.getLocale();
    }

    @Override
    public void setLocale(RequestContext request, @Nullable Locale locale) {
        this.setLocaleContext(request, (LocaleContext)(locale != null ? new SimpleLocaleContext(locale) : null));
    }
}

