/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.result;

import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.BindingContext;
import infra.web.RequestContext;
import infra.web.handler.method.HandlerMethod;
import infra.web.handler.result.SmartReturnValueHandler;
import infra.web.view.ModelAndView;
import infra.web.view.ViewReturnValueHandler;

public class VoidReturnValueHandler
implements SmartReturnValueHandler {
    private final ViewReturnValueHandler delegate;

    public VoidReturnValueHandler(ViewReturnValueHandler delegate) {
        Assert.notNull((Object)delegate, (String)"ViewReturnValueHandler is required");
        this.delegate = delegate;
    }

    @Override
    public boolean supportsReturnValue(Object returnValue) {
        return returnValue == null;
    }

    @Override
    public boolean supportsHandler(Object handler, @Nullable Object returnValue) {
        if (returnValue == null) {
            HandlerMethod handlerMethod = HandlerMethod.unwrap(handler);
            return handlerMethod == null || handlerMethod.isReturn(Void.TYPE) || handlerMethod.isReturn(Void.class);
        }
        return false;
    }

    @Override
    public void handleReturnValue(RequestContext context, @Nullable Object handler, @Nullable Object returnValue) throws Exception {
        BindingContext binding = context.getBinding();
        if (binding != null && binding.hasModelAndView()) {
            ModelAndView modelAndView = binding.getModelAndView();
            this.delegate.renderView(context, modelAndView);
        }
    }
}

