/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.result;

import infra.core.MethodParameter;
import infra.core.ResolvableType;
import infra.http.ResponseEntity;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.handler.StreamingResponseBody;
import infra.web.handler.method.HandlerMethod;
import infra.web.handler.result.CallableMethodReturnValueHandler;
import infra.web.handler.result.HandlerMethodReturnValueHandler;
import java.io.OutputStream;
import java.util.concurrent.Callable;

public class StreamingResponseBodyReturnValueHandler
implements HandlerMethodReturnValueHandler {
    @Override
    public boolean supportsReturnValue(@Nullable Object returnValue) {
        ResponseEntity response;
        return returnValue instanceof StreamingResponseBody || returnValue instanceof ResponseEntity && (response = (ResponseEntity)returnValue).getBody() instanceof StreamingResponseBody;
    }

    @Override
    public boolean supportsHandlerMethod(HandlerMethod handler) {
        MethodParameter returnType = handler.getReturnType();
        if (StreamingResponseBody.class.isAssignableFrom(returnType.getParameterType())) {
            return true;
        }
        if (ResponseEntity.class.isAssignableFrom(returnType.getParameterType())) {
            Class bodyType = ResolvableType.forMethodParameter((MethodParameter)returnType).getGeneric(new int[0]).resolve();
            return bodyType != null && StreamingResponseBody.class.isAssignableFrom(bodyType);
        }
        return false;
    }

    @Override
    public void handleReturnValue(RequestContext context, Object handler, @Nullable Object returnValue) throws Exception {
        if (returnValue == null) {
            return;
        }
        if (returnValue instanceof ResponseEntity) {
            ResponseEntity responseEntity = (ResponseEntity)returnValue;
            context.setStatus(responseEntity.getStatusCode());
            context.mergeToResponse(responseEntity.getHeaders());
            returnValue = responseEntity.getBody();
            if (returnValue == null) {
                return;
            }
        }
        if (returnValue instanceof StreamingResponseBody) {
            StreamingResponseBody streamingBody = (StreamingResponseBody)returnValue;
            StreamingBodyTask callable = new StreamingBodyTask(context.getOutputStream(), streamingBody);
            context.getAsyncManager().startCallableProcessing(callable, handler);
        } else if (HandlerMethod.isHandler(handler)) {
            CallableMethodReturnValueHandler.startCallableProcessing(context, handler, returnValue);
        } else {
            throw new IllegalArgumentException("StreamingResponseBody expected");
        }
    }

    private record StreamingBodyTask(OutputStream outputStream, StreamingResponseBody streamingBody) implements Callable<Void>
    {
        @Override
        public Void call() throws Exception {
            this.streamingBody.writeTo(this.outputStream);
            this.outputStream.flush();
            return null;
        }
    }
}

