/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.result;

import infra.http.MediaType;
import infra.lang.Assert;
import infra.web.RequestContext;
import infra.web.handler.method.HandlerMethod;
import infra.web.handler.result.HandlerMethodReturnValueHandler;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

public class RenderedImageReturnValueHandler
implements HandlerMethodReturnValueHandler {
    public static final String IMAGE_PNG = "png";
    private String formatName = "png";
    private String contentType = "image/png";

    @Override
    public boolean supportsHandlerMethod(HandlerMethod handler) {
        return handler.isReturnTypeAssignableTo(RenderedImage.class);
    }

    @Override
    public boolean supportsReturnValue(Object returnValue) {
        return returnValue instanceof RenderedImage;
    }

    @Override
    public void handleReturnValue(RequestContext context, Object handler, Object returnValue) throws IOException {
        if (returnValue instanceof RenderedImage) {
            RenderedImage renderedImage = (RenderedImage)returnValue;
            this.write(renderedImage, context);
        }
    }

    public void write(RenderedImage image, RequestContext context) throws IOException {
        context.setContentType(this.contentType);
        ImageIO.write(image, this.formatName, context.getOutputStream());
    }

    public void setFormatName(String formatName) {
        Assert.notNull((Object)formatName, (String)"formatName is required");
        this.formatName = formatName;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public void setContentType(String contentType) {
        Assert.notNull((Object)contentType, (String)"contentType is required");
        this.contentType = contentType;
    }

    public void setContentType(MediaType contentType) {
        Assert.notNull((Object)contentType, (String)"contentType is required");
        this.contentType = contentType.toString();
    }

    public String getContentType() {
        return this.contentType;
    }
}

