/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.result;

import infra.lang.Nullable;
import infra.util.concurrent.Future;
import infra.web.RequestContext;
import infra.web.async.DeferredResult;
import infra.web.handler.method.HandlerMethod;
import infra.web.handler.result.HandlerMethodReturnValueHandler;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;

public class DeferredResultReturnValueHandler
implements HandlerMethodReturnValueHandler {
    @Override
    public boolean supportsHandlerMethod(HandlerMethod handler) {
        return handler.isReturnTypeAssignableTo(DeferredResult.class) || handler.isReturnTypeAssignableTo(Future.class) || handler.isReturnTypeAssignableTo(CompletionStage.class);
    }

    @Override
    public boolean supportsReturnValue(@Nullable Object returnValue) {
        return returnValue instanceof DeferredResult || returnValue instanceof Future || returnValue instanceof CompletionStage;
    }

    @Override
    public void handleReturnValue(RequestContext context, Object handler, @Nullable Object returnValue) throws Exception {
        DeferredResult<Object> result;
        if (returnValue == null) {
            return;
        }
        if (returnValue instanceof DeferredResult) {
            result = (DeferredResult<Object>)returnValue;
        } else if (returnValue instanceof Future) {
            result = this.adaptListenableFuture((Future<Object>)((Future)returnValue));
        } else if (returnValue instanceof CompletionStage) {
            result = this.adaptCompletionStage((CompletionStage)returnValue);
        } else if (HandlerMethod.isHandler(handler)) {
            result = new DeferredResult();
            result.setResult(returnValue);
        } else {
            throw new IllegalStateException("Unexpected return value type: " + returnValue);
        }
        context.getAsyncManager().startDeferredResultProcessing(result, handler);
    }

    private DeferredResult<Object> adaptListenableFuture(Future<Object> future) {
        DeferredResult<Object> result = new DeferredResult<Object>();
        future.onCompleted(result);
        result.onTimeout(() -> future.cancel());
        return result;
    }

    private DeferredResult<Object> adaptCompletionStage(CompletionStage<?> future) {
        DeferredResult<Object> result = new DeferredResult<Object>();
        future.handle((value, ex) -> {
            if (ex != null) {
                if (ex instanceof CompletionException && ex.getCause() != null) {
                    ex = ex.getCause();
                }
                result.setErrorResult(ex);
            } else {
                result.setResult(value);
            }
            return null;
        });
        return result;
    }
}

