/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.result;

import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.handler.method.HandlerMethod;
import infra.web.handler.result.HandlerMethodReturnValueHandler;
import java.util.concurrent.Callable;

public class CallableMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    @Override
    public boolean supportsHandlerMethod(HandlerMethod handler) {
        return handler.isReturn(Callable.class);
    }

    @Override
    public boolean supportsReturnValue(@Nullable Object returnValue) {
        return returnValue instanceof Callable;
    }

    @Override
    public void handleReturnValue(RequestContext context, Object handler, @Nullable Object returnValue) throws Exception {
        if (returnValue instanceof Callable) {
            Callable callable = (Callable)returnValue;
            context.getAsyncManager().startCallableProcessing(callable, handler);
        } else if (HandlerMethod.isHandler(handler)) {
            CallableMethodReturnValueHandler.startCallableProcessing(context, handler, returnValue);
        }
    }

    static void startCallableProcessing(RequestContext context, Object handler, @Nullable Object returnValue) throws Exception {
        context.getAsyncManager().startCallableProcessing(() -> returnValue, handler);
    }
}

