/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.result;

import infra.beans.factory.BeanFactory;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.async.WebAsyncTask;
import infra.web.handler.method.HandlerMethod;
import infra.web.handler.result.CallableMethodReturnValueHandler;
import infra.web.handler.result.HandlerMethodReturnValueHandler;

public class AsyncTaskMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    @Nullable
    private final BeanFactory beanFactory;

    public AsyncTaskMethodReturnValueHandler(@Nullable BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public boolean supportsReturnValue(@Nullable Object returnValue) {
        return returnValue instanceof WebAsyncTask;
    }

    @Override
    public boolean supportsHandlerMethod(HandlerMethod handler) {
        return handler.isReturnTypeAssignableTo(WebAsyncTask.class);
    }

    @Override
    public void handleReturnValue(RequestContext context, Object handler, @Nullable Object returnValue) throws Exception {
        if (returnValue instanceof WebAsyncTask) {
            WebAsyncTask task = (WebAsyncTask)returnValue;
            if (this.beanFactory != null) {
                task.setBeanFactory(this.beanFactory);
            }
            context.getAsyncManager().startCallableProcessing(task, handler);
        } else if (HandlerMethod.isHandler(handler)) {
            CallableMethodReturnValueHandler.startCallableProcessing(context, handler, returnValue);
        }
    }
}

