/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.mvc;

import infra.http.CacheControl;
import infra.http.server.PathContainer;
import infra.lang.Nullable;
import infra.web.HandlerInterceptor;
import infra.web.RequestContext;
import infra.web.WebContentGenerator;
import infra.web.util.pattern.PathPattern;
import infra.web.util.pattern.PathPatternParser;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class WebContentInterceptor
extends WebContentGenerator
implements HandlerInterceptor {
    private final PathPatternParser patternParser;
    private final HashMap<PathPattern, Integer> cacheMappings = new HashMap();
    private final HashMap<PathPattern, CacheControl> cacheControlMappings = new HashMap();

    public WebContentInterceptor() {
        this(PathPatternParser.defaultInstance);
    }

    public WebContentInterceptor(PathPatternParser parser) {
        super(false);
        this.patternParser = parser;
    }

    public void setCacheMappings(Properties cacheMappings) {
        this.cacheMappings.clear();
        Set<String> propNames = cacheMappings.stringPropertyNames();
        for (String path : propNames) {
            int cacheSeconds = Integer.parseInt(cacheMappings.getProperty(path));
            this.cacheMappings.put(this.patternParser.parse(path), cacheSeconds);
        }
    }

    public void addCacheMapping(CacheControl cacheControl, String ... paths) {
        for (String path : paths) {
            this.cacheControlMappings.put(this.patternParser.parse(path), cacheControl);
        }
    }

    @Override
    public boolean beforeProcess(RequestContext request, Object handler) {
        Integer cacheSeconds;
        CacheControl control;
        this.checkRequest(request);
        if (!this.cacheControlMappings.isEmpty() && (control = this.lookupCacheControl(request.getRequestPath())) != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Applying {}", (Object)control);
            }
            this.applyCacheControl(request, control);
            return true;
        }
        if (!this.cacheMappings.isEmpty() && (cacheSeconds = this.lookupCacheSeconds(request.getRequestPath())) != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Applying cacheSeconds {}", (Object)cacheSeconds);
            }
            this.applyCacheSeconds(request, cacheSeconds);
            return true;
        }
        this.prepareResponse(request);
        return true;
    }

    @Nullable
    protected CacheControl lookupCacheControl(PathContainer path) {
        for (Map.Entry<PathPattern, CacheControl> entry : this.cacheControlMappings.entrySet()) {
            if (!entry.getKey().matches(path)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    protected Integer lookupCacheSeconds(PathContainer path) {
        for (Map.Entry<PathPattern, Integer> entry : this.cacheMappings.entrySet()) {
            if (!entry.getKey().matches(path)) continue;
            return entry.getValue();
        }
        return null;
    }
}

