/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.mvc;

import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.handler.mvc.AbstractUrlViewController;
import infra.web.util.WebUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UrlFilenameViewController
extends AbstractUrlViewController {
    private String prefix = "";
    private String suffix = "";
    private boolean removeSemicolonContent = true;
    private final Map<String, String> viewNameCache = new ConcurrentHashMap<String, String>(256);

    public void setPrefix(@Nullable String prefix) {
        this.prefix = prefix != null ? prefix : "";
    }

    protected String getPrefix() {
        return this.prefix;
    }

    public void setSuffix(@Nullable String suffix) {
        this.suffix = suffix != null ? suffix : "";
    }

    protected String getSuffix() {
        return this.suffix;
    }

    public void setRemoveSemicolonContent(boolean removeSemicolonContent) {
        this.removeSemicolonContent = removeSemicolonContent;
    }

    @Override
    protected String getViewNameForRequest(RequestContext request) {
        String uri = this.extractOperableUrl(request);
        return this.getViewNameForUrlPath(uri);
    }

    protected String extractOperableUrl(RequestContext request) {
        String path = request.getRequestPath().value();
        path = this.removeSemicolonContent ? WebUtils.removeSemicolonContent(path) : path;
        return path;
    }

    protected String getViewNameForUrlPath(String uri) {
        return this.viewNameCache.computeIfAbsent(uri, u -> this.postProcessViewName(this.extractViewNameFromUrlPath((String)u)));
    }

    protected String extractViewNameFromUrlPath(String uri) {
        int start = uri.charAt(0) == '/' ? 1 : 0;
        int lastIndex = uri.lastIndexOf(46);
        int end = lastIndex < 0 ? uri.length() : lastIndex;
        return uri.substring(start, end);
    }

    protected String postProcessViewName(String viewName) {
        return this.getPrefix() + viewName + this.getSuffix();
    }
}

