/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.mvc;

import infra.http.HttpMethod;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.lang.Nullable;
import infra.web.HttpRequestHandler;
import infra.web.RedirectModel;
import infra.web.RequestContext;
import infra.web.handler.mvc.AbstractController;
import infra.web.view.ModelAndView;
import infra.web.view.View;
import java.util.function.Supplier;

public class ParameterizableViewController
extends AbstractController {
    @Nullable
    private Object returnValue;
    @Nullable
    private HttpStatusCode statusCode;
    private boolean statusOnly;
    @Nullable
    private String contentType;

    public ParameterizableViewController() {
        super(false);
        this.setSupportedMethods(HttpMethod.GET.name(), HttpMethod.HEAD.name());
    }

    public void setViewName(@Nullable String viewName) {
        this.returnValue = viewName;
    }

    @Nullable
    public String getViewName() {
        Object object = this.returnValue;
        if (object instanceof String) {
            String viewName = (String)object;
            if (this.getStatusCode() != null && this.getStatusCode().is3xxRedirection()) {
                return viewName.startsWith("redirect:") ? viewName : "redirect:" + viewName;
            }
            return viewName;
        }
        return null;
    }

    public void setView(View view) {
        this.returnValue = view;
    }

    @Nullable
    public View getView() {
        return this.returnValue instanceof View ? (View)this.returnValue : null;
    }

    public void setStatusCode(@Nullable HttpStatusCode statusCode) {
        this.statusCode = statusCode;
    }

    @Nullable
    public HttpStatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusOnly(boolean statusOnly) {
        this.statusOnly = statusOnly;
    }

    public boolean isStatusOnly() {
        return this.statusOnly;
    }

    public void setReturnValue(@Nullable Object returnValue) {
        this.returnValue = returnValue;
    }

    @Nullable
    public Object getReturnValue() {
        return this.returnValue;
    }

    public void setContentType(@Nullable String contentType) {
        this.contentType = contentType;
    }

    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    @Override
    protected Object handleRequestInternal(RequestContext request) throws Throwable {
        String contentType = this.getContentType();
        if (contentType != null) {
            request.setContentType(contentType);
        }
        String viewName = this.getViewName();
        HttpStatusCode statusCode = this.getStatusCode();
        if (statusCode != null) {
            if (statusCode.is3xxRedirection()) {
                request.setAttribute(View.RESPONSE_STATUS_ATTRIBUTE, statusCode);
            } else {
                request.setStatus(statusCode);
                if (statusCode.equals(HttpStatus.NO_CONTENT) && viewName == null) {
                    return NONE_RETURN_VALUE;
                }
            }
        }
        if (this.isStatusOnly()) {
            return NONE_RETURN_VALUE;
        }
        Object result = this.getReturnValue();
        if (viewName == null && !(result instanceof View) && result != null) {
            if (result instanceof Supplier) {
                Supplier supplier = (Supplier)result;
                return supplier.get();
            }
            if (result instanceof HttpRequestHandler) {
                HttpRequestHandler handler = (HttpRequestHandler)result;
                return handler.handleRequest(request);
            }
            return result;
        }
        ModelAndView modelAndView = new ModelAndView();
        RedirectModel redirectModel = request.getInputRedirectModel();
        if (redirectModel != null) {
            modelAndView.addAllObjects(redirectModel.asMap());
        }
        if (viewName != null) {
            modelAndView.setViewName(viewName);
        } else {
            modelAndView.setView(this.getView());
        }
        return modelAndView;
    }

    public String toString() {
        return "ParameterizableViewController [%s]".formatted(this.formatStatusAndView());
    }

    private String formatStatusAndView() {
        StringBuilder sb = new StringBuilder();
        if (this.statusCode != null) {
            sb.append("status=").append(this.statusCode);
        }
        if (this.returnValue != null) {
            if (!sb.isEmpty()) {
                sb.append(", ");
            }
            String viewName = this.getViewName();
            sb.append("view=").append(viewName != null ? "\"" + viewName + "\"" : this.returnValue);
        }
        return sb.toString();
    }
}

