/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.mvc;

import infra.http.HttpMethod;
import infra.lang.Nullable;
import infra.session.WebSession;
import infra.web.RequestContext;
import infra.web.RequestContextUtils;
import infra.web.WebContentGenerator;
import infra.web.handler.mvc.Controller;
import infra.web.util.WebUtils;

public abstract class AbstractController
extends WebContentGenerator
implements Controller {
    private boolean synchronizeOnSession = false;

    public AbstractController() {
        this(true);
    }

    public AbstractController(boolean restrictDefaultSupportedMethods) {
        super(restrictDefaultSupportedMethods);
    }

    public final void setSynchronizeOnSession(boolean synchronizeOnSession) {
        this.synchronizeOnSession = synchronizeOnSession;
    }

    public final boolean isSynchronizeOnSession() {
        return this.synchronizeOnSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object handleRequest(RequestContext context) throws Throwable {
        WebSession session;
        if (HttpMethod.OPTIONS == context.getMethod()) {
            context.setHeader("Allow", this.getAllowHeader());
            return NONE_RETURN_VALUE;
        }
        this.checkRequest(context);
        this.prepareResponse(context);
        if (this.synchronizeOnSession && (session = RequestContextUtils.getSession(context, false)) != null) {
            Object mutex;
            Object object = mutex = WebUtils.getSessionMutex(session);
            synchronized (object) {
                return this.handleRequestInternal(context);
            }
        }
        return this.handleRequestInternal(context);
    }

    @Nullable
    protected abstract Object handleRequestInternal(RequestContext var1) throws Throwable;
}

