/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.method.support;

import infra.core.MethodParameter;
import infra.core.conversion.ConversionService;
import infra.format.support.DefaultFormattingConversionService;
import infra.lang.Nullable;
import infra.web.bind.resolver.ParameterResolvingStrategy;
import infra.web.handler.method.ResolvableMethodParameter;
import infra.web.handler.method.support.UriComponentsContributor;
import infra.web.util.UriComponentsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CompositeUriComponentsContributor
implements UriComponentsContributor {
    private final List<Object> contributors;
    private final ConversionService conversionService;

    public CompositeUriComponentsContributor(UriComponentsContributor ... contributors) {
        this.contributors = Arrays.asList((Object[])contributors);
        this.conversionService = new DefaultFormattingConversionService();
    }

    public CompositeUriComponentsContributor(Collection<?> contributors) {
        this(contributors, null);
    }

    public CompositeUriComponentsContributor(@Nullable Collection<?> contributors, @Nullable ConversionService cs) {
        this.contributors = contributors != null ? new ArrayList(contributors) : Collections.emptyList();
        this.conversionService = cs != null ? cs : new DefaultFormattingConversionService();
    }

    public boolean hasContributors() {
        return !this.contributors.isEmpty();
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        ResolvableMethodParameter resolvable = null;
        for (Object contributor : this.contributors) {
            if (contributor instanceof UriComponentsContributor) {
                UriComponentsContributor ucc = (UriComponentsContributor)contributor;
                if (!ucc.supportsParameter(parameter)) continue;
                return true;
            }
            if (!(contributor instanceof ParameterResolvingStrategy)) continue;
            ParameterResolvingStrategy resolver = (ParameterResolvingStrategy)contributor;
            if (resolvable == null) {
                resolvable = new ResolvableMethodParameter(parameter);
            }
            if (!resolver.supportsParameter(resolvable)) continue;
            return false;
        }
        return false;
    }

    @Override
    public void contributeMethodArgument(MethodParameter parameter, Object value, UriComponentsBuilder builder, Map<String, Object> uriVariables, ConversionService conversionService) {
        ResolvableMethodParameter resolvable = new ResolvableMethodParameter(parameter);
        for (Object contributor : this.contributors) {
            ParameterResolvingStrategy resolver;
            if (contributor instanceof UriComponentsContributor) {
                UriComponentsContributor ucc = (UriComponentsContributor)contributor;
                if (!ucc.supportsParameter(parameter)) continue;
                ucc.contributeMethodArgument(parameter, value, builder, uriVariables, conversionService);
                break;
            }
            if (!(contributor instanceof ParameterResolvingStrategy) || !(resolver = (ParameterResolvingStrategy)contributor).supportsParameter(resolvable)) continue;
            break;
        }
    }

    public void contributeMethodArgument(MethodParameter parameter, Object value, UriComponentsBuilder builder, Map<String, Object> uriVariables) {
        this.contributeMethodArgument(parameter, value, builder, uriVariables, this.conversionService);
    }
}

