/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.method;

import infra.http.MediaType;
import infra.lang.Nullable;
import infra.util.ObjectUtils;
import infra.util.StringUtils;
import infra.web.RequestContext;
import infra.web.handler.method.ResponseBodyEmitter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.locks.ReentrantLock;

public class SseEmitter
extends ResponseBodyEmitter {
    private static final MediaType TEXT_PLAIN = MediaType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8);
    private final ReentrantLock writeLock = new ReentrantLock();

    public SseEmitter() {
    }

    public SseEmitter(Long timeout) {
        super(timeout);
    }

    @Override
    protected void extendResponse(RequestContext outputMessage) {
        super.extendResponse(outputMessage);
        if (outputMessage.getResponseContentType() == null) {
            outputMessage.setContentType("text/event-stream");
        }
    }

    @Override
    public void send(Object object) throws IOException {
        this.send(object, null);
    }

    @Override
    public void send(Object object, @Nullable MediaType mediaType) throws IOException {
        this.send(SseEmitter.event().data(object, mediaType));
    }

    public void send(SseEventBuilder builder) throws IOException {
        Collection<ResponseBodyEmitter.DataWithMediaType> dataToSend = builder.build();
        this.writeLock.lock();
        try {
            super.send(dataToSend);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public String toString() {
        return "SseEmitter@" + ObjectUtils.getIdentityHexString((Object)this);
    }

    public static SseEventBuilder event() {
        return new SseEventBuilderImpl();
    }

    public static interface SseEventBuilder {
        public SseEventBuilder id(String var1);

        public SseEventBuilder name(String var1);

        public SseEventBuilder reconnectTime(long var1);

        public SseEventBuilder comment(String var1);

        public SseEventBuilder data(Object var1);

        public SseEventBuilder data(Object var1, @Nullable MediaType var2);

        public Collection<ResponseBodyEmitter.DataWithMediaType> build();
    }

    private static class SseEventBuilderImpl
    implements SseEventBuilder {
        private final ArrayList<ResponseBodyEmitter.DataWithMediaType> dataToSend = new ArrayList();
        @Nullable
        private StringBuilder sb;

        private SseEventBuilderImpl() {
        }

        @Override
        public SseEventBuilder id(String id) {
            this.append("id:").append(id).append('\n');
            return this;
        }

        @Override
        public SseEventBuilder name(String name) {
            this.append("event:").append(name).append('\n');
            return this;
        }

        @Override
        public SseEventBuilder reconnectTime(long reconnectTimeMillis) {
            this.append("retry:").append(String.valueOf(reconnectTimeMillis)).append('\n');
            return this;
        }

        @Override
        public SseEventBuilder comment(String comment) {
            this.append(':').append(comment).append('\n');
            return this;
        }

        @Override
        public SseEventBuilder data(Object object) {
            return this.data(object, null);
        }

        @Override
        public SseEventBuilder data(Object object, @Nullable MediaType mediaType) {
            this.append("data:");
            this.saveAppendedText();
            if (object instanceof String) {
                String text = (String)object;
                object = StringUtils.replace((String)text, (String)"\n", (String)"\ndata:");
            }
            this.dataToSend.add(new ResponseBodyEmitter.DataWithMediaType(object, mediaType));
            this.append('\n');
            return this;
        }

        SseEventBuilderImpl append(String text) {
            if (this.sb == null) {
                this.sb = new StringBuilder();
            }
            this.sb.append(text);
            return this;
        }

        SseEventBuilderImpl append(char ch) {
            if (this.sb == null) {
                this.sb = new StringBuilder();
            }
            this.sb.append(ch);
            return this;
        }

        @Override
        public Collection<ResponseBodyEmitter.DataWithMediaType> build() {
            if (StringUtils.isEmpty((CharSequence)this.sb) && this.dataToSend.isEmpty()) {
                return Collections.emptySet();
            }
            this.append('\n');
            this.saveAppendedText();
            return this.dataToSend;
        }

        private void saveAppendedText() {
            if (this.sb != null) {
                this.dataToSend.add(new ResponseBodyEmitter.DataWithMediaType(this.sb.toString(), TEXT_PLAIN));
                this.sb = null;
            }
        }
    }
}

