/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.method;

import infra.core.MethodParameter;
import infra.core.ReactiveAdapterRegistry;
import infra.core.ResolvableType;
import infra.core.task.TaskExecutor;
import infra.http.MediaType;
import infra.http.ResponseEntity;
import infra.http.converter.HttpMessageConverter;
import infra.http.converter.StringHttpMessageConverter;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.accept.ContentNegotiationManager;
import infra.web.async.DeferredResult;
import infra.web.handler.method.HandlerMethod;
import infra.web.handler.method.ReactiveTypeHandler;
import infra.web.handler.method.ResponseBodyEmitter;
import infra.web.handler.result.SmartReturnValueHandler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

public class ResponseBodyEmitterReturnValueHandler
implements SmartReturnValueHandler {
    private final List<HttpMessageConverter<?>> sseMessageConverters;
    private final ReactiveTypeHandler reactiveHandler;

    public ResponseBodyEmitterReturnValueHandler(List<HttpMessageConverter<?>> messageConverters) {
        Assert.notEmpty(messageConverters, (String)"HttpMessageConverter List must not be empty");
        this.sseMessageConverters = ResponseBodyEmitterReturnValueHandler.initSseConverters(messageConverters);
        this.reactiveHandler = new ReactiveTypeHandler();
    }

    public ResponseBodyEmitterReturnValueHandler(List<HttpMessageConverter<?>> messageConverters, ContentNegotiationManager manager) {
        Assert.notEmpty(messageConverters, (String)"HttpMessageConverter List must not be empty");
        this.sseMessageConverters = ResponseBodyEmitterReturnValueHandler.initSseConverters(messageConverters);
        this.reactiveHandler = new ReactiveTypeHandler(manager);
    }

    public ResponseBodyEmitterReturnValueHandler(List<HttpMessageConverter<?>> messageConverters, ReactiveAdapterRegistry registry, TaskExecutor executor, ContentNegotiationManager manager) {
        Assert.notEmpty(messageConverters, (String)"HttpMessageConverter List must not be empty");
        this.sseMessageConverters = ResponseBodyEmitterReturnValueHandler.initSseConverters(messageConverters);
        this.reactiveHandler = new ReactiveTypeHandler(registry, executor, manager);
    }

    private static List<HttpMessageConverter<?>> initSseConverters(List<HttpMessageConverter<?>> converters) {
        for (HttpMessageConverter<String> httpMessageConverter : converters) {
            if (!httpMessageConverter.canWrite(String.class, MediaType.TEXT_PLAIN)) continue;
            return converters;
        }
        ArrayList result = new ArrayList(converters.size() + 1);
        result.add(new StringHttpMessageConverter(StandardCharsets.UTF_8));
        result.addAll(converters);
        return result;
    }

    @Override
    public boolean supportsHandler(Object handler) {
        HandlerMethod handlerMethod = HandlerMethod.unwrap(handler);
        if (handlerMethod != null) {
            return this.supportsReturnType(handlerMethod.getReturnType());
        }
        return false;
    }

    @Override
    public boolean supportsHandler(Object handler, @Nullable Object returnValue) {
        HandlerMethod handlerMethod = HandlerMethod.unwrap(handler);
        if (handlerMethod != null) {
            return this.supportsReturnValue(returnValue) || this.supportsReturnType(handlerMethod.getReturnValueType(returnValue));
        }
        return this.supportsReturnValue(returnValue);
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        Class bodyType = ResponseEntity.class.isAssignableFrom(returnType.getParameterType()) ? ResolvableType.forMethodParameter((MethodParameter)returnType).getGeneric(new int[0]).resolve() : returnType.getParameterType();
        return bodyType != null && (ResponseBodyEmitter.class.isAssignableFrom(bodyType) || this.reactiveHandler.isReactiveType(bodyType));
    }

    @Override
    public boolean supportsReturnValue(@Nullable Object returnValue) {
        return returnValue instanceof ResponseBodyEmitter;
    }

    @Override
    public void handleReturnValue(RequestContext request, @Nullable Object handler, @Nullable Object returnValue) throws Exception {
        HttpMessageConvertingHandler responseBodyEmitter;
        ResponseBodyEmitter emitter;
        if (returnValue == null) {
            return;
        }
        MethodParameter returnType = null;
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            returnType = handlerMethod.getReturnType();
            if (returnValue instanceof ResponseEntity) {
                ResponseEntity entity = (ResponseEntity)returnValue;
                request.setStatus(entity.getStatusCode());
                request.mergeToResponse(entity.getHeaders());
                returnValue = entity.getBody();
                returnType = returnType.nested();
                if (returnValue == null) {
                    request.flush();
                    return;
                }
            }
        }
        if (returnValue instanceof ResponseBodyEmitter) {
            emitter = (ResponseBodyEmitter)returnValue;
        } else if (returnType != null) {
            emitter = this.reactiveHandler.handleValue(returnValue, returnType, request);
            if (emitter == null) {
                return;
            }
        } else {
            throw new UnsupportedOperationException("Unsupported handler: '%s' and its return-value: '%s'".formatted(handler, returnValue));
        }
        emitter.extendResponse(request);
        try {
            DeferredResult deferredResult = new DeferredResult(emitter.getTimeout());
            request.getAsyncManager().startDeferredResultProcessing(deferredResult, handler);
            responseBodyEmitter = new HttpMessageConvertingHandler(request, deferredResult);
        }
        catch (Throwable ex) {
            emitter.initializeWithError(ex);
            throw ex;
        }
        emitter.initialize(responseBodyEmitter);
    }

    private class HttpMessageConvertingHandler
    implements ResponseBodyEmitter.Handler {
        private final RequestContext request;
        private final DeferredResult<?> deferredResult;

        public HttpMessageConvertingHandler(RequestContext request, DeferredResult<?> deferredResult) {
            this.request = request;
            this.deferredResult = deferredResult;
        }

        @Override
        public void send(Object data, @Nullable MediaType mediaType) throws IOException {
            this.sendInternal(data, mediaType);
            this.request.flush();
        }

        @Override
        public void send(Collection<ResponseBodyEmitter.DataWithMediaType> items) throws IOException {
            for (ResponseBodyEmitter.DataWithMediaType item : items) {
                this.sendInternal(item.data, item.mediaType);
            }
            this.request.flush();
        }

        private void sendInternal(Object data, @Nullable MediaType mediaType) throws IOException {
            Class<?> dataClass = data.getClass();
            for (HttpMessageConverter<?> converter : ResponseBodyEmitterReturnValueHandler.this.sseMessageConverters) {
                if (!converter.canWrite(dataClass, mediaType)) continue;
                converter.write(data, mediaType, this.request.asHttpOutputMessage());
                return;
            }
            throw new IllegalArgumentException("No suitable converter for " + data.getClass());
        }

        @Override
        public void complete() {
            try {
                this.request.flush();
                this.deferredResult.setResult(null);
            }
            catch (IOException ex) {
                this.deferredResult.setErrorResult(ex);
            }
        }

        @Override
        public void completeWithError(Throwable failure) {
            this.deferredResult.setErrorResult(failure);
        }

        @Override
        public void onTimeout(Runnable callback) {
            this.deferredResult.onTimeout(callback);
        }

        @Override
        public void onError(Consumer<Throwable> callback) {
            this.deferredResult.onError(callback);
        }

        @Override
        public void onCompletion(Runnable callback) {
            this.deferredResult.onCompletion(callback);
        }
    }
}

