/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.method;

import infra.http.MediaType;
import infra.lang.Nullable;
import infra.util.ObjectUtils;
import infra.web.RequestContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class ResponseBodyEmitter {
    @Nullable
    private final Long timeout;
    @Nullable
    private Handler handler;
    private final ArrayList<DataWithMediaType> earlySendAttempts = new ArrayList();
    private final AtomicBoolean complete = new AtomicBoolean();
    @Nullable
    private Throwable failure;
    private final DefaultCallback timeoutCallback = new DefaultCallback();
    private final ErrorCallback errorCallback = new ErrorCallback();
    private final DefaultCallback completionCallback = new DefaultCallback();

    public ResponseBodyEmitter() {
        this.timeout = null;
    }

    public ResponseBodyEmitter(@Nullable Long timeout) {
        this.timeout = timeout;
    }

    @Nullable
    public Long getTimeout() {
        return this.timeout;
    }

    synchronized void initialize(Handler handler) throws IOException {
        this.handler = handler;
        try {
            this.sendInternal(this.earlySendAttempts);
        }
        finally {
            this.earlySendAttempts.clear();
        }
        if (this.complete.get()) {
            if (this.failure != null) {
                handler.completeWithError(this.failure);
            } else {
                handler.complete();
            }
        } else {
            handler.onTimeout(this.timeoutCallback);
            handler.onError(this.errorCallback);
            handler.onCompletion(this.completionCallback);
        }
    }

    void initializeWithError(Throwable ex) {
        if (this.complete.compareAndSet(false, true)) {
            this.failure = ex;
            this.earlySendAttempts.clear();
            this.errorCallback.accept(ex);
        }
    }

    protected void extendResponse(RequestContext outputMessage) {
    }

    public void send(Object object) throws IOException {
        this.send(object, null);
    }

    public synchronized void send(Object object, @Nullable MediaType mediaType) throws IOException {
        if (this.complete.get()) {
            throw new IllegalStateException("ResponseBodyEmitter has already completed%s".formatted(this.failure != null ? " with error: " + this.failure : ""));
        }
        if (this.handler != null) {
            try {
                this.handler.send(object, mediaType);
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to send " + object, ex);
            }
        } else {
            this.earlySendAttempts.add(new DataWithMediaType(object, mediaType));
        }
    }

    public synchronized void send(Collection<DataWithMediaType> items) throws IOException {
        if (this.complete.get()) {
            throw new IllegalStateException("ResponseBodyEmitter has already completed%s".formatted(this.failure != null ? " with error: " + this.failure : ""));
        }
        this.sendInternal(items);
    }

    private void sendInternal(Collection<DataWithMediaType> items) throws IOException {
        if (items.isEmpty()) {
            return;
        }
        if (this.handler != null) {
            try {
                this.handler.send(items);
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to send " + items, ex);
            }
        } else {
            this.earlySendAttempts.addAll(items);
        }
    }

    public void complete() {
        if (this.complete.compareAndSet(false, true) && this.handler != null) {
            this.handler.complete();
        }
    }

    public void completeWithError(Throwable ex) {
        if (this.complete.compareAndSet(false, true)) {
            this.failure = ex;
            if (this.handler != null) {
                this.handler.completeWithError(ex);
            }
        }
    }

    public void onTimeout(Runnable callback) {
        this.timeoutCallback.addDelegate(callback);
    }

    public void onError(Consumer<Throwable> callback) {
        this.errorCallback.addDelegate(callback);
    }

    public void onCompletion(Runnable callback) {
        this.completionCallback.addDelegate(callback);
    }

    public String toString() {
        return "ResponseBodyEmitter@" + ObjectUtils.getIdentityHexString((Object)this);
    }

    private class DefaultCallback
    implements Runnable {
        private final ArrayList<Runnable> delegates = new ArrayList(1);

        private DefaultCallback() {
        }

        public synchronized void addDelegate(Runnable delegate) {
            this.delegates.add(delegate);
        }

        @Override
        public void run() {
            ResponseBodyEmitter.this.complete.compareAndSet(false, true);
            for (Runnable delegate : this.delegates) {
                delegate.run();
            }
        }
    }

    private class ErrorCallback
    implements Consumer<Throwable> {
        private final ArrayList<Consumer<Throwable>> delegates = new ArrayList(1);

        private ErrorCallback() {
        }

        public synchronized void addDelegate(Consumer<Throwable> callback) {
            this.delegates.add(callback);
        }

        @Override
        public void accept(Throwable t) {
            ResponseBodyEmitter.this.complete.compareAndSet(false, true);
            for (Consumer<Throwable> delegate : this.delegates) {
                delegate.accept(t);
            }
        }
    }

    static interface Handler {
        public void send(Object var1, @Nullable MediaType var2) throws IOException;

        public void send(Collection<DataWithMediaType> var1) throws IOException;

        public void complete();

        public void completeWithError(Throwable var1);

        public void onTimeout(Runnable var1);

        public void onError(Consumer<Throwable> var1);

        public void onCompletion(Runnable var1);
    }

    public static class DataWithMediaType {
        public final Object data;
        @Nullable
        public final MediaType mediaType;

        public DataWithMediaType(Object data, @Nullable MediaType mediaType) {
            this.data = data;
            this.mediaType = mediaType;
        }
    }
}

