/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.method;

import infra.core.MethodParameter;
import infra.core.ParameterNameDiscoverer;
import infra.core.annotation.SynthesizingMethodParameter;
import infra.lang.Assert;
import infra.util.ObjectUtils;
import infra.web.handler.method.HandlerMethod;
import infra.web.handler.method.ResolvableMethodParameter;
import java.lang.reflect.Method;
import java.util.HashMap;

public class ResolvableParameterFactory {
    private static final ResolvableMethodParameter[] EMPTY = new ResolvableMethodParameter[0];
    private final ParameterNameDiscoverer parameterNameDiscoverer;
    private final HashMap<Method, ResolvableMethodParameter[]> cache = new HashMap();

    public ResolvableParameterFactory() {
        this(ParameterNameDiscoverer.getSharedInstance());
    }

    public ResolvableParameterFactory(ParameterNameDiscoverer parameterNameDiscoverer) {
        Assert.notNull((Object)parameterNameDiscoverer, (String)"parameterNameDiscoverer is required");
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public ResolvableMethodParameter[] createArray(Method method) {
        int length = method.getParameterCount();
        if (length == 0) {
            return EMPTY;
        }
        ResolvableMethodParameter[] ret = new ResolvableMethodParameter[length];
        for (int i = 0; i < length; ++i) {
            SynthesizingMethodParameter parameter = new SynthesizingMethodParameter(method, i);
            parameter.initParameterNameDiscovery(this.parameterNameDiscoverer);
            ret[i] = this.createParameter((MethodParameter)parameter);
        }
        return ret;
    }

    public ResolvableMethodParameter[] createArray(HandlerMethod handlerMethod) {
        Object[] parameters = handlerMethod.getMethodParameters();
        if (ObjectUtils.isEmpty((Object[])parameters)) {
            return EMPTY;
        }
        int i = 0;
        ResolvableMethodParameter[] ret = new ResolvableMethodParameter[parameters.length];
        for (Object parameter : parameters) {
            parameter.initParameterNameDiscovery(this.parameterNameDiscoverer);
            ret[i++] = this.createParameter((MethodParameter)parameter);
        }
        return ret;
    }

    public ResolvableMethodParameter[] getParameters(HandlerMethod handlerMethod) {
        Method method = handlerMethod.getMethod();
        if (method.getParameterCount() == 0) {
            return EMPTY;
        }
        ResolvableMethodParameter[] parameters = this.cache.get(method);
        if (parameters == null) {
            parameters = this.createArray(handlerMethod);
            this.cache.put(method, parameters);
        }
        return parameters;
    }

    public ResolvableMethodParameter createParameter(MethodParameter parameter) {
        return new ResolvableMethodParameter(parameter);
    }
}

