/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.method;

import infra.core.AttributeAccessorSupport;
import infra.core.MethodParameter;
import infra.core.ResolvableType;
import infra.core.TypeDescriptor;
import infra.core.annotation.MergedAnnotation;
import infra.core.annotation.MergedAnnotations;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.StringUtils;
import infra.web.RequestContext;
import infra.web.annotation.RequestParam;
import infra.web.handler.method.NamedValueInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;

public class ResolvableMethodParameter
extends AttributeAccessorSupport {
    @Nullable
    protected TypeDescriptor typeDescriptor;
    private final MethodParameter parameter;
    @Nullable
    private NamedValueInfo namedValueInfo;
    @Nullable
    private ResolvableType resolvableType;
    @Nullable
    private ResolvableMethodParameter nestedParam;

    public ResolvableMethodParameter(ResolvableMethodParameter other) {
        this.parameter = other.parameter;
        this.resolvableType = other.resolvableType;
        this.namedValueInfo = other.namedValueInfo;
        this.typeDescriptor = other.typeDescriptor;
        this.nestedParam = other.nestedParam;
    }

    public ResolvableMethodParameter(MethodParameter parameter) {
        this.parameter = parameter;
    }

    ResolvableMethodParameter(ResolvableMethodParameter other, MethodParameter parameter) {
        this.parameter = parameter;
        this.nestedParam = other.nestedParam;
        this.resolvableType = other.resolvableType;
        this.namedValueInfo = other.namedValueInfo;
        this.typeDescriptor = other.typeDescriptor;
    }

    public boolean isArray() {
        return this.getParameterType().isArray();
    }

    public boolean isCollection() {
        return CollectionUtils.isCollection(this.getParameterType());
    }

    public boolean isInterface() {
        return this.getParameterType().isInterface();
    }

    public boolean is(Class<?> type) {
        return type == this.getParameterType();
    }

    public boolean isAssignableTo(Class<?> superClass) {
        return superClass.isAssignableFrom(this.getParameterType());
    }

    public boolean isInstance(Object obj) {
        return this.getParameterType().isInstance(obj);
    }

    public Annotation[] getMethodAnnotations() {
        return this.parameter.getMethodAnnotations();
    }

    @Nullable
    public <A extends Annotation> A getMethodAnnotation(Class<A> annotationType) {
        return (A)this.parameter.getMethodAnnotation(annotationType);
    }

    public <A extends Annotation> boolean hasMethodAnnotation(Class<A> annotationType) {
        return this.parameter.hasMethodAnnotation(annotationType);
    }

    public Annotation[] getParameterAnnotations() {
        return this.parameter.getParameterAnnotations();
    }

    public boolean hasParameterAnnotations() {
        return this.parameter.hasParameterAnnotations();
    }

    public boolean hasParameterAnnotation(Class<? extends Annotation> annotationType) {
        return this.parameter.hasParameterAnnotation(annotationType);
    }

    @Nullable
    public <A extends Annotation> A getParameterAnnotation(Class<A> annotationType) {
        return (A)this.parameter.getParameterAnnotation(annotationType);
    }

    public ResolvableType getResolvableType() {
        ResolvableType resolvableType = this.resolvableType;
        if (resolvableType == null) {
            this.resolvableType = resolvableType = ResolvableType.forMethodParameter((MethodParameter)this.getParameter());
        }
        return resolvableType;
    }

    public boolean hasNamedValueInfo() {
        return this.namedValueInfo != null;
    }

    public NamedValueInfo getNamedValueInfo() {
        NamedValueInfo namedValueInfo = this.namedValueInfo;
        if (namedValueInfo == null) {
            namedValueInfo = this.createNamedValueInfo();
            this.namedValueInfo = namedValueInfo = this.updateNamedValueInfo(namedValueInfo);
        }
        return namedValueInfo;
    }

    public boolean isRequired() {
        return this.getNamedValueInfo().required;
    }

    public boolean isNotRequired() {
        return !this.isRequired();
    }

    public String getName() {
        return this.getNamedValueInfo().name;
    }

    @Nullable
    public String getDefaultValue() {
        return this.getNamedValueInfo().defaultValue;
    }

    public void withNamedValueInfo(NamedValueInfo namedValueInfo) {
        this.namedValueInfo = namedValueInfo;
    }

    protected NamedValueInfo createNamedValueInfo() {
        MergedAnnotation requestParam = MergedAnnotations.from((Annotation[])this.getParameterAnnotations()).get(RequestParam.class);
        if (requestParam.isPresent()) {
            String name = requestParam.getString("name");
            boolean required = requestParam.getBoolean("required");
            String defaultValue = requestParam.getString("defaultValue");
            return new NamedValueInfo(name, required, defaultValue);
        }
        return new NamedValueInfo(this.getParameterName());
    }

    private NamedValueInfo updateNamedValueInfo(NamedValueInfo info) {
        boolean required;
        String name = info.name;
        if (StringUtils.isEmpty((CharSequence)name) || "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(name)) {
            name = this.getParameterName();
        }
        if (required = info.required) {
            required = !this.parameter.isNullable();
        }
        String defaultValue = "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(info.defaultValue) ? null : info.defaultValue;
        return new NamedValueInfo(name, required, defaultValue);
    }

    public String getParameterName() {
        String name = this.parameter.getParameterName();
        if (name == null) {
            throw new IllegalArgumentException("Name for argument of type [%s] not specified, and parameter name information not available via reflection. Ensure that the compiler uses the '-parameters' flag.".formatted(this.parameter.getNestedParameterType().getName()));
        }
        return name;
    }

    public int getParameterIndex() {
        return this.parameter.getParameterIndex();
    }

    public Method getMethod() {
        return this.parameter.getMethod();
    }

    @Nullable
    public Object resolveParameter(RequestContext request) throws Throwable {
        return request.getParameter(this.getName());
    }

    public Class<?> getParameterType() {
        return this.parameter.getParameterType();
    }

    public Class<?> getComponentType() {
        return this.getParameterType().getComponentType();
    }

    public MethodParameter getParameter() {
        return this.parameter;
    }

    public boolean isOptional() {
        return this.parameter.isOptional();
    }

    public boolean isNullable() {
        return this.parameter.isNullable();
    }

    public ResolvableMethodParameter nestedIfOptional() {
        return this.getParameterType() == Optional.class ? this.nested() : this;
    }

    public ResolvableMethodParameter nested() {
        return this.nested((Integer)null);
    }

    public ResolvableMethodParameter nested(@Nullable Integer typeIndex) {
        ResolvableMethodParameter nestedParam = this.nestedParam;
        if (nestedParam != null && typeIndex == null) {
            return nestedParam;
        }
        MethodParameter methodParameter = this.parameter.nested(typeIndex);
        nestedParam = methodParameter == this.parameter ? this : this.nested(methodParameter);
        if (typeIndex == null) {
            this.nestedParam = nestedParam;
        }
        return nestedParam;
    }

    protected ResolvableMethodParameter nested(MethodParameter parameter) {
        return new ResolvableMethodParameter(this, parameter);
    }

    public TypeDescriptor getTypeDescriptor() {
        TypeDescriptor typeDescriptor = this.typeDescriptor;
        if (typeDescriptor == null) {
            this.typeDescriptor = typeDescriptor = this.createTypeDescriptor();
        }
        return typeDescriptor;
    }

    protected TypeDescriptor createTypeDescriptor() {
        return new TypeDescriptor(this.parameter);
    }

    public int hashCode() {
        return this.parameter.hashCode();
    }

    public String toString() {
        return "method '%s' parameter %d".formatted(this.getMethod().getName(), this.getParameterIndex());
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ResolvableMethodParameter && Objects.equals(this.parameter, ((ResolvableMethodParameter)((Object)obj)).parameter);
    }
}

