/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.method;

import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.InvalidMediaTypeException;
import infra.http.MediaType;
import infra.util.CollectionUtils;
import infra.util.StringUtils;
import infra.web.HandlerMatchingMetadata;
import infra.web.HttpMediaTypeNotAcceptableException;
import infra.web.HttpMediaTypeNotSupportedException;
import infra.web.HttpRequestMethodNotSupportedException;
import infra.web.RequestContext;
import infra.web.bind.UnsatisfiedRequestParameterException;
import infra.web.handler.condition.NameValueExpression;
import infra.web.handler.condition.PathPatternsRequestCondition;
import infra.web.handler.method.AbstractHandlerMethodMapping;
import infra.web.handler.method.HandlerMethod;
import infra.web.handler.method.RequestMappingInfo;
import infra.web.handler.method.RequestMappingInfoHandlerMethodMappingNamingStrategy;
import infra.web.util.pattern.PathPattern;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class RequestMappingInfoHandlerMapping
extends AbstractHandlerMethodMapping<RequestMappingInfo> {
    private static final Method HTTP_OPTIONS_HANDLE_METHOD;

    protected RequestMappingInfoHandlerMapping() {
        this.setHandlerMethodMappingNamingStrategy(new RequestMappingInfoHandlerMethodMappingNamingStrategy());
    }

    @Override
    protected Set<String> getDirectPaths(RequestMappingInfo info) {
        return info.getDirectPaths();
    }

    @Override
    protected RequestMappingInfo getMatchingMapping(RequestMappingInfo info, RequestContext request) {
        return info.getMatchingCondition(request);
    }

    @Override
    protected Comparator<RequestMappingInfo> getMappingComparator(RequestContext request) {
        return (info1, info2) -> info1.compareTo((RequestMappingInfo)info2, request);
    }

    @Override
    protected void handleMatch(AbstractHandlerMethodMapping.Match<RequestMappingInfo> bestMatch, String directLookupPath, RequestContext request) {
        RequestMappingInfo info = (RequestMappingInfo)bestMatch.mapping;
        PathPatternsRequestCondition pathPatternsCondition = info.getPathPatternsCondition();
        HandlerMatchingMetadata matchingMetadata = new HandlerMatchingMetadata(bestMatch.getHandlerMethod(), directLookupPath, request.getRequestPath(), (PathPattern)CollectionUtils.firstElement((Object[])pathPatternsCondition.getPatterns()), this.getPatternParser());
        request.setMatchingMetadata(matchingMetadata);
        MediaType[] mediaTypes = info.getProducesCondition().getProducibleMediaTypes();
        if (mediaTypes.length > 0) {
            matchingMetadata.setProducibleMediaTypes(mediaTypes);
        }
    }

    @Override
    protected HandlerMethod handleNoMatch(Set<RequestMappingInfo> infos, String lookupPath, RequestContext request) {
        if (CollectionUtils.isEmpty(infos)) {
            return null;
        }
        PartialMatchHelper helper = new PartialMatchHelper(infos, request);
        if (helper.isEmpty()) {
            return null;
        }
        if (helper.hasMethodsMismatch()) {
            Set<String> methods = helper.getAllowedMethods();
            if (HttpMethod.OPTIONS == request.getMethod()) {
                Set<MediaType> mediaTypes = helper.getConsumablePatchMediaTypes();
                HttpOptionsHandler handler = new HttpOptionsHandler(methods, mediaTypes);
                return new HandlerMethod(handler, HTTP_OPTIONS_HANDLE_METHOD);
            }
            throw new HttpRequestMethodNotSupportedException(request.getMethodValue(), methods);
        }
        if (helper.hasConsumesMismatch()) {
            Set<MediaType> mediaTypes = helper.getConsumableMediaTypes();
            MediaType contentType = null;
            if (StringUtils.isNotEmpty((CharSequence)request.getContentType())) {
                try {
                    contentType = MediaType.parseMediaType(request.getContentType());
                }
                catch (InvalidMediaTypeException ex) {
                    throw new HttpMediaTypeNotSupportedException(ex.getMessage(), new ArrayList<MediaType>(mediaTypes));
                }
            }
            throw new HttpMediaTypeNotSupportedException(contentType, new ArrayList<MediaType>(mediaTypes), request.getMethod());
        }
        if (helper.hasProducesMismatch()) {
            Set<MediaType> mediaTypes = helper.getProducibleMediaTypes();
            throw new HttpMediaTypeNotAcceptableException(new ArrayList<MediaType>(mediaTypes));
        }
        if (helper.hasParamsMismatch()) {
            List<String[]> conditions = helper.getParamConditions();
            throw new UnsatisfiedRequestParameterException(conditions, request.getParameters());
        }
        return null;
    }

    static {
        try {
            HTTP_OPTIONS_HANDLE_METHOD = HttpOptionsHandler.class.getMethod("handle", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Failed to retrieve internal handler method for HTTP OPTIONS", ex);
        }
    }

    private static class PartialMatchHelper {
        private final ArrayList<PartialMatch> partialMatches = new ArrayList();

        public PartialMatchHelper(Set<RequestMappingInfo> infos, RequestContext request) {
            for (RequestMappingInfo info : infos) {
                if (info.getPathPatternsCondition().getMatchingCondition(request) == null) continue;
                this.partialMatches.add(new PartialMatch(info, request));
            }
        }

        public boolean isEmpty() {
            return this.partialMatches.isEmpty();
        }

        public boolean hasMethodsMismatch() {
            for (PartialMatch match : this.partialMatches) {
                if (!match.methodsMatch) continue;
                return false;
            }
            return true;
        }

        public boolean hasConsumesMismatch() {
            for (PartialMatch match : this.partialMatches) {
                if (!match.hasConsumesMatch()) continue;
                return false;
            }
            return true;
        }

        public boolean hasProducesMismatch() {
            for (PartialMatch match : this.partialMatches) {
                if (!match.hasProducesMatch()) continue;
                return false;
            }
            return true;
        }

        public boolean hasParamsMismatch() {
            for (PartialMatch match : this.partialMatches) {
                if (!match.hasParamsMatch()) continue;
                return false;
            }
            return true;
        }

        public Set<String> getAllowedMethods() {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (PartialMatch match : this.partialMatches) {
                for (HttpMethod method : match.info.getMethodsCondition().getMethods()) {
                    result.add(method.name());
                }
            }
            return result;
        }

        public Set<MediaType> getConsumableMediaTypes() {
            LinkedHashSet<MediaType> result = new LinkedHashSet<MediaType>();
            for (PartialMatch match : this.partialMatches) {
                if (!match.methodsMatch) continue;
                result.addAll(match.info.getConsumesCondition().getConsumableMediaTypes());
            }
            return result;
        }

        public Set<MediaType> getProducibleMediaTypes() {
            LinkedHashSet<MediaType> result = new LinkedHashSet<MediaType>();
            for (PartialMatch match : this.partialMatches) {
                if (!match.hasConsumesMatch()) continue;
                CollectionUtils.addAll(result, (Object[])match.info.getProducesCondition().getProducibleMediaTypes());
            }
            return result;
        }

        public List<String[]> getParamConditions() {
            ArrayList<String[]> result = new ArrayList<String[]>();
            for (PartialMatch match : this.partialMatches) {
                Set<NameValueExpression> set;
                if (!match.hasProducesMatch() || !CollectionUtils.isNotEmpty(set = match.info.getParamsCondition().getExpressions())) continue;
                int i = 0;
                String[] array = new String[set.size()];
                for (NameValueExpression expression : set) {
                    array[i++] = expression.toString();
                }
                result.add(array);
            }
            return result;
        }

        public Set<MediaType> getConsumablePatchMediaTypes() {
            LinkedHashSet<MediaType> result = new LinkedHashSet<MediaType>();
            for (PartialMatch match : this.partialMatches) {
                Set<HttpMethod> methods = match.info.getMethodsCondition().getMethods();
                if (!methods.isEmpty() && !methods.contains((Object)HttpMethod.PATCH)) continue;
                result.addAll(match.info.getConsumesCondition().getConsumableMediaTypes());
            }
            return result;
        }

        private static class PartialMatch {
            public final RequestMappingInfo info;
            public final boolean methodsMatch;
            private final boolean consumesMatch;
            private final boolean producesMatch;
            private final boolean paramsMatch;

            public PartialMatch(RequestMappingInfo info, RequestContext request) {
                this.info = info;
                this.methodsMatch = info.getMethodsCondition().getMatchingCondition(request) != null;
                this.consumesMatch = info.getConsumesCondition().getMatchingCondition(request) != null;
                this.producesMatch = info.getProducesCondition().getMatchingCondition(request) != null;
                this.paramsMatch = info.getParamsCondition().getMatchingCondition(request) != null;
            }

            public boolean hasConsumesMatch() {
                return this.methodsMatch && this.consumesMatch;
            }

            public boolean hasProducesMatch() {
                return this.hasConsumesMatch() && this.producesMatch;
            }

            public boolean hasParamsMatch() {
                return this.hasProducesMatch() && this.paramsMatch;
            }

            public String toString() {
                return this.info.toString();
            }
        }
    }

    private static class HttpOptionsHandler {
        private final HttpHeaders headers = HttpHeaders.forWritable();

        public HttpOptionsHandler(Set<String> declaredMethods, Set<MediaType> acceptPatch) {
            this.headers.setAllow(HttpOptionsHandler.initAllowedHttpMethods(declaredMethods));
            this.headers.setAcceptPatch(new ArrayList<MediaType>(acceptPatch));
        }

        private static Set<HttpMethod> initAllowedHttpMethods(Set<String> declaredMethods) {
            LinkedHashSet<HttpMethod> result = new LinkedHashSet<HttpMethod>(declaredMethods.size());
            if (declaredMethods.isEmpty()) {
                for (HttpMethod method : HttpMethod.values()) {
                    if (method == HttpMethod.TRACE) continue;
                    result.add(method);
                }
            } else {
                for (String method : declaredMethods) {
                    HttpMethod httpMethod = HttpMethod.valueOf(method);
                    result.add(httpMethod);
                    if (httpMethod != HttpMethod.GET) continue;
                    result.add(HttpMethod.HEAD);
                }
                result.add(HttpMethod.OPTIONS);
            }
            return result;
        }

        public HttpHeaders handle() {
            return this.headers;
        }
    }
}

