/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.method;

import infra.http.HttpMethod;
import infra.lang.Constant;
import infra.lang.Nullable;
import infra.util.ObjectUtils;
import infra.util.StringUtils;
import infra.web.RequestContext;
import infra.web.accept.ContentNegotiationManager;
import infra.web.handler.condition.ConsumesRequestCondition;
import infra.web.handler.condition.HeadersRequestCondition;
import infra.web.handler.condition.ParamsRequestCondition;
import infra.web.handler.condition.PathPatternsRequestCondition;
import infra.web.handler.condition.ProducesRequestCondition;
import infra.web.handler.condition.RequestCondition;
import infra.web.handler.condition.RequestConditionHolder;
import infra.web.handler.condition.RequestMethodsRequestCondition;
import infra.web.util.pattern.PathPatternParser;
import java.util.Set;

public final class RequestMappingInfo
implements RequestCondition<RequestMappingInfo> {
    private static final ParamsRequestCondition EMPTY_PARAMS = new ParamsRequestCondition(new String[0]);
    private static final HeadersRequestCondition EMPTY_HEADERS = new HeadersRequestCondition(new String[0]);
    private static final RequestConditionHolder EMPTY_CUSTOM = new RequestConditionHolder(null);
    private static final ConsumesRequestCondition EMPTY_CONSUMES = new ConsumesRequestCondition(new String[0]);
    private static final ProducesRequestCondition EMPTY_PRODUCES = new ProducesRequestCondition(new String[0]);
    private static final PathPatternsRequestCondition EMPTY_PATH_PATTERNS = new PathPatternsRequestCondition();
    private static final RequestMethodsRequestCondition EMPTY_REQUEST_METHODS = new RequestMethodsRequestCondition(new HttpMethod[0]);
    @Nullable
    private final String name;
    private final RequestMethodsRequestCondition methodsCondition;
    private final PathPatternsRequestCondition pathPatternsCondition;
    private final ParamsRequestCondition paramsCondition;
    private final HeadersRequestCondition headersCondition;
    private final ConsumesRequestCondition consumesCondition;
    private final ProducesRequestCondition producesCondition;
    private final RequestConditionHolder customConditionHolder;
    private final int hashCode;
    private final BuilderConfiguration options;
    private final boolean combine;

    RequestMappingInfo(@Nullable String name, PathPatternsRequestCondition pathPatterns, RequestMethodsRequestCondition methodsCondition, ParamsRequestCondition paramsCondition, HeadersRequestCondition headersCondition, ConsumesRequestCondition consumesCondition, ProducesRequestCondition producesCondition, RequestConditionHolder customCondition, BuilderConfiguration options, boolean combine) {
        this.name = StringUtils.hasText((String)name) ? name : null;
        this.options = options;
        this.paramsCondition = paramsCondition;
        this.methodsCondition = methodsCondition;
        this.headersCondition = headersCondition;
        this.consumesCondition = consumesCondition;
        this.producesCondition = producesCondition;
        this.customConditionHolder = customCondition;
        this.pathPatternsCondition = pathPatterns;
        this.combine = combine;
        this.hashCode = RequestMappingInfo.calculateHashCode(pathPatterns, methodsCondition, paramsCondition, headersCondition, consumesCondition, producesCondition, this.customConditionHolder);
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public PathPatternsRequestCondition getPathPatternsCondition() {
        return this.pathPatternsCondition;
    }

    public Set<String> getDirectPaths() {
        return this.pathPatternsCondition.getDirectPaths();
    }

    public Set<String> getPatternValues() {
        return this.pathPatternsCondition.getPatternValues();
    }

    public RequestMethodsRequestCondition getMethodsCondition() {
        return this.methodsCondition;
    }

    public ParamsRequestCondition getParamsCondition() {
        return this.paramsCondition;
    }

    public HeadersRequestCondition getHeadersCondition() {
        return this.headersCondition;
    }

    public ConsumesRequestCondition getConsumesCondition() {
        return this.consumesCondition;
    }

    public ProducesRequestCondition getProducesCondition() {
        return this.producesCondition;
    }

    @Nullable
    public RequestCondition<?> getCustomCondition() {
        return this.customConditionHolder.getCondition();
    }

    public boolean isCombine() {
        return this.combine;
    }

    public RequestMappingInfo addCustomCondition(RequestCondition<?> customCondition) {
        return new RequestMappingInfo(this.name, this.pathPatternsCondition, this.methodsCondition, this.paramsCondition, this.headersCondition, this.consumesCondition, this.producesCondition, new RequestConditionHolder(customCondition), this.options, this.combine);
    }

    @Override
    public RequestMappingInfo combine(RequestMappingInfo other) {
        String name = this.combineNames(other);
        ParamsRequestCondition params = this.paramsCondition.combine(other.paramsCondition);
        RequestConditionHolder custom = this.customConditionHolder.combine(other.customConditionHolder);
        HeadersRequestCondition headers = this.headersCondition.combine(other.headersCondition);
        ConsumesRequestCondition consumes = this.consumesCondition.combine(other.consumesCondition);
        ProducesRequestCondition produces = this.producesCondition.combine(other.producesCondition);
        RequestMethodsRequestCondition methods = this.methodsCondition.combine(other.methodsCondition);
        PathPatternsRequestCondition pathPatterns = this.pathPatternsCondition.combine(other.pathPatternsCondition);
        return new RequestMappingInfo(name, pathPatterns, methods, params, headers, consumes, produces, custom, this.options, this.combine);
    }

    @Nullable
    private String combineNames(RequestMappingInfo other) {
        if (this.name != null && other.name != null) {
            String separator = "#";
            return this.name + separator + other.name;
        }
        if (this.name != null) {
            return this.name;
        }
        return other.name;
    }

    @Override
    @Nullable
    public RequestMappingInfo getMatchingCondition(RequestContext request) {
        RequestMethodsRequestCondition methods = this.methodsCondition.getMatchingCondition(request);
        if (methods == null) {
            return null;
        }
        ParamsRequestCondition params = this.paramsCondition.getMatchingCondition(request);
        if (params == null) {
            return null;
        }
        HeadersRequestCondition headers = this.headersCondition.getMatchingCondition(request);
        if (headers == null) {
            return null;
        }
        ConsumesRequestCondition consumes = this.consumesCondition.getMatchingCondition(request);
        if (consumes == null) {
            return null;
        }
        ProducesRequestCondition produces = this.producesCondition.getMatchingCondition(request);
        if (produces == null) {
            return null;
        }
        PathPatternsRequestCondition pathPatterns = this.pathPatternsCondition.getMatchingCondition(request);
        if (pathPatterns == null) {
            return null;
        }
        RequestConditionHolder custom = this.customConditionHolder.getMatchingCondition(request);
        if (custom == null) {
            return null;
        }
        return new RequestMappingInfo(this.name, pathPatterns, methods, params, headers, consumes, produces, custom, this.options, this.combine);
    }

    @Override
    public int compareTo(RequestMappingInfo other, RequestContext request) {
        int result;
        if (HttpMethod.HEAD == request.getMethod() && (result = this.methodsCondition.compareTo(other.getMethodsCondition(), request)) != 0) {
            return result;
        }
        result = this.pathPatternsCondition.compareTo(other.getPathPatternsCondition(), request);
        if (result != 0) {
            return result;
        }
        result = this.paramsCondition.compareTo(other.getParamsCondition(), request);
        if (result != 0) {
            return result;
        }
        result = this.headersCondition.compareTo(other.getHeadersCondition(), request);
        if (result != 0) {
            return result;
        }
        result = this.consumesCondition.compareTo(other.getConsumesCondition(), request);
        if (result != 0) {
            return result;
        }
        result = this.producesCondition.compareTo(other.getProducesCondition(), request);
        if (result != 0) {
            return result;
        }
        result = this.methodsCondition.compareTo(other.getMethodsCondition(), request);
        if (result != 0) {
            return result;
        }
        result = this.customConditionHolder.compareTo(other.customConditionHolder, request);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof RequestMappingInfo) {
            RequestMappingInfo otherInfo = (RequestMappingInfo)other;
            return this.combine == otherInfo.combine && this.pathPatternsCondition.equals(otherInfo.pathPatternsCondition) && this.methodsCondition.equals(otherInfo.methodsCondition) && this.paramsCondition.equals(otherInfo.paramsCondition) && this.headersCondition.equals(otherInfo.headersCondition) && this.consumesCondition.equals(otherInfo.consumesCondition) && this.producesCondition.equals(otherInfo.producesCondition) && this.customConditionHolder.equals(otherInfo.customConditionHolder);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private static int calculateHashCode(PathPatternsRequestCondition pathPatterns, RequestMethodsRequestCondition methods, ParamsRequestCondition params, HeadersRequestCondition headers, ConsumesRequestCondition consumes, ProducesRequestCondition produces, RequestConditionHolder custom) {
        return pathPatterns.hashCode() * 31 + methods.hashCode() + params.hashCode() + headers.hashCode() + consumes.hashCode() + produces.hashCode() + custom.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        if (!this.methodsCondition.isEmpty()) {
            Set<HttpMethod> httpMethods = this.methodsCondition.getMethods();
            builder.append(httpMethods.size() == 1 ? httpMethods.iterator().next() : httpMethods);
        }
        builder.append(' ').append(this.getPathPatternsCondition());
        if (!this.paramsCondition.isEmpty()) {
            builder.append(", params ").append(this.paramsCondition);
        }
        if (!this.headersCondition.isEmpty()) {
            builder.append(", headers ").append(this.headersCondition);
        }
        if (!this.consumesCondition.isEmpty()) {
            builder.append(", consumes ").append(this.consumesCondition);
        }
        if (!this.producesCondition.isEmpty()) {
            builder.append(", produces ").append(this.producesCondition);
        }
        if (!this.customConditionHolder.isEmpty()) {
            builder.append(", and ").append(this.customConditionHolder);
        }
        builder.append('}');
        return builder.toString();
    }

    public Builder mutate() {
        return new MutateBuilder(this);
    }

    public static Builder paths(String ... paths) {
        return new DefaultBuilder(paths);
    }

    public static class BuilderConfiguration {
        private PathPatternParser patternParser = PathPatternParser.defaultInstance;
        @Nullable
        private ContentNegotiationManager contentNegotiationManager;

        public void setPatternParser(PathPatternParser patternParser) {
            this.patternParser = patternParser;
        }

        public PathPatternParser getPatternParser() {
            return this.patternParser;
        }

        public void setContentNegotiationManager(ContentNegotiationManager contentNegotiationManager) {
            this.contentNegotiationManager = contentNegotiationManager;
        }

        @Nullable
        public ContentNegotiationManager getContentNegotiationManager() {
            return this.contentNegotiationManager;
        }
    }

    private static class MutateBuilder
    implements Builder {
        @Nullable
        private String name;
        private PathPatternsRequestCondition pathPatternsCondition;
        private RequestMethodsRequestCondition methodsCondition;
        private ParamsRequestCondition paramsCondition;
        private HeadersRequestCondition headersCondition;
        private ConsumesRequestCondition consumesCondition;
        private ProducesRequestCondition producesCondition;
        private RequestConditionHolder customConditionHolder;
        private BuilderConfiguration options;
        private boolean combine;

        public MutateBuilder(RequestMappingInfo other) {
            this.name = other.name;
            this.pathPatternsCondition = other.pathPatternsCondition;
            this.methodsCondition = other.methodsCondition;
            this.paramsCondition = other.paramsCondition;
            this.headersCondition = other.headersCondition;
            this.consumesCondition = other.consumesCondition;
            this.producesCondition = other.producesCondition;
            this.customConditionHolder = other.customConditionHolder;
            this.options = other.options;
        }

        @Override
        public Builder paths(String ... paths) {
            this.pathPatternsCondition = ObjectUtils.isEmpty((Object[])paths) ? EMPTY_PATH_PATTERNS : new PathPatternsRequestCondition(this.options.getPatternParser(), paths);
            return this;
        }

        @Override
        public Builder methods(HttpMethod ... methods) {
            this.methodsCondition = ObjectUtils.isEmpty((Object[])methods) ? EMPTY_REQUEST_METHODS : new RequestMethodsRequestCondition(methods);
            return this;
        }

        @Override
        public Builder params(String ... params) {
            this.paramsCondition = ObjectUtils.isEmpty((Object[])params) ? EMPTY_PARAMS : new ParamsRequestCondition(params);
            return this;
        }

        @Override
        public Builder headers(String ... headers) {
            this.headersCondition = ObjectUtils.isEmpty((Object[])headers) ? EMPTY_HEADERS : new HeadersRequestCondition(headers);
            return this;
        }

        @Override
        public Builder consumes(String ... consumes) {
            this.consumesCondition = ObjectUtils.isEmpty((Object[])consumes) ? EMPTY_CONSUMES : new ConsumesRequestCondition(consumes);
            return this;
        }

        @Override
        public Builder produces(String ... produces) {
            this.producesCondition = ObjectUtils.isEmpty((Object[])produces) ? EMPTY_PRODUCES : new ProducesRequestCondition(produces, null, this.options.getContentNegotiationManager());
            return this;
        }

        @Override
        public Builder mappingName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder customCondition(RequestCondition<?> condition) {
            this.customConditionHolder = new RequestConditionHolder(condition);
            return this;
        }

        @Override
        public Builder options(BuilderConfiguration options) {
            this.options = options;
            return this;
        }

        @Override
        public Builder combine(boolean combine) {
            this.combine = combine;
            return this;
        }

        @Override
        public RequestMappingInfo build() {
            return new RequestMappingInfo(this.name, this.pathPatternsCondition, this.methodsCondition, this.paramsCondition, this.headersCondition, this.consumesCondition, this.producesCondition, this.customConditionHolder, this.options, this.combine);
        }
    }

    private static class DefaultBuilder
    implements Builder {
        private String[] paths;
        private HttpMethod[] methods = new HttpMethod[0];
        private String[] params = Constant.EMPTY_STRING_ARRAY;
        private String[] headers = Constant.EMPTY_STRING_ARRAY;
        private String[] consumes = Constant.EMPTY_STRING_ARRAY;
        private String[] produces = Constant.EMPTY_STRING_ARRAY;
        private boolean hasAccept;
        private boolean hasContentType;
        @Nullable
        private String mappingName;
        @Nullable
        private RequestCondition<?> customCondition;
        private BuilderConfiguration options = new BuilderConfiguration();
        private boolean combine;

        public DefaultBuilder(String ... paths) {
            this.paths = paths;
        }

        @Override
        public Builder paths(String ... paths) {
            this.paths = paths;
            return this;
        }

        @Override
        public DefaultBuilder methods(HttpMethod ... methods) {
            this.methods = methods;
            return this;
        }

        @Override
        public DefaultBuilder params(String ... params) {
            this.params = params;
            return this;
        }

        @Override
        public DefaultBuilder headers(String ... headers) {
            for (String header : headers) {
                this.hasAccept = this.hasAccept || header.contains("Accept") || header.contains("accept");
                this.hasContentType = this.hasContentType || header.contains("Content-Type") || header.contains("content-type");
            }
            this.headers = headers;
            return this;
        }

        @Override
        public DefaultBuilder consumes(String ... consumes) {
            this.consumes = consumes;
            return this;
        }

        @Override
        public DefaultBuilder produces(String ... produces) {
            this.produces = produces;
            return this;
        }

        @Override
        public DefaultBuilder mappingName(String name) {
            this.mappingName = name;
            return this;
        }

        @Override
        public DefaultBuilder customCondition(RequestCondition<?> condition) {
            this.customCondition = condition;
            return this;
        }

        @Override
        public Builder options(BuilderConfiguration options) {
            this.options = options;
            return this;
        }

        @Override
        public Builder combine(boolean combine) {
            this.combine = combine;
            return this;
        }

        @Override
        public RequestMappingInfo build() {
            return new RequestMappingInfo(this.mappingName, ObjectUtils.isEmpty((Object[])this.paths) ? EMPTY_PATH_PATTERNS : new PathPatternsRequestCondition(this.options.getPatternParser(), this.paths), ObjectUtils.isEmpty((Object[])this.methods) ? EMPTY_REQUEST_METHODS : new RequestMethodsRequestCondition(this.methods), ObjectUtils.isEmpty((Object[])this.params) ? EMPTY_PARAMS : new ParamsRequestCondition(this.params), ObjectUtils.isEmpty((Object[])this.headers) ? EMPTY_HEADERS : new HeadersRequestCondition(this.headers), ObjectUtils.isEmpty((Object[])this.consumes) && !this.hasContentType ? EMPTY_CONSUMES : new ConsumesRequestCondition(this.consumes, this.headers), ObjectUtils.isEmpty((Object[])this.produces) && !this.hasAccept ? EMPTY_PRODUCES : new ProducesRequestCondition(this.produces, this.headers, this.options.getContentNegotiationManager()), this.customCondition == null ? EMPTY_CUSTOM : new RequestConditionHolder(this.customCondition), this.options, this.combine);
        }
    }

    public static interface Builder {
        public Builder paths(String ... var1);

        public Builder methods(HttpMethod ... var1);

        public Builder params(String ... var1);

        public Builder headers(String ... var1);

        public Builder consumes(String ... var1);

        public Builder produces(String ... var1);

        public Builder mappingName(String var1);

        public Builder customCondition(RequestCondition<?> var1);

        public Builder options(BuilderConfiguration var1);

        public Builder combine(boolean var1);

        public RequestMappingInfo build();
    }
}

