/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.method;

import infra.context.ApplicationContext;
import infra.context.MessageSource;
import infra.core.ParameterNameDiscoverer;
import infra.core.StringValueResolver;
import infra.core.annotation.AnnotatedElementUtils;
import infra.core.annotation.MergedAnnotation;
import infra.core.annotation.MergedAnnotations;
import infra.core.annotation.RepeatableContainers;
import infra.http.HttpMethod;
import infra.lang.Assert;
import infra.lang.Constant;
import infra.lang.Nullable;
import infra.stereotype.Controller;
import infra.util.CollectionUtils;
import infra.util.StringUtils;
import infra.web.accept.ContentNegotiationManager;
import infra.web.annotation.CrossOrigin;
import infra.web.annotation.RequestBody;
import infra.web.annotation.RequestMapping;
import infra.web.bind.resolver.ParameterResolvingRegistry;
import infra.web.cors.CorsConfiguration;
import infra.web.handler.condition.ConsumesRequestCondition;
import infra.web.handler.condition.RequestCondition;
import infra.web.handler.method.HandlerMethod;
import infra.web.handler.method.InvocableHandlerMethod;
import infra.web.handler.method.RegistryResolvableParameterFactory;
import infra.web.handler.method.RequestMappingInfo;
import infra.web.handler.method.RequestMappingInfoHandlerMapping;
import infra.web.handler.method.ResolvableParameterFactory;
import infra.web.service.annotation.HttpExchange;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;

public class RequestMappingHandlerMapping
extends RequestMappingInfoHandlerMapping {
    private static final HttpMethod[] EMPTY_REQUEST_METHOD_ARRAY = new HttpMethod[0];
    private Map<String, Predicate<Class<?>>> pathPrefixes = Collections.emptyMap();
    private ContentNegotiationManager contentNegotiationManager = new ContentNegotiationManager();
    private final RequestMappingInfo.BuilderConfiguration config = new RequestMappingInfo.BuilderConfiguration();
    @Nullable
    private ParameterResolvingRegistry resolvingRegistry;
    private ResolvableParameterFactory parameterFactory;
    private ParameterNameDiscoverer parameterNameDiscoverer = ParameterNameDiscoverer.getSharedInstance();

    public void setPathPrefixes(Map<String, Predicate<Class<?>>> prefixes) {
        this.pathPrefixes = prefixes.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap(prefixes));
    }

    public Map<String, Predicate<Class<?>>> getPathPrefixes() {
        return this.pathPrefixes;
    }

    public void setContentNegotiationManager(ContentNegotiationManager contentNegotiationManager) {
        Assert.notNull((Object)contentNegotiationManager, (String)"ContentNegotiationManager is required");
        this.contentNegotiationManager = contentNegotiationManager;
        this.config.setContentNegotiationManager(contentNegotiationManager);
    }

    public ContentNegotiationManager getContentNegotiationManager() {
        return this.contentNegotiationManager;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public void setResolvingRegistry(@Nullable ParameterResolvingRegistry resolvingRegistry) {
        this.resolvingRegistry = resolvingRegistry;
    }

    @Override
    public void afterPropertiesSet() {
        ApplicationContext context = this.obtainApplicationContext();
        if (this.resolvingRegistry == null) {
            this.resolvingRegistry = ParameterResolvingRegistry.get(context);
        }
        this.parameterFactory = new RegistryResolvableParameterFactory(this.resolvingRegistry, this.parameterNameDiscoverer);
        this.config.setPatternParser(this.getPatternParser());
        this.config.setContentNegotiationManager(this.getContentNegotiationManager());
        super.afterPropertiesSet();
    }

    public RequestMappingInfo.BuilderConfiguration getBuilderConfiguration() {
        return this.config;
    }

    @Override
    protected boolean isHandler(Class<?> beanType) {
        MergedAnnotations annotations = MergedAnnotations.from(beanType, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY, (RepeatableContainers)RepeatableContainers.NONE);
        return annotations.isPresent(Controller.class) || annotations.isPresent(RequestMapping.class);
    }

    @Override
    protected HandlerMethod createHandlerMethod(Object handler, Method method) {
        if (handler instanceof String) {
            String beanName = (String)handler;
            ApplicationContext context = this.obtainApplicationContext();
            return new InvocableHandlerMethod(beanName, context.getBeanFactory(), (MessageSource)context, method, this.parameterFactory);
        }
        return new InvocableHandlerMethod(handler, method, this.parameterFactory);
    }

    @Override
    @Nullable
    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo info = this.createRequestMappingInfo(method);
        if (info != null) {
            String prefix;
            RequestMappingInfo typeInfo;
            if (info.isCombine() && (typeInfo = this.createRequestMappingInfo(handlerType)) != null) {
                info = typeInfo.combine(info);
            }
            if (info.getPathPatternsCondition().isEmptyPathMapping()) {
                info = info.mutate().paths("", "/").options(this.config).build();
            }
            if ((prefix = this.getPathPrefix(handlerType)) != null) {
                info = RequestMappingInfo.paths(prefix).options(this.config).build().combine(info);
            }
        }
        return info;
    }

    @Nullable
    String getPathPrefix(Class<?> handlerType) {
        for (Map.Entry<String, Predicate<Class<?>>> entry : this.pathPrefixes.entrySet()) {
            if (!entry.getValue().test(handlerType)) continue;
            String prefix = entry.getKey();
            return this.resolveEmbeddedVariables(prefix);
        }
        return null;
    }

    @Nullable
    private RequestMappingInfo createRequestMappingInfo(AnnotatedElement element) {
        RequestMapping requestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, RequestMapping.class);
        if (requestMapping != null) {
            return this.createRequestMappingInfo(requestMapping, this.getCustomCondition(element));
        }
        HttpExchange httpExchange = (HttpExchange)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, HttpExchange.class);
        if (httpExchange != null) {
            return this.createRequestMappingInfo(httpExchange, this.getCustomCondition(element));
        }
        return null;
    }

    @Nullable
    protected RequestCondition<?> getCustomCondition(AnnotatedElement element) {
        return null;
    }

    protected RequestMappingInfo createRequestMappingInfo(RequestMapping requestMapping, @Nullable RequestCondition<?> customCondition) {
        RequestMappingInfo.Builder builder = RequestMappingInfo.paths(this.resolveEmbeddedValuesInPatterns(requestMapping.path())).params(requestMapping.params()).methods(requestMapping.method()).combine(requestMapping.combine()).headers(requestMapping.headers()).consumes(requestMapping.consumes()).produces(requestMapping.produces()).mappingName(requestMapping.name());
        if (customCondition != null) {
            builder.customCondition(customCondition);
        }
        return builder.options(this.config).build();
    }

    protected RequestMappingInfo createRequestMappingInfo(HttpExchange httpExchange, @Nullable RequestCondition<?> customCondition) {
        RequestMappingInfo.Builder builder = RequestMappingInfo.paths(this.resolveEmbeddedValuesInPatterns(RequestMappingHandlerMapping.toStringArray(httpExchange.value()))).methods(RequestMappingHandlerMapping.toMethodArray(httpExchange.method())).consumes(RequestMappingHandlerMapping.toStringArray(httpExchange.contentType())).combine(true).produces(httpExchange.accept()).headers(httpExchange.headers());
        if (customCondition != null) {
            builder.customCondition(customCondition);
        }
        return builder.options(this.config).build();
    }

    private static String[] toStringArray(String value) {
        String[] stringArray;
        if (StringUtils.hasText((String)value)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = value;
        } else {
            stringArray = Constant.EMPTY_STRING_ARRAY;
        }
        return stringArray;
    }

    private static HttpMethod[] toMethodArray(String method) {
        HttpMethod[] httpMethodArray;
        if (StringUtils.hasText((String)method)) {
            HttpMethod[] httpMethodArray2 = new HttpMethod[1];
            httpMethodArray = httpMethodArray2;
            httpMethodArray2[0] = HttpMethod.valueOf(method);
        } else {
            httpMethodArray = EMPTY_REQUEST_METHOD_ARRAY;
        }
        return httpMethodArray;
    }

    protected String[] resolveEmbeddedValuesInPatterns(String[] patterns) {
        StringValueResolver embeddedValueResolver = this.embeddedValueResolver;
        if (embeddedValueResolver == null) {
            return patterns;
        }
        String[] resolvedPatterns = new String[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            resolvedPatterns[i] = embeddedValueResolver.resolveStringValue(patterns[i]);
        }
        return resolvedPatterns;
    }

    @Override
    public void registerMapping(RequestMappingInfo mapping, Object handler, Method method) {
        super.registerMapping(mapping, handler, method);
        this.updateConsumesCondition(mapping, method);
    }

    @Override
    protected void registerHandlerMethod(Object handler, Method method, RequestMappingInfo mapping) {
        super.registerHandlerMethod(handler, method, mapping);
        this.updateConsumesCondition(mapping, method);
    }

    private void updateConsumesCondition(RequestMappingInfo info, Method method) {
        ConsumesRequestCondition condition = info.getConsumesCondition();
        if (!condition.isEmpty()) {
            for (Parameter parameter : method.getParameters()) {
                MergedAnnotation annot = MergedAnnotations.from((AnnotatedElement)parameter).get(RequestBody.class);
                if (!annot.isPresent()) continue;
                condition.setBodyRequired(annot.getBoolean("required"));
                break;
            }
        }
    }

    @Override
    protected CorsConfiguration initCorsConfiguration(Object handler, HandlerMethod handlerMethod, Method method, RequestMappingInfo mappingInfo) {
        Class<?> beanType = handlerMethod.getBeanType();
        CrossOrigin typeAnnotation = (CrossOrigin)AnnotatedElementUtils.findMergedAnnotation(beanType, CrossOrigin.class);
        CrossOrigin methodAnnotation = (CrossOrigin)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, CrossOrigin.class);
        if (typeAnnotation == null && methodAnnotation == null) {
            return null;
        }
        CorsConfiguration config = new CorsConfiguration();
        this.updateCorsConfig(config, typeAnnotation);
        this.updateCorsConfig(config, methodAnnotation);
        if (CollectionUtils.isEmpty(config.getAllowedMethods())) {
            for (HttpMethod allowedMethod : mappingInfo.getMethodsCondition().getMethods()) {
                config.addAllowedMethod(allowedMethod.name());
            }
        }
        return config.applyPermitDefaultValues();
    }

    private void updateCorsConfig(CorsConfiguration config, @Nullable CrossOrigin annotation) {
        if (annotation == null) {
            return;
        }
        for (String string : annotation.origins()) {
            config.addAllowedOrigin(this.resolveCorsAnnotationValue(string));
        }
        for (String string : annotation.originPatterns()) {
            config.addAllowedOriginPattern(this.resolveCorsAnnotationValue(string));
        }
        for (HttpMethod httpMethod : annotation.methods()) {
            config.addAllowedMethod(httpMethod.name());
        }
        for (String string : annotation.allowedHeaders()) {
            config.addAllowedHeader(this.resolveCorsAnnotationValue(string));
        }
        for (String string : annotation.exposedHeaders()) {
            config.addExposedHeader(this.resolveCorsAnnotationValue(string));
        }
        String string = this.resolveCorsAnnotationValue(annotation.allowCredentials());
        if ("true".equalsIgnoreCase(string)) {
            config.setAllowCredentials(true);
        } else if ("false".equalsIgnoreCase(string)) {
            config.setAllowCredentials(false);
        } else if (!string.isEmpty()) {
            throw new IllegalStateException("@CrossOrigin's allowCredentials value must be \"true\", \"false\", or an empty string (\"\"): current value is [%s]".formatted(string));
        }
        if (annotation.maxAge() >= 0L) {
            config.setMaxAge(annotation.maxAge());
        }
    }

    private String resolveCorsAnnotationValue(String value) {
        if (this.embeddedValueResolver != null) {
            String resolved = this.embeddedValueResolver.resolveStringValue(value);
            return resolved != null ? resolved : "";
        }
        return value;
    }
}

