/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.method;

import infra.beans.factory.BeanFactory;
import infra.beans.factory.BeanFactoryAware;
import infra.beans.factory.InitializingBean;
import infra.beans.factory.config.ConfigurableBeanFactory;
import infra.context.ApplicationContext;
import infra.core.ParameterNameDiscoverer;
import infra.lang.Nullable;
import infra.session.SessionManager;
import infra.session.WebSession;
import infra.web.RedirectModel;
import infra.web.RedirectModelManager;
import infra.web.RequestContext;
import infra.web.RequestContextUtils;
import infra.web.bind.resolver.ParameterResolvingRegistry;
import infra.web.bind.support.WebBindingInitializer;
import infra.web.handler.method.AbstractHandlerMethodAdapter;
import infra.web.handler.method.ControllerMethodResolver;
import infra.web.handler.method.HandlerMethod;
import infra.web.handler.method.InitBinderBindingContext;
import infra.web.handler.method.InvocableHandlerMethod;
import infra.web.handler.method.ModelHandler;
import infra.web.handler.method.RegistryResolvableParameterFactory;
import infra.web.util.WebUtils;
import java.util.Map;

public class RequestMappingHandlerAdapter
extends AbstractHandlerMethodAdapter
implements BeanFactoryAware,
InitializingBean {
    @Nullable
    private ParameterResolvingRegistry resolvingRegistry;
    @Nullable
    private WebBindingInitializer webBindingInitializer;
    private boolean synchronizeOnSession = false;
    private ParameterNameDiscoverer parameterNameDiscoverer = ParameterNameDiscoverer.getSharedInstance();
    @Nullable
    private ConfigurableBeanFactory beanFactory;
    @Nullable
    private SessionManager sessionManager;
    @Nullable
    private RedirectModelManager redirectModelManager;
    private ControllerMethodResolver methodResolver;
    private ModelHandler modelHandler;

    public void setRedirectModelManager(@Nullable RedirectModelManager redirectModelManager) {
        this.redirectModelManager = redirectModelManager;
    }

    public void setResolvingRegistry(@Nullable ParameterResolvingRegistry resolvingRegistry) {
        this.resolvingRegistry = resolvingRegistry;
    }

    public void setWebBindingInitializer(@Nullable WebBindingInitializer webBindingInitializer) {
        this.webBindingInitializer = webBindingInitializer;
    }

    @Nullable
    public WebBindingInitializer getWebBindingInitializer() {
        return this.webBindingInitializer;
    }

    public void setSynchronizeOnSession(boolean synchronizeOnSession) {
        this.synchronizeOnSession = synchronizeOnSession;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.beanFactory = (ConfigurableBeanFactory)beanFactory;
        }
    }

    @Nullable
    protected ConfigurableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setSessionManager(@Nullable SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void afterPropertiesSet() {
        ApplicationContext context = this.obtainApplicationContext();
        if (this.resolvingRegistry == null) {
            this.resolvingRegistry = ParameterResolvingRegistry.get(context);
        }
        this.methodResolver = new ControllerMethodResolver(context, new RegistryResolvableParameterFactory(this.resolvingRegistry, this.parameterNameDiscoverer));
        this.modelHandler = new ModelHandler(this.methodResolver);
    }

    @Override
    protected boolean supportsInternal(HandlerMethod handlerMethod) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object handleInternal(RequestContext request, HandlerMethod handlerMethod) throws Throwable {
        Object returnValue;
        if (this.synchronizeOnSession) {
            WebSession session = this.getSession(request);
            if (session != null) {
                Object mutex;
                Object object = mutex = WebUtils.getSessionMutex(session);
                synchronized (object) {
                    returnValue = this.invokeHandlerMethod(request, handlerMethod);
                }
            } else {
                returnValue = this.invokeHandlerMethod(request, handlerMethod);
            }
        } else {
            returnValue = this.invokeHandlerMethod(request, handlerMethod);
        }
        if (!request.containsResponseHeader("Cache-Control")) {
            this.prepareResponse(request);
        }
        return returnValue;
    }

    @Nullable
    private WebSession getSession(RequestContext request) {
        WebSession session = null;
        if (this.sessionManager != null) {
            session = this.sessionManager.getSession(request, false);
        }
        if (session == null) {
            session = RequestContextUtils.getSession(request, false);
        }
        return session;
    }

    @Nullable
    protected Object invokeHandlerMethod(RequestContext request, HandlerMethod handlerMethod) throws Throwable {
        InitBinderBindingContext binding = new InitBinderBindingContext(this.modelHandler, this.webBindingInitializer, this.methodResolver, handlerMethod);
        request.setBinding(binding);
        RedirectModel inputRedirectModel = request.getInputRedirectModel(this.redirectModelManager);
        if (inputRedirectModel != null) {
            binding.addAllAttributes((Map<String, ?>)((Object)inputRedirectModel));
        }
        binding.initModel(request);
        if (handlerMethod instanceof InvocableHandlerMethod) {
            InvocableHandlerMethod invocableMethod = (InvocableHandlerMethod)handlerMethod;
            return invocableMethod.invokeAndHandle(request);
        }
        return this.methodResolver.createHandlerMethod(handlerMethod).invokeAndHandle(request);
    }
}

