/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.method;

import infra.beans.BeanInstantiationException;
import infra.beans.factory.NoSuchBeanDefinitionException;
import infra.beans.support.BeanInstantiator;
import infra.bytecode.core.NamingPolicy;
import infra.bytecode.proxy.Callback;
import infra.bytecode.proxy.Enhancer;
import infra.bytecode.proxy.Factory;
import infra.bytecode.proxy.MethodInterceptor;
import infra.bytecode.proxy.MethodProxy;
import infra.context.ApplicationContext;
import infra.core.AntPathMatcher;
import infra.core.MethodIntrospector;
import infra.core.MethodParameter;
import infra.core.ParameterNameDiscoverer;
import infra.core.PathMatcher;
import infra.core.annotation.AnnotatedElementUtils;
import infra.core.annotation.SynthesizingMethodParameter;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.util.ObjectUtils;
import infra.util.ReflectionUtils;
import infra.util.StringUtils;
import infra.web.RequestContext;
import infra.web.RequestContextHolder;
import infra.web.annotation.RequestMapping;
import infra.web.bind.resolver.PathVariableMethodArgumentResolver;
import infra.web.bind.resolver.RequestParamMethodArgumentResolver;
import infra.web.handler.method.HandlerMethod;
import infra.web.handler.method.RequestMappingHandlerMapping;
import infra.web.handler.method.RequestMappingInfoHandlerMapping;
import infra.web.handler.method.support.CompositeUriComponentsContributor;
import infra.web.util.UriComponentsBuilder;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;

public class MvcUriComponentsBuilder {
    public static final String MVC_URI_COMPONENTS_CONTRIBUTOR_BEAN_NAME = "mvcUriComponentsContributor";
    private static final Logger logger = LoggerFactory.getLogger(MvcUriComponentsBuilder.class);
    private static final PathMatcher pathMatcher = new AntPathMatcher();
    private static final ParameterNameDiscoverer parameterNameDiscoverer = ParameterNameDiscoverer.getSharedInstance();
    private static final CompositeUriComponentsContributor defaultUriComponentsContributor = new CompositeUriComponentsContributor(new PathVariableMethodArgumentResolver(), new RequestParamMethodArgumentResolver(false));
    private final UriComponentsBuilder baseUrl;

    protected MvcUriComponentsBuilder(UriComponentsBuilder baseUrl) {
        Assert.notNull((Object)baseUrl, (String)"'baseUrl' is required");
        this.baseUrl = baseUrl;
    }

    public static MvcUriComponentsBuilder relativeTo(UriComponentsBuilder baseUrl) {
        return new MvcUriComponentsBuilder(baseUrl);
    }

    public static UriComponentsBuilder fromController(Class<?> controllerType) {
        return MvcUriComponentsBuilder.fromController(null, controllerType);
    }

    public static UriComponentsBuilder fromController(@Nullable UriComponentsBuilder builder, Class<?> controllerType) {
        builder = MvcUriComponentsBuilder.getBaseUrlToUse(builder);
        String prefix = MvcUriComponentsBuilder.getPathPrefix(controllerType);
        builder.path(prefix);
        String mapping = MvcUriComponentsBuilder.getClassMapping(controllerType);
        builder.path(mapping);
        return builder;
    }

    public static UriComponentsBuilder fromMethodName(Class<?> controllerType, String methodName, Object ... args) {
        Method method = MvcUriComponentsBuilder.getMethod(controllerType, methodName, args);
        return MvcUriComponentsBuilder.fromMethodInternal(null, controllerType, method, args);
    }

    public static UriComponentsBuilder fromMethodName(UriComponentsBuilder builder, Class<?> controllerType, String methodName, Object ... args) {
        Method method = MvcUriComponentsBuilder.getMethod(controllerType, methodName, args);
        return MvcUriComponentsBuilder.fromMethodInternal(builder, controllerType, method, args);
    }

    public static UriComponentsBuilder fromMethod(Class<?> controllerType, Method method, Object ... args) {
        return MvcUriComponentsBuilder.fromMethodInternal(null, controllerType, method, args);
    }

    public static UriComponentsBuilder fromMethod(UriComponentsBuilder baseUrl, @Nullable Class<?> controllerType, Method method, Object ... args) {
        return MvcUriComponentsBuilder.fromMethodInternal(baseUrl, controllerType != null ? controllerType : method.getDeclaringClass(), method, args);
    }

    public static UriComponentsBuilder fromMethodCall(Object info) {
        Assert.isInstanceOf(MethodInvocationInfo.class, (Object)info, (String)"MethodInvocationInfo required");
        MethodInvocationInfo invocationInfo = (MethodInvocationInfo)info;
        Class<?> controllerType = invocationInfo.getControllerType();
        Method method = invocationInfo.getControllerMethod();
        Object[] arguments = invocationInfo.getArgumentValues();
        return MvcUriComponentsBuilder.fromMethodInternal(null, controllerType, method, arguments);
    }

    public static UriComponentsBuilder fromMethodCall(UriComponentsBuilder builder, Object info) {
        Assert.isInstanceOf(MethodInvocationInfo.class, (Object)info, (String)"MethodInvocationInfo required");
        MethodInvocationInfo invocationInfo = (MethodInvocationInfo)info;
        Class<?> controllerType = invocationInfo.getControllerType();
        Method method = invocationInfo.getControllerMethod();
        Object[] arguments = invocationInfo.getArgumentValues();
        return MvcUriComponentsBuilder.fromMethodInternal(builder, controllerType, method, arguments);
    }

    public static <T> T on(Class<T> controllerType) {
        return MvcUriComponentsBuilder.controller(controllerType);
    }

    public static <T> T controller(Class<T> controllerType) {
        Assert.notNull(controllerType, (String)"'controllerType' is required");
        return ControllerMethodInvocationInterceptor.initProxy(controllerType, null);
    }

    public static MethodArgumentBuilder fromMappingName(String mappingName) {
        return MvcUriComponentsBuilder.fromMappingName(null, mappingName);
    }

    public static MethodArgumentBuilder fromMappingName(@Nullable UriComponentsBuilder builder, String name) {
        RequestMappingInfoHandlerMapping mapping;
        ApplicationContext wac = MvcUriComponentsBuilder.getApplicationContext();
        Assert.notNull((Object)wac, (String)"No ApplicationContext. ");
        Map map = wac.getBeansOfType(RequestMappingInfoHandlerMapping.class);
        List<HandlerMethod> handlerMethods = null;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext() && (handlerMethods = (mapping = (RequestMappingInfoHandlerMapping)iterator.next()).getHandlerMethodsForMappingName(name)) == null) {
        }
        if (handlerMethods == null) {
            throw new IllegalArgumentException("Mapping not found: " + name);
        }
        if (handlerMethods.size() != 1) {
            throw new IllegalArgumentException("No unique match for mapping %s: %s".formatted(name, handlerMethods));
        }
        HandlerMethod handlerMethod = handlerMethods.get(0);
        Class<?> controllerType = handlerMethod.getBeanType();
        Method method = handlerMethod.getMethod();
        return new MethodArgumentBuilder(builder, controllerType, method);
    }

    public UriComponentsBuilder withController(Class<?> controllerType) {
        return MvcUriComponentsBuilder.fromController(this.baseUrl, controllerType);
    }

    public UriComponentsBuilder withMethodName(Class<?> controllerType, String methodName, Object ... args) {
        return MvcUriComponentsBuilder.fromMethodName(this.baseUrl, controllerType, methodName, args);
    }

    public UriComponentsBuilder withMethodCall(Object invocationInfo) {
        return MvcUriComponentsBuilder.fromMethodCall(this.baseUrl, invocationInfo);
    }

    public MethodArgumentBuilder withMappingName(String mappingName) {
        return MvcUriComponentsBuilder.fromMappingName(this.baseUrl, mappingName);
    }

    public UriComponentsBuilder withMethod(Class<?> controllerType, Method method, Object ... args) {
        return MvcUriComponentsBuilder.fromMethod(this.baseUrl, controllerType, method, args);
    }

    private static UriComponentsBuilder fromMethodInternal(@Nullable UriComponentsBuilder builder, Class<?> controllerType, Method method, Object ... args) {
        builder = MvcUriComponentsBuilder.getBaseUrlToUse(builder);
        String prefix = MvcUriComponentsBuilder.getPathPrefix(controllerType);
        builder.path(prefix);
        String typePath = MvcUriComponentsBuilder.getClassMapping(controllerType);
        String methodPath = MvcUriComponentsBuilder.getMethodMapping(method);
        String path = pathMatcher.combine(typePath, methodPath);
        path = StringUtils.prependLeadingSlash((String)path);
        builder.path(path);
        return MvcUriComponentsBuilder.applyContributors(builder, method, args);
    }

    private static UriComponentsBuilder getBaseUrlToUse(@Nullable UriComponentsBuilder baseUrl) {
        return baseUrl == null ? UriComponentsBuilder.fromHttpRequest(RequestContextHolder.getRequired()) : baseUrl.cloneBuilder();
    }

    private static String getPathPrefix(Class<?> controllerType) {
        ApplicationContext wac = MvcUriComponentsBuilder.getApplicationContext();
        if (wac != null) {
            Map map = wac.getBeansOfType(RequestMappingHandlerMapping.class);
            for (RequestMappingHandlerMapping mapping : map.values()) {
                String prefix;
                if (!mapping.isHandler(controllerType) || (prefix = mapping.getPathPrefix(controllerType)) == null) continue;
                return prefix;
            }
        }
        return "";
    }

    private static String getClassMapping(Class<?> controllerType) {
        Assert.notNull(controllerType, (String)"'controllerType' is required");
        RequestMapping mapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation(controllerType, RequestMapping.class);
        if (mapping == null) {
            return "/";
        }
        Object[] paths = mapping.path();
        if (ObjectUtils.isEmpty((Object[])paths) || StringUtils.isEmpty((CharSequence)paths[0])) {
            return "/";
        }
        if (paths.length > 1 && logger.isTraceEnabled()) {
            logger.trace("Using first of multiple paths on {}", (Object)controllerType.getName());
        }
        return paths[0];
    }

    private static String getMethodMapping(Method method) {
        Assert.notNull((Object)method, (String)"'method' is required");
        RequestMapping requestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
        if (requestMapping == null) {
            throw new IllegalArgumentException("No @RequestMapping on: " + method.toGenericString());
        }
        Object[] paths = requestMapping.path();
        if (ObjectUtils.isEmpty((Object[])paths) || StringUtils.isEmpty((CharSequence)paths[0])) {
            return "";
        }
        if (paths.length > 1 && logger.isTraceEnabled()) {
            logger.trace("Using first of multiple paths on {}", (Object)method.toGenericString());
        }
        return paths[0];
    }

    private static Method getMethod(Class<?> controllerType, String methodName, Object ... args) {
        Set methods = MethodIntrospector.filterMethods(controllerType, method -> {
            String name = method.getName();
            int argLength = method.getParameterCount();
            return name.equals(methodName) && argLength == args.length;
        });
        if (methods.size() == 1) {
            return (Method)methods.iterator().next();
        }
        if (methods.size() > 1) {
            throw new IllegalArgumentException(String.format("Found two methods named '%s' accepting arguments %s in controller %s: [%s]", methodName, Arrays.asList(args), controllerType.getName(), methods));
        }
        throw new IllegalArgumentException("No method named '%s' with %d arguments found in controller %s".formatted(methodName, args.length, controllerType.getName()));
    }

    private static UriComponentsBuilder applyContributors(UriComponentsBuilder builder, Method method, Object ... args) {
        int argCount;
        CompositeUriComponentsContributor contributor = MvcUriComponentsBuilder.getUriComponentsContributor();
        int paramCount = method.getParameterCount();
        if (paramCount != (argCount = args.length)) {
            throw new IllegalArgumentException("Number of method parameters %d does not match number of argument values %d".formatted(paramCount, argCount));
        }
        HashMap<String, Object> uriVars = new HashMap<String, Object>();
        for (int i = 0; i < paramCount; ++i) {
            SynthesizingMethodParameter param = new SynthesizingMethodParameter(method, i);
            param.initParameterNameDiscovery(parameterNameDiscoverer);
            contributor.contributeMethodArgument((MethodParameter)param, args[i], builder, uriVars);
        }
        return builder.uriVariables(uriVars);
    }

    private static CompositeUriComponentsContributor getUriComponentsContributor() {
        ApplicationContext wac = MvcUriComponentsBuilder.getApplicationContext();
        if (wac != null) {
            try {
                return (CompositeUriComponentsContributor)wac.getBean(MVC_URI_COMPONENTS_CONTRIBUTOR_BEAN_NAME, CompositeUriComponentsContributor.class);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        return defaultUriComponentsContributor;
    }

    @Nullable
    private static ApplicationContext getApplicationContext() {
        RequestContext context = RequestContextHolder.get();
        if (context == null) {
            return null;
        }
        return context.getApplicationContext();
    }

    public static interface MethodInvocationInfo {
        public Class<?> getControllerType();

        public Method getControllerMethod();

        public Object[] getArgumentValues();
    }

    private static class ControllerMethodInvocationInterceptor
    implements MethodInterceptor,
    InvocationHandler,
    org.aopalliance.intercept.MethodInterceptor,
    MethodInvocationInfo {
        private final Class<?> controllerType;
        @Nullable
        private Method controllerMethod;
        @Nullable
        private Object[] argumentValues;

        ControllerMethodInvocationInterceptor(Class<?> controllerType) {
            this.controllerType = controllerType;
        }

        @Nullable
        public Object intercept(@Nullable Object obj, Method method, Object[] args, @Nullable MethodProxy proxy) {
            switch (method.getName()) {
                case "getControllerType": {
                    return this.controllerType;
                }
                case "getControllerMethod": {
                    return this.controllerMethod;
                }
                case "getArgumentValues": {
                    return this.argumentValues;
                }
            }
            if (ReflectionUtils.isObjectMethod((Method)method)) {
                return ReflectionUtils.invokeMethod((Method)method, (Object)obj, (Object[])args);
            }
            this.controllerMethod = method;
            this.argumentValues = args;
            Class<?> returnType = method.getReturnType();
            try {
                return returnType == Void.TYPE ? null : returnType.cast(ControllerMethodInvocationInterceptor.initProxy(returnType, this));
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to create proxy for controller method return type: " + method, ex);
            }
        }

        @Nullable
        public Object invoke(MethodInvocation inv) throws Throwable {
            return this.intercept(inv.getThis(), inv.getMethod(), inv.getArguments(), null);
        }

        @Override
        public Class<?> getControllerType() {
            return this.controllerType;
        }

        @Override
        public Method getControllerMethod() {
            Assert.state((this.controllerMethod != null ? 1 : 0) != 0, (String)"Not initialized yet");
            return this.controllerMethod;
        }

        @Override
        public Object[] getArgumentValues() {
            Assert.state((this.argumentValues != null ? 1 : 0) != 0, (String)"Not initialized yet");
            return this.argumentValues;
        }

        private static <T> T initProxy(Class<?> controllerType, @Nullable ControllerMethodInvocationInterceptor interceptor) {
            Object proxy;
            if (interceptor == null) {
                interceptor = new ControllerMethodInvocationInterceptor(controllerType);
            }
            if (controllerType == Object.class) {
                return (T)interceptor;
            }
            if (controllerType.isInterface()) {
                ClassLoader classLoader = controllerType.getClassLoader();
                if (classLoader == null) {
                    classLoader = MethodInvocationInfo.class.getClassLoader();
                } else if (classLoader.getParent() == null) {
                    ClassLoader miiClassLoader = MethodInvocationInfo.class.getClassLoader();
                    for (ClassLoader miiParent = miiClassLoader.getParent(); miiParent != null; miiParent = miiParent.getParent()) {
                        if (classLoader != miiParent) continue;
                        classLoader = miiClassLoader;
                        break;
                    }
                }
                Class[] ifcs = new Class[]{controllerType, MethodInvocationInfo.class};
                return (T)Proxy.newProxyInstance(classLoader, ifcs, (InvocationHandler)interceptor);
            }
            Enhancer enhancer = new Enhancer();
            enhancer.setAttemptLoad(true);
            enhancer.setSuperclass(controllerType);
            enhancer.setInterfaces(new Class[]{MethodInvocationInfo.class});
            enhancer.setNamingPolicy((NamingPolicy)NamingPolicy.forInfrastructure());
            enhancer.setCallbackType(MethodInterceptor.class);
            Class proxyClass = enhancer.createClass();
            try {
                proxy = ReflectionUtils.accessibleConstructor((Class)proxyClass, (Class[])new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable ex) {
                try {
                    proxy = BeanInstantiator.forSerialization((Class)proxyClass).instantiate();
                }
                catch (BeanInstantiationException ignored) {
                    throw new IllegalStateException("Failed to create controller proxy or use default constructor", ex);
                }
            }
            ((Factory)proxy).setCallbacks(new Callback[]{interceptor});
            return (T)proxy;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, @Nullable Object[] args) throws Throwable {
            return this.intercept(proxy, method, args != null ? args : new Object[]{}, null);
        }
    }

    public static class MethodArgumentBuilder {
        private final Class<?> controllerType;
        private final Method method;
        private final Object[] argumentValues;
        private final UriComponentsBuilder baseUrl;

        public MethodArgumentBuilder(Class<?> controllerType, Method method) {
            this(null, controllerType, method);
        }

        public MethodArgumentBuilder(@Nullable UriComponentsBuilder baseUrl, Class<?> controllerType, Method method) {
            Assert.notNull(controllerType, (String)"'controllerType' is required");
            Assert.notNull((Object)method, (String)"'method' is required");
            this.baseUrl = baseUrl != null ? baseUrl : UriComponentsBuilder.fromPath(MethodArgumentBuilder.getPath());
            this.controllerType = controllerType;
            this.method = method;
            this.argumentValues = new Object[method.getParameterCount()];
        }

        @Deprecated
        private static String getPath() {
            UriComponentsBuilder builder = UriComponentsBuilder.fromHttpRequest(RequestContextHolder.get());
            String path = builder.build().getPath();
            return path != null ? path : "";
        }

        public MethodArgumentBuilder arg(int index, Object value) {
            this.argumentValues[index] = value;
            return this;
        }

        public MethodArgumentBuilder encode() {
            this.baseUrl.encode();
            return this;
        }

        public String build() {
            return MvcUriComponentsBuilder.fromMethodInternal(this.baseUrl, this.controllerType, this.method, this.argumentValues).build().encode().toUriString();
        }

        public String buildAndExpand(Object ... uriVars) {
            return MvcUriComponentsBuilder.fromMethodInternal(this.baseUrl, this.controllerType, this.method, this.argumentValues).buildAndExpand(uriVars).encode().toString();
        }
    }
}

