/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.method;

import infra.beans.BeanUtils;
import infra.core.Conventions;
import infra.core.GenericTypeResolver;
import infra.core.MethodParameter;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.ui.ModelMap;
import infra.util.StringUtils;
import infra.validation.BindingResult;
import infra.web.BindingContext;
import infra.web.RequestContext;
import infra.web.bind.WebDataBinder;
import infra.web.bind.annotation.ModelAttribute;
import infra.web.handler.method.ControllerMethodResolver;
import infra.web.handler.method.HandlerMethod;
import infra.web.handler.method.InvocableHandlerMethod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

final class ModelHandler {
    private static final Logger log = LoggerFactory.getLogger(ModelHandler.class);
    private final ControllerMethodResolver methodResolver;

    public ModelHandler(ControllerMethodResolver methodResolver) {
        this.methodResolver = methodResolver;
    }

    public void initModel(RequestContext request, BindingContext container, HandlerMethod handlerMethod) throws Throwable {
        ArrayList<ModelMethod> modelMethods = this.getModelMethods(handlerMethod);
        if (modelMethods != null) {
            this.invokeModelAttributeMethods(request, container, modelMethods);
        }
    }

    @Nullable
    private ArrayList<ModelMethod> getModelMethods(HandlerMethod handlerMethod) {
        List<InvocableHandlerMethod> handlerMethods = this.methodResolver.getModelAttributeMethods(handlerMethod);
        if (!handlerMethods.isEmpty()) {
            ArrayList<ModelMethod> modelMethods = new ArrayList<ModelMethod>();
            for (InvocableHandlerMethod method : handlerMethods) {
                modelMethods.add(new ModelMethod(method));
            }
            return modelMethods;
        }
        return null;
    }

    private void invokeModelAttributeMethods(RequestContext request, BindingContext container, ArrayList<ModelMethod> modelMethods) throws Throwable {
        while (!modelMethods.isEmpty()) {
            InvocableHandlerMethod modelMethod = this.getNextModelMethod((BindingContext)container, modelMethods).handlerMethod;
            ModelAttribute ann = modelMethod.getMethodAnnotation(ModelAttribute.class);
            Assert.state((ann != null ? 1 : 0) != 0, (String)"No ModelAttribute annotation");
            if (container.containsAttribute(ann.name())) {
                if (ann.binding()) continue;
                container.setBindingDisabled(ann.name());
                continue;
            }
            Object returnValue = modelMethod.invokeForRequest(request, null);
            if (modelMethod.isVoid()) {
                if (!StringUtils.hasText((String)ann.value()) || !log.isDebugEnabled()) continue;
                log.debug("Name in @ModelAttribute is ignored because method returns void: {}", (Object)modelMethod.getShortLogMessage());
                continue;
            }
            String returnValueName = ModelHandler.getNameForReturnValue(returnValue, modelMethod);
            if (!ann.binding()) {
                container.setBindingDisabled(returnValueName);
            }
            if (container.containsAttribute(returnValueName)) continue;
            container.addAttribute(returnValueName, returnValue);
        }
    }

    private ModelMethod getNextModelMethod(BindingContext container, ArrayList<ModelMethod> modelMethods) {
        for (ModelMethod modelMethod : modelMethods) {
            if (!modelMethod.checkDependencies(container)) continue;
            modelMethods.remove(modelMethod);
            return modelMethod;
        }
        ModelMethod modelMethod = modelMethods.get(0);
        modelMethods.remove(modelMethod);
        return modelMethod;
    }

    public void updateModel(RequestContext request, BindingContext container) throws Throwable {
        if (container.hasModel()) {
            ModelMap model = container.getModel();
            this.updateBindingResult(request, container, model);
        }
    }

    private void updateBindingResult(RequestContext request, BindingContext bindingContext, ModelMap model) throws Throwable {
        for (String name : new ArrayList(model.keySet())) {
            String bindingResultKey;
            Object value = model.get((Object)name);
            if (value == null || !this.isBindingCandidate(name, value) || model.containsAttribute(bindingResultKey = BindingResult.MODEL_KEY_PREFIX + name)) continue;
            WebDataBinder dataBinder = bindingContext.createBinder(request, value, name);
            model.put((Object)bindingResultKey, (Object)dataBinder.getBindingResult());
        }
    }

    private boolean isBindingCandidate(String attributeName, Object value) {
        if (attributeName.startsWith(BindingResult.MODEL_KEY_PREFIX)) {
            return false;
        }
        return !value.getClass().isArray() && !(value instanceof Collection) && !(value instanceof Map) && !BeanUtils.isSimpleValueType(value.getClass());
    }

    public static String getNameForParameter(MethodParameter parameter) {
        ModelAttribute ann = (ModelAttribute)parameter.getParameterAnnotation(ModelAttribute.class);
        String name = ann != null ? ann.value() : null;
        return StringUtils.hasText((String)name) ? name : Conventions.getVariableNameForParameter((MethodParameter)parameter);
    }

    public static String getNameForReturnValue(@Nullable Object returnValue, HandlerMethod handler) {
        ModelAttribute ann = handler.getMethodAnnotation(ModelAttribute.class);
        if (ann != null && StringUtils.hasText((String)ann.value())) {
            return ann.value();
        }
        MethodParameter returnType = handler.getReturnType();
        Method method = returnType.getMethod();
        Assert.state((method != null ? 1 : 0) != 0, (String)"No handler method");
        Class containingClass = returnType.getContainingClass();
        Class resolvedType = GenericTypeResolver.resolveReturnType((Method)method, (Class)containingClass);
        return Conventions.getVariableNameForReturnType((Method)method, (Class)resolvedType, (Object)returnValue);
    }

    private static class ModelMethod {
        public final InvocableHandlerMethod handlerMethod;
        public final HashSet<String> dependencies = new HashSet();

        public ModelMethod(InvocableHandlerMethod handlerMethod) {
            this.handlerMethod = handlerMethod;
            for (MethodParameter parameter : handlerMethod.getMethodParameters()) {
                if (!parameter.hasParameterAnnotation(ModelAttribute.class)) continue;
                this.dependencies.add(ModelHandler.getNameForParameter(parameter));
            }
        }

        public boolean checkDependencies(BindingContext mavContainer) {
            for (String name : this.dependencies) {
                if (mavContainer.containsAttribute(name)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.handlerMethod.getMethod().toGenericString();
        }
    }
}

