/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.method;

import infra.beans.BeanUtils;
import infra.core.MethodParameter;
import infra.core.ResolvableType;
import infra.core.TypeDescriptor;
import infra.core.conversion.ConversionService;
import infra.lang.Nullable;
import infra.util.ObjectUtils;
import infra.util.StringUtils;
import infra.validation.BindingResult;
import infra.validation.Errors;
import infra.validation.annotation.ValidationAnnotationUtils;
import infra.web.BindingContext;
import infra.web.HandlerMatchingMetadata;
import infra.web.RequestContext;
import infra.web.bind.MethodArgumentNotValidException;
import infra.web.bind.WebDataBinder;
import infra.web.bind.annotation.ModelAttribute;
import infra.web.bind.resolver.ParameterResolvingStrategy;
import infra.web.handler.method.HandlerMethod;
import infra.web.handler.method.ModelHandler;
import infra.web.handler.method.ResolvableMethodParameter;
import infra.web.handler.result.HandlerMethodReturnValueHandler;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class ModelAttributeMethodProcessor
implements ParameterResolvingStrategy,
HandlerMethodReturnValueHandler {
    private final boolean annotationNotRequired;

    public ModelAttributeMethodProcessor(boolean annotationNotRequired) {
        this.annotationNotRequired = annotationNotRequired;
    }

    @Override
    public boolean supportsParameter(ResolvableMethodParameter resolvable) {
        return resolvable.hasParameterAnnotation(ModelAttribute.class) || this.annotationNotRequired && !BeanUtils.isSimpleProperty(resolvable.getParameterType());
    }

    @Override
    @Nullable
    public Object resolveArgument(RequestContext context, ResolvableMethodParameter resolvable) throws Throwable {
        Object attribute;
        BindingContext bindingContext = context.binding();
        MethodParameter parameter = resolvable.getParameter();
        String name = ModelHandler.getNameForParameter(parameter);
        ModelAttribute ann = (ModelAttribute)parameter.getParameterAnnotation(ModelAttribute.class);
        if (ann != null) {
            bindingContext.setBinding(name, ann.binding());
        }
        BindingResult bindingResult = null;
        if (bindingContext.containsAttribute(name)) {
            attribute = bindingContext.getModel().get((Object)name);
            if (attribute == null || ObjectUtils.unwrapOptional((Object)attribute) == null) {
                bindingResult = bindingContext.createBinder(context, null, name).getBindingResult();
                attribute = ModelAttributeMethodProcessor.wrapAsOptionalIfNecessary(parameter, null);
            }
        } else {
            try {
                attribute = this.createAttribute(name, parameter, bindingContext, context);
            }
            catch (MethodArgumentNotValidException ex) {
                if (this.isBindExceptionRequired(parameter)) {
                    throw ex;
                }
                attribute = ModelAttributeMethodProcessor.wrapAsOptionalIfNecessary(parameter, ex.getTarget());
                bindingResult = ex.getBindingResult();
            }
        }
        if (bindingResult == null) {
            ResolvableType type = ResolvableType.forMethodParameter((MethodParameter)parameter);
            WebDataBinder binder = bindingContext.createBinder(context, attribute, name, type);
            if (attribute == null) {
                this.constructAttribute(binder, context);
                attribute = ModelAttributeMethodProcessor.wrapAsOptionalIfNecessary(parameter, binder.getTarget());
            }
            if (!binder.getBindingResult().hasErrors()) {
                if (!bindingContext.isBindingDisabled(name)) {
                    this.bindRequestParameters(binder, context);
                }
                this.validateIfApplicable(binder, parameter);
            }
            if (binder.getBindingResult().hasErrors() && this.isBindExceptionRequired(binder, parameter)) {
                throw new MethodArgumentNotValidException(parameter, binder.getBindingResult());
            }
            if (!parameter.getParameterType().isInstance(attribute)) {
                attribute = binder.convertIfNecessary(binder.getTarget(), parameter.getParameterType(), parameter);
            }
            bindingResult = binder.getBindingResult();
        }
        Map bindingResultModel = bindingResult.getModel();
        bindingContext.removeAttributes(bindingResultModel);
        bindingContext.addAllAttributes(bindingResultModel);
        return attribute;
    }

    @Nullable
    private static Object wrapAsOptionalIfNecessary(MethodParameter parameter, @Nullable Object target) {
        return parameter.getParameterType() == Optional.class ? Optional.ofNullable(target) : target;
    }

    @Nullable
    protected Object createAttribute(String attributeName, MethodParameter parameter, BindingContext bindingContext, RequestContext request) throws Throwable {
        String value = this.getRequestValueForAttribute(attributeName, request);
        if (value != null) {
            return this.createAttributeFromRequestValue(value, attributeName, parameter, bindingContext, request);
        }
        return null;
    }

    @Nullable
    protected String getRequestValueForAttribute(String attributeName, RequestContext request) {
        String variableValue = this.getUriVariables(request).get(attributeName);
        if (StringUtils.hasText((String)variableValue)) {
            return variableValue;
        }
        String parameterValue = request.getParameter(attributeName);
        if (StringUtils.hasText((String)parameterValue)) {
            return parameterValue;
        }
        return null;
    }

    private Map<String, String> getUriVariables(RequestContext request) {
        HandlerMatchingMetadata matchingMetadata = request.getMatchingMetadata();
        if (matchingMetadata != null) {
            return matchingMetadata.getUriVariables();
        }
        return Collections.emptyMap();
    }

    @Nullable
    protected Object createAttributeFromRequestValue(String sourceValue, String attributeName, MethodParameter parameter, BindingContext binderFactory, RequestContext request) throws Throwable {
        TypeDescriptor target;
        TypeDescriptor source;
        WebDataBinder binder = binderFactory.createBinder(request, attributeName);
        ConversionService conversionService = binder.getConversionService();
        if (conversionService != null && conversionService.canConvert(source = TypeDescriptor.valueOf(String.class), target = new TypeDescriptor(parameter))) {
            return binder.convertIfNecessary(sourceValue, parameter.getParameterType(), parameter);
        }
        return null;
    }

    protected void constructAttribute(WebDataBinder binder, RequestContext request) {
        binder.construct(request);
    }

    protected void bindRequestParameters(WebDataBinder binder, RequestContext request) {
        binder.bind(request);
    }

    protected void validateIfApplicable(WebDataBinder binder, MethodParameter parameter) {
        for (Annotation ann : parameter.getParameterAnnotations()) {
            Object[] validationHints = ValidationAnnotationUtils.determineValidationHints((Annotation)ann);
            if (validationHints == null) continue;
            binder.validate(validationHints);
            break;
        }
    }

    protected boolean isBindExceptionRequired(WebDataBinder binder, MethodParameter parameter) {
        return this.isBindExceptionRequired(parameter);
    }

    protected boolean isBindExceptionRequired(MethodParameter parameter) {
        int i = parameter.getParameterIndex();
        Class<?>[] paramTypes = parameter.getExecutable().getParameterTypes();
        boolean hasBindingResult = paramTypes.length > i + 1 && Errors.class.isAssignableFrom(paramTypes[i + 1]);
        return !hasBindingResult;
    }

    @Override
    public boolean supportsHandlerMethod(HandlerMethod handler) {
        MethodParameter returnType = handler.getReturnType();
        return returnType.hasMethodAnnotation(ModelAttribute.class) || this.annotationNotRequired && !BeanUtils.isSimpleProperty((Class)returnType.getParameterType());
    }

    @Override
    public void handleHandlerMethodReturnValue(RequestContext context, HandlerMethod handler, @Nullable Object returnValue) {
        if (returnValue != null) {
            String name = ModelHandler.getNameForReturnValue(returnValue, handler);
            context.binding().addAttribute(name, returnValue);
        }
    }
}

