/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.method;

import com.fasterxml.jackson.annotation.JsonView;
import infra.core.MethodParameter;
import infra.http.MediaType;
import infra.http.converter.HttpMessageConverter;
import infra.http.converter.json.MappingJacksonValue;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.handler.method.AbstractMappingJacksonResponseBodyAdvice;

public class JsonViewResponseBodyAdvice
extends AbstractMappingJacksonResponseBodyAdvice {
    @Override
    public boolean supports(@Nullable Object body, @Nullable MethodParameter returnType, HttpMessageConverter<?> converter) {
        return super.supports(body, returnType, converter) && returnType != null && returnType.hasMethodAnnotation(JsonView.class);
    }

    @Override
    protected void beforeBodyWriteInternal(MappingJacksonValue value, MediaType contentType, MethodParameter returnType, RequestContext request) {
        JsonView ann = (JsonView)returnType.getMethodAnnotation(JsonView.class);
        Assert.state((ann != null ? 1 : 0) != 0, (String)"No JsonView annotation");
        Class[] classes = ann.value();
        if (classes.length != 1) {
            throw new IllegalArgumentException("@JsonView only supported for response body advice with exactly 1 class argument: " + returnType);
        }
        value.setSerializationView(classes[0]);
    }
}

