/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.method;

import com.fasterxml.jackson.annotation.JsonView;
import infra.core.MethodParameter;
import infra.http.HttpInputMessage;
import infra.http.converter.HttpMessageConverter;
import infra.http.converter.json.AbstractJackson2HttpMessageConverter;
import infra.http.converter.json.MappingJacksonInputMessage;
import infra.lang.Assert;
import infra.web.handler.method.RequestBodyAdvice;
import java.io.IOException;
import java.lang.reflect.Type;

public class JsonViewRequestBodyAdvice
implements RequestBodyAdvice {
    @Override
    public boolean supports(MethodParameter methodParameter, Type targetType, HttpMessageConverter<?> converter) {
        return converter instanceof AbstractJackson2HttpMessageConverter && methodParameter.getParameterAnnotation(JsonView.class) != null;
    }

    @Override
    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, MethodParameter methodParameter, Type targetType, HttpMessageConverter<?> selectedConverterType) throws IOException {
        JsonView ann = (JsonView)methodParameter.getParameterAnnotation(JsonView.class);
        Assert.state((ann != null ? 1 : 0) != 0, (String)"No JsonView annotation");
        Class[] classes = ann.value();
        if (classes.length != 1) {
            throw new IllegalArgumentException("@JsonView only supported for request body advice with exactly 1 class argument: " + methodParameter);
        }
        return new MappingJacksonInputMessage(inputMessage.getBody(), inputMessage.getHeaders(), classes[0]);
    }
}

