/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.method;

import infra.beans.factory.BeanFactory;
import infra.context.MessageSource;
import infra.http.HttpStatusCode;
import infra.lang.Nullable;
import infra.util.StringUtils;
import infra.web.HttpRequestHandler;
import infra.web.RequestContext;
import infra.web.handler.method.HandlerMethod;
import infra.web.handler.method.ResolvableMethodParameter;
import infra.web.handler.method.ResolvableParameterFactory;
import infra.web.view.View;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class InvocableHandlerMethod
extends HandlerMethod {
    private static final Object[] EMPTY_ARGS = new Object[0];
    protected final ResolvableMethodParameter[] resolvableParameters;

    public InvocableHandlerMethod(HandlerMethod handlerMethod, ResolvableParameterFactory factory) {
        super(handlerMethod);
        this.resolvableParameters = factory.getParameters(this);
    }

    public InvocableHandlerMethod(Object bean, Method method, ResolvableParameterFactory factory) {
        this(bean, method, null, factory);
    }

    public InvocableHandlerMethod(Object bean, Method method, @Nullable MessageSource messageSource, ResolvableParameterFactory factory) {
        super(bean, method, messageSource);
        this.resolvableParameters = factory.getParameters(this);
    }

    public InvocableHandlerMethod(String beanName, BeanFactory beanFactory, @Nullable MessageSource messageSource, Method method, ResolvableParameterFactory factory) {
        super(beanName, beanFactory, messageSource, method);
        this.resolvableParameters = factory.getParameters(this);
    }

    private InvocableHandlerMethod(HandlerMethod handlerMethod, Object handler, ResolvableMethodParameter[] resolvableParameters) {
        super(handlerMethod, handler);
        this.resolvableParameters = resolvableParameters;
    }

    @Override
    public HandlerMethod withBean(Object handler) {
        return new InvocableHandlerMethod(this, handler, this.resolvableParameters);
    }

    @Nullable
    public Object invokeAndHandle(RequestContext request) throws Throwable {
        Object returnValue = this.invokeForRequest(request, null);
        this.applyResponseStatus(request);
        if (returnValue == null ? request.isNotModified() || this.getResponseStatus() != null : StringUtils.hasText((String)this.getResponseStatusReason())) {
            return HttpRequestHandler.NONE_RETURN_VALUE;
        }
        return returnValue;
    }

    @Nullable
    public Object invokeAndHandle(RequestContext request, Object ... providedArgs) throws Throwable {
        Object returnValue = this.invokeForRequest(request, providedArgs);
        this.applyResponseStatus(request);
        if (returnValue == null ? request.isNotModified() || this.getResponseStatus() != null : StringUtils.hasText((String)this.getResponseStatusReason())) {
            return HttpRequestHandler.NONE_RETURN_VALUE;
        }
        return returnValue;
    }

    private void applyResponseStatus(RequestContext response) throws IOException {
        HttpStatusCode status = this.getResponseStatus();
        if (status == null) {
            return;
        }
        String reason = this.getResponseStatusReason();
        if (StringUtils.hasText((String)reason)) {
            response.sendError(status.value(), reason);
        } else {
            response.setStatus(status.value());
        }
        response.setAttribute(View.RESPONSE_STATUS_ATTRIBUTE, status);
    }

    @Nullable
    public Object invokeForRequest(RequestContext request, Object ... providedArgs) throws Throwable {
        Object[] args = this.getMethodArgumentValues(request, providedArgs);
        if (log.isTraceEnabled()) {
            log.trace("Arguments: {}", (Object)Arrays.toString(args));
        }
        try {
            return this.bridgedMethod.invoke(this.getBean(), args);
        }
        catch (IllegalArgumentException ex) {
            this.assertTargetBean(this.bridgedMethod, this.getBean(), args);
            String text = ex.getMessage() == null || ex.getCause() instanceof NullPointerException ? "Illegal argument" : ex.getMessage();
            throw new IllegalStateException(this.formatInvokeError(text, args), ex);
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw targetException;
            }
            if (targetException instanceof Error) {
                throw targetException;
            }
            if (targetException instanceof Exception) {
                throw targetException;
            }
            throw new IllegalStateException(this.formatInvokeError("Invocation failure", args), targetException);
        }
    }

    private Object[] getMethodArgumentValues(RequestContext request, @Nullable Object[] providedArgs) throws Throwable {
        ResolvableMethodParameter[] parameters = this.resolvableParameters;
        int length = parameters.length;
        if (length == 0) {
            return EMPTY_ARGS;
        }
        Object[] args = new Object[length];
        for (int i = 0; i < length; ++i) {
            Object arg = null;
            if (providedArgs != null) {
                Class<?> parameterType = parameters[i].getParameterType();
                for (Object providedArg : providedArgs) {
                    if (!parameterType.isInstance(providedArg)) continue;
                    arg = providedArg;
                    break;
                }
            }
            if (arg == null) {
                try {
                    arg = parameters[i].resolveParameter(request);
                }
                catch (Throwable ex) {
                    String exMsg;
                    if (log.isDebugEnabled() && (exMsg = ex.getMessage()) != null && !exMsg.contains(parameters[i].getMethod().toGenericString())) {
                        log.debug(InvocableHandlerMethod.formatArgumentError(parameters[i], exMsg));
                    }
                    throw ex;
                }
            }
            args[i] = arg;
        }
        return args;
    }

    private void assertTargetBean(Method method, Object targetBean, Object[] args) {
        Class<?> targetBeanClass;
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        if (!methodDeclaringClass.isAssignableFrom(targetBeanClass = targetBean.getClass())) {
            String text = "The mapped handler method class '%s' is not an instance of the actual controller bean class '%s'. If the controller requires proxying (e.g. due to @Transactional), please use class-based proxying.".formatted(methodDeclaringClass.getName(), targetBeanClass.getName());
            throw new IllegalStateException(this.formatInvokeError(text, args));
        }
    }

    private String formatInvokeError(String text, Object[] args) {
        String formattedArgs = IntStream.range(0, args.length).mapToObj(i -> args[i] == null ? "[%d] [null]".formatted(i) : "[%d] [type=%s] [value=%s]".formatted(i, args[i].getClass().getName(), args[i])).collect(Collectors.joining(",\n", " ", " "));
        return "%s\nController [%s]\nMethod [%s] with argument values:\n%s".formatted(text, this.getBeanType().getName(), this.bridgedMethod.toGenericString(), formattedArgs);
    }

    private static String formatArgumentError(ResolvableMethodParameter param, String message) {
        return "Could not resolve parameter [%d] in %s%s".formatted(param.getParameterIndex(), param.getMethod().toGenericString(), StringUtils.hasText((String)message) ? ": " + message : "");
    }
}

