/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.method;

import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.ObjectUtils;
import infra.web.BindingContext;
import infra.web.RequestContext;
import infra.web.bind.WebDataBinder;
import infra.web.bind.annotation.InitBinder;
import infra.web.bind.support.WebBindingInitializer;
import infra.web.handler.method.ControllerMethodResolver;
import infra.web.handler.method.HandlerMethod;
import infra.web.handler.method.InvocableHandlerMethod;
import infra.web.handler.method.ModelHandler;
import java.util.List;

public class InitBinderBindingContext
extends BindingContext {
    private final ModelHandler modelHandler;
    private final HandlerMethod handlerMethod;
    private final BindingContext binderMethodContext;
    private final ControllerMethodResolver methodResolver;
    @Nullable
    private List<InvocableHandlerMethod> binderMethods;

    InitBinderBindingContext(ModelHandler modelHandler, @Nullable WebBindingInitializer initializer, ControllerMethodResolver methodResolver, HandlerMethod handlerMethod) {
        super(initializer);
        this.modelHandler = modelHandler;
        this.handlerMethod = handlerMethod;
        this.methodResolver = methodResolver;
        this.binderMethodContext = new BindingContext(initializer);
    }

    InitBinderBindingContext(ModelHandler modelHandler, @Nullable WebBindingInitializer initializer, ControllerMethodResolver methodResolver, List<InvocableHandlerMethod> binderMethods, HandlerMethod handlerMethod) {
        super(initializer);
        this.modelHandler = modelHandler;
        this.handlerMethod = handlerMethod;
        this.binderMethods = binderMethods;
        this.methodResolver = methodResolver;
        this.binderMethodContext = new BindingContext(initializer);
    }

    @Override
    public void initBinder(WebDataBinder dataBinder, RequestContext request) throws Throwable {
        List<InvocableHandlerMethod> binderMethods = this.binderMethods;
        if (binderMethods == null) {
            this.binderMethods = binderMethods = this.methodResolver.getBinderMethods(this.handlerMethod);
        }
        if (!binderMethods.isEmpty()) {
            BindingContext bindingContext = request.getBinding();
            request.setBinding(this.binderMethodContext);
            for (InvocableHandlerMethod binderMethod : binderMethods) {
                if (!this.isBinderMethodApplicable(binderMethod, dataBinder)) continue;
                Object returnValue = binderMethod.invokeForRequest(request, new Object[]{dataBinder});
                if (returnValue != null) {
                    throw new IllegalStateException("@InitBinder methods must not return a value (should be void): " + binderMethod);
                }
                if (this.binderMethodContext.getModel().isEmpty()) continue;
                throw new IllegalStateException("@InitBinder methods are not allowed to add model attributes: " + binderMethod);
            }
            request.setBinding(bindingContext);
        }
    }

    protected boolean isBinderMethodApplicable(HandlerMethod initBinderMethod, WebDataBinder dataBinder) {
        InitBinder ann = initBinderMethod.getMethodAnnotation(InitBinder.class);
        Assert.state((ann != null ? 1 : 0) != 0, (String)"No InitBinder annotation");
        Object[] names = ann.value();
        return ObjectUtils.isEmpty((Object[])names) || ObjectUtils.containsElement((Object[])names, (Object)dataBinder.getObjectName());
    }

    @Override
    public void updateModel(RequestContext request) throws Throwable {
        this.modelHandler.updateModel(request, this);
    }

    @Override
    public void initModel(RequestContext request) throws Throwable {
        this.modelHandler.initModel(request, this, this.handlerMethod);
    }
}

