/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.method;

import infra.core.annotation.AnnotatedElementUtils;
import infra.lang.Nullable;
import infra.util.ClassUtils;
import infra.util.CollectionUtils;
import infra.util.StringUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public final class HandlerTypePredicate
implements Predicate<Class<?>> {
    private final Set<String> basePackages;
    private final List<Class<?>> assignableTypes;
    private final List<Class<? extends Annotation>> annotations;

    private HandlerTypePredicate(Set<String> basePackages, List<Class<?>> assignableTypes, List<Class<? extends Annotation>> annotations) {
        this.annotations = Collections.unmodifiableList(annotations);
        this.basePackages = Collections.unmodifiableSet(basePackages);
        this.assignableTypes = Collections.unmodifiableList(assignableTypes);
    }

    @Override
    public boolean test(@Nullable Class<?> controllerType) {
        if (!this.hasSelectors()) {
            return true;
        }
        if (controllerType != null) {
            for (String string : this.basePackages) {
                if (!controllerType.getName().startsWith(string)) continue;
                return true;
            }
            for (Class clazz : this.assignableTypes) {
                if (!ClassUtils.isAssignable((Class)clazz, controllerType)) continue;
                return true;
            }
            for (Class clazz : this.annotations) {
                if (!AnnotatedElementUtils.hasAnnotation(controllerType, (Class)clazz)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasSelectors() {
        return !this.basePackages.isEmpty() || !this.assignableTypes.isEmpty() || !this.annotations.isEmpty();
    }

    public static HandlerTypePredicate forAnyHandlerType() {
        return new HandlerTypePredicate(Collections.emptySet(), Collections.emptyList(), Collections.emptyList());
    }

    public static HandlerTypePredicate forBasePackage(String ... packages) {
        return new Builder().basePackage(packages).build();
    }

    public static HandlerTypePredicate forBasePackageClass(Class<?> ... packageClasses) {
        return new Builder().basePackageClass(packageClasses).build();
    }

    public static HandlerTypePredicate forAssignableType(Class<?> ... types) {
        return new Builder().assignableType(types).build();
    }

    @SafeVarargs
    public static HandlerTypePredicate forAnnotation(Class<? extends Annotation> ... annotations) {
        return new Builder().annotation(annotations).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final LinkedHashSet<String> basePackages = new LinkedHashSet();
        private final ArrayList<Class<?>> assignableTypes = new ArrayList();
        private final ArrayList<Class<? extends Annotation>> annotations = new ArrayList();

        public Builder basePackage(String ... packages) {
            for (String aPackage : packages) {
                if (!StringUtils.hasText((String)aPackage)) continue;
                this.addBasePackage(aPackage);
            }
            return this;
        }

        public Builder basePackageClass(Class<?> ... packageClasses) {
            for (Class<?> packageClass : packageClasses) {
                this.addBasePackage(ClassUtils.getPackageName(packageClass));
            }
            return this;
        }

        private void addBasePackage(String basePackage) {
            this.basePackages.add((String)(basePackage.endsWith(".") ? basePackage : basePackage + "."));
        }

        public Builder assignableType(Class<?> ... types) {
            CollectionUtils.addAll(this.assignableTypes, (Object[])types);
            return this;
        }

        public final Builder annotation(Class<? extends Annotation> ... annotations) {
            CollectionUtils.addAll(this.annotations, (Object[])annotations);
            return this;
        }

        public HandlerTypePredicate build() {
            return new HandlerTypePredicate(this.basePackages, this.assignableTypes, this.annotations);
        }
    }
}

