/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.method;

import infra.beans.factory.BeanFactory;
import infra.context.MessageSource;
import infra.core.BridgeMethodResolver;
import infra.core.MethodParameter;
import infra.core.ResolvableType;
import infra.core.annotation.AnnotatedElementUtils;
import infra.core.annotation.MergedAnnotation;
import infra.core.annotation.MergedAnnotations;
import infra.core.annotation.SynthesizingMethodParameter;
import infra.core.i18n.LocaleContextHolder;
import infra.http.HttpStatusCode;
import infra.lang.Assert;
import infra.lang.Constant;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.util.ClassUtils;
import infra.util.CollectionUtils;
import infra.util.MapCache;
import infra.util.ReflectionUtils;
import infra.util.StringUtils;
import infra.web.HandlerWrapper;
import infra.web.annotation.ResponseBody;
import infra.web.annotation.ResponseStatus;
import infra.web.cors.CorsConfiguration;
import infra.web.handler.AsyncHandler;
import infra.web.handler.method.ReactiveTypeHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;

public class HandlerMethod
implements AsyncHandler {
    protected static final Logger log = LoggerFactory.getLogger(HandlerMethod.class);
    static MapCache<AnnotationKey, Boolean, HandlerMethod> methodAnnotationCache = new MapCache<AnnotationKey, Boolean, HandlerMethod>(128){

        protected Boolean createValue(AnnotationKey key, HandlerMethod handlerMethod) {
            return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)key.method, key.annotationType);
        }
    };
    private final Object bean;
    private final Class<?> beanType;
    private final Method method;
    protected final Method bridgedMethod;
    private final MethodParameter[] parameters;
    private final Class<?> returnType;
    @Nullable
    private MethodParameter returnTypeParameter;
    @Nullable
    private final MessageSource messageSource;
    private final boolean responseBody;
    @Nullable
    private HttpStatusCode responseStatus;
    @Nullable
    private String responseStatusReason;
    @Nullable
    private volatile ArrayList<Annotation[][]> interfaceParameterAnnotations;
    @Nullable
    CorsConfiguration corsConfig;

    public HandlerMethod(Object bean, Method method) {
        this(bean, method, null);
    }

    protected HandlerMethod(Object bean, Method method, @Nullable MessageSource messageSource) {
        Assert.notNull((Object)method, (String)"Method is required");
        this.bean = bean;
        this.method = method;
        this.messageSource = messageSource;
        this.bridgedMethod = ReflectionUtils.makeAccessible((Method)BridgeMethodResolver.findBridgedMethod((Method)method));
        this.beanType = ClassUtils.getUserClass((Object)bean);
        this.returnType = this.bridgedMethod.getReturnType();
        this.parameters = this.initMethodParameters();
        this.responseBody = this.computeResponseBody();
        this.evaluateResponseStatus();
    }

    public HandlerMethod(Object bean, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Assert.notNull((Object)bean, (String)"Bean is required");
        Assert.notNull((Object)methodName, (String)"Method name is required");
        this.bean = bean;
        this.messageSource = null;
        this.beanType = ClassUtils.getUserClass((Object)bean);
        this.method = bean.getClass().getMethod(methodName, parameterTypes);
        this.bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)this.method);
        this.returnType = this.bridgedMethod.getReturnType();
        ReflectionUtils.makeAccessible((Method)this.bridgedMethod);
        this.parameters = this.initMethodParameters();
        this.responseBody = this.computeResponseBody();
        this.evaluateResponseStatus();
    }

    public HandlerMethod(String beanName, BeanFactory beanFactory, Method method) {
        this(beanName, beanFactory, null, method);
    }

    public HandlerMethod(String beanName, BeanFactory beanFactory, @Nullable MessageSource messageSource, Method method) {
        Assert.notNull((Object)method, (String)"Method is required");
        Assert.hasText((String)beanName, (String)"Bean name is required");
        Assert.notNull((Object)beanFactory, (String)"BeanFactory is required");
        this.bean = beanFactory.isSingleton(beanName) ? beanFactory.getBean(beanName) : beanName;
        this.method = method;
        this.messageSource = messageSource;
        Class beanType = beanFactory.getType(beanName);
        if (beanType == null) {
            throw new IllegalStateException("Cannot resolve bean type for bean with name '%s'".formatted(beanName));
        }
        this.beanType = ClassUtils.getUserClass((Class)beanType);
        this.bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)method);
        this.returnType = this.bridgedMethod.getReturnType();
        ReflectionUtils.makeAccessible((Method)this.bridgedMethod);
        this.parameters = this.initMethodParameters();
        this.responseBody = this.computeResponseBody();
        this.evaluateResponseStatus();
    }

    protected HandlerMethod(HandlerMethod other) {
        Assert.notNull((Object)other, (String)"HandlerMethod is required");
        this.bean = other.bean;
        this.messageSource = other.messageSource;
        this.method = other.method;
        this.beanType = other.beanType;
        this.returnType = other.returnType;
        this.bridgedMethod = other.bridgedMethod;
        this.parameters = other.parameters;
        this.responseStatus = other.responseStatus;
        this.responseStatusReason = other.responseStatusReason;
        this.responseBody = other.responseBody;
        this.corsConfig = other.corsConfig;
        this.returnTypeParameter = other.returnTypeParameter;
        this.interfaceParameterAnnotations = other.interfaceParameterAnnotations;
    }

    protected HandlerMethod(HandlerMethod other, Object handler) {
        this.bean = handler;
        this.messageSource = other.messageSource;
        this.beanType = other.beanType;
        this.method = other.method;
        this.returnType = other.returnType;
        this.bridgedMethod = other.bridgedMethod;
        this.parameters = other.parameters;
        this.responseStatus = other.responseStatus;
        this.responseStatusReason = other.responseStatusReason;
        this.responseBody = other.responseBody;
        this.corsConfig = other.corsConfig;
        this.returnTypeParameter = other.returnTypeParameter;
        this.interfaceParameterAnnotations = other.interfaceParameterAnnotations;
    }

    public Object getBean() {
        return this.bean;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    public MethodParameter[] getMethodParameters() {
        return this.parameters;
    }

    public int getParameterCount() {
        return this.parameters.length;
    }

    @Nullable
    protected HttpStatusCode getResponseStatus() {
        return this.responseStatus;
    }

    @Nullable
    protected String getResponseStatusReason() {
        return this.responseStatusReason;
    }

    public MethodParameter getReturnType() {
        Object returnType = this.returnTypeParameter;
        if (returnType == null) {
            this.returnTypeParameter = returnType = new HandlerMethodParameter(-1);
        }
        return returnType;
    }

    public MethodParameter getReturnValueType(@Nullable Object returnValue) {
        return new ReturnValueMethodParameter(returnValue);
    }

    public Class<?> getRawReturnType() {
        return this.returnType;
    }

    public boolean isReturnTypeAssignableTo(Class<?> superClass) {
        return superClass.isAssignableFrom(this.returnType);
    }

    public boolean isReturn(Class<?> returnType) {
        return returnType == this.returnType;
    }

    public boolean isResponseBody() {
        return this.responseBody;
    }

    protected boolean computeResponseBody() {
        MergedAnnotation annotation = MergedAnnotations.from((AnnotatedElement)this.method).get(ResponseBody.class);
        if (annotation.isPresent()) {
            return annotation.getBoolean("value");
        }
        annotation = MergedAnnotations.from(this.method.getDeclaringClass()).get(ResponseBody.class);
        if (annotation.isPresent()) {
            return annotation.getBoolean("value");
        }
        return false;
    }

    public boolean isVoid() {
        return Void.TYPE.equals(this.returnType);
    }

    @Nullable
    public <A extends Annotation> A getMethodAnnotation(Class<A> annotationType) {
        return (A)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, annotationType);
    }

    public <A extends Annotation> boolean hasMethodAnnotation(Class<A> annotationType) {
        return (Boolean)methodAnnotationCache.get((Object)new AnnotationKey(this.method, annotationType), (Object)this);
    }

    @Override
    public ConcurrentResultHandlerMethod wrapConcurrentResult(@Nullable Object result) {
        return new ConcurrentResultHandlerMethod(new ConcurrentResultMethodParameter(result), this);
    }

    public HandlerMethod withBean(Object handler) {
        return new HandlerMethod(this, handler);
    }

    public String getShortLogMessage() {
        return "%s#%s[%d args]".formatted(this.getBeanType().getName(), this.method.getName(), this.method.getParameterCount());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HandlerMethod)) {
            return false;
        }
        HandlerMethod otherMethod = (HandlerMethod)other;
        return this.bean.equals(otherMethod.bean) && this.method.equals(otherMethod.method);
    }

    public int hashCode() {
        return this.bean.hashCode() * 31 + this.method.hashCode();
    }

    public String toString() {
        return HandlerMethod.initDescription(this.beanType, this.method);
    }

    private ArrayList<Annotation[][]> getInterfaceParameterAnnotations() {
        ArrayList<Object> parameterAnnotations = this.interfaceParameterAnnotations;
        if (parameterAnnotations == null) {
            parameterAnnotations = new ArrayList();
            for (Class ifc : ClassUtils.getAllInterfacesForClassAsSet(this.method.getDeclaringClass())) {
                for (Method candidate : ifc.getMethods()) {
                    if (!this.isOverrideFor(candidate)) continue;
                    parameterAnnotations.add(candidate.getParameterAnnotations());
                }
            }
            this.interfaceParameterAnnotations = parameterAnnotations;
        }
        return parameterAnnotations;
    }

    private boolean isOverrideFor(Method candidate) {
        if (!candidate.getName().equals(this.method.getName()) || candidate.getParameterCount() != this.method.getParameterCount()) {
            return false;
        }
        Object[] paramTypes = this.method.getParameterTypes();
        if (Arrays.equals(candidate.getParameterTypes(), paramTypes)) {
            return true;
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            if (paramTypes[i] == ResolvableType.forParameter((Executable)candidate, (int)i, this.method.getDeclaringClass()).resolve()) continue;
            return false;
        }
        return true;
    }

    private MethodParameter[] initMethodParameters() {
        int count = this.bridgedMethod.getParameterCount();
        MethodParameter[] result = new MethodParameter[count];
        for (int i = 0; i < count; ++i) {
            result[i] = new HandlerMethodParameter(i);
        }
        return result;
    }

    private void evaluateResponseStatus() {
        ResponseStatus annotation = this.getMethodAnnotation(ResponseStatus.class);
        if (annotation == null) {
            annotation = (ResponseStatus)AnnotatedElementUtils.findMergedAnnotation(this.getBeanType(), ResponseStatus.class);
        }
        if (annotation != null) {
            String reason = annotation.reason();
            String resolvedReason = StringUtils.hasText((String)reason) && this.messageSource != null ? this.messageSource.getMessage(reason, null, reason, LocaleContextHolder.getLocale()) : reason;
            this.responseStatus = annotation.code();
            this.responseStatusReason = resolvedReason;
            if (StringUtils.hasText((String)resolvedReason) && this.getMethod().getReturnType() != Void.TYPE) {
                log.warn("Return value of [{}] will be ignored since @ResponseStatus 'reason' attribute is set.", (Object)this.getMethod());
            }
        }
    }

    private static String initDescription(Class<?> beanType, Method method) {
        StringJoiner joiner = new StringJoiner(", ", "(", ")");
        for (Class<?> paramType : method.getParameterTypes()) {
            joiner.add(paramType.getSimpleName());
        }
        return beanType.getName() + "#" + method.getName() + joiner;
    }

    public static boolean isHandler(@Nullable Object handler) {
        return HandlerMethod.unwrap(handler) != null;
    }

    @Nullable
    public static HandlerMethod unwrap(@Nullable Object handler) {
        HandlerWrapper wrapper;
        Object object;
        if (handler instanceof HandlerMethod) {
            return (HandlerMethod)handler;
        }
        if (handler instanceof HandlerWrapper && (object = (wrapper = (HandlerWrapper)handler).getRawHandler()) instanceof HandlerMethod) {
            HandlerMethod target = (HandlerMethod)object;
            return target;
        }
        return null;
    }

    protected class HandlerMethodParameter
    extends SynthesizingMethodParameter {
        @Nullable
        private volatile Annotation[] combinedAnnotations;

        public HandlerMethodParameter(int index) {
            super(HandlerMethod.this.method, index);
        }

        protected HandlerMethodParameter(HandlerMethodParameter original) {
            super((SynthesizingMethodParameter)original);
        }

        public Method getMethod() {
            return HandlerMethod.this.bridgedMethod;
        }

        public Class<?> getContainingClass() {
            return HandlerMethod.this.getBeanType();
        }

        public <T extends Annotation> T getMethodAnnotation(Class<T> annotationType) {
            return HandlerMethod.this.getMethodAnnotation(annotationType);
        }

        public <T extends Annotation> boolean hasMethodAnnotation(Class<T> annotationType) {
            return HandlerMethod.this.hasMethodAnnotation(annotationType);
        }

        public Annotation[] getParameterAnnotations() {
            Object[] anns = this.combinedAnnotations;
            if (anns == null) {
                anns = super.getParameterAnnotations();
                int index = this.getParameterIndex();
                if (index >= 0) {
                    for (Annotation[][] ifcAnns : HandlerMethod.this.getInterfaceParameterAnnotations()) {
                        Annotation[] paramAnns;
                        if (index >= ifcAnns.length || (paramAnns = ifcAnns[index]).length <= 0) continue;
                        ArrayList<Annotation> merged = new ArrayList<Annotation>(anns.length + paramAnns.length);
                        CollectionUtils.addAll(merged, (Object[])anns);
                        for (Annotation paramAnn : paramAnns) {
                            boolean existingType = false;
                            for (Object ann : anns) {
                                if (ann.annotationType() != paramAnn.annotationType()) continue;
                                existingType = true;
                                break;
                            }
                            if (existingType) continue;
                            merged.add(this.adaptAnnotation(paramAnn));
                        }
                        anns = merged.toArray(Constant.EMPTY_ANNOTATIONS);
                    }
                }
                this.combinedAnnotations = anns;
            }
            return anns;
        }

        public HandlerMethodParameter clone() {
            return new HandlerMethodParameter(this);
        }

        public String toString() {
            return this.getParameterType().getSimpleName() + " " + this.getParameterName();
        }
    }

    private class ReturnValueMethodParameter
    extends HandlerMethodParameter {
        @Nullable
        private final Class<?> returnValueType;

        public ReturnValueMethodParameter(Object returnValue) {
            super(-1);
            this.returnValueType = returnValue != null ? returnValue.getClass() : null;
        }

        protected ReturnValueMethodParameter(ReturnValueMethodParameter original) {
            super(original);
            this.returnValueType = original.returnValueType;
        }

        public Class<?> getParameterType() {
            return this.returnValueType != null ? this.returnValueType : super.getParameterType();
        }

        @Override
        public ReturnValueMethodParameter clone() {
            return new ReturnValueMethodParameter(this);
        }
    }

    static final class AnnotationKey {
        private final int hash;
        public final Method method;
        public final Class<? extends Annotation> annotationType;

        AnnotationKey(Method method, Class<? extends Annotation> annotationType) {
            this.method = method;
            this.annotationType = annotationType;
            this.hash = Objects.hash(method, annotationType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AnnotationKey)) {
                return false;
            }
            AnnotationKey annotationKey = (AnnotationKey)o;
            return this.hash == annotationKey.hash && Objects.equals(this.method, annotationKey.method) && Objects.equals(this.annotationType, annotationKey.annotationType);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    protected static class ConcurrentResultHandlerMethod
    extends HandlerMethod {
        private final HandlerMethod target;
        private final MethodParameter returnType;

        public ConcurrentResultHandlerMethod(ConcurrentResultMethodParameter returnType, HandlerMethod target) {
            super(target);
            this.target = target;
            this.returnType = returnType;
        }

        @Override
        public Class<?> getBeanType() {
            return this.target.getBeanType();
        }

        @Override
        public MethodParameter getReturnValueType(@Nullable Object returnValue) {
            return this.returnType;
        }

        @Override
        public MethodParameter getReturnType() {
            return this.returnType;
        }

        @Override
        public <A extends Annotation> A getMethodAnnotation(Class<A> annotationType) {
            return this.target.getMethodAnnotation(annotationType);
        }

        @Override
        public <A extends Annotation> boolean hasMethodAnnotation(Class<A> annotationType) {
            return this.target.hasMethodAnnotation(annotationType);
        }

        @Override
        public boolean isReturn(Class<?> returnType) {
            return this.returnType.getParameterType() == returnType;
        }

        @Override
        public boolean isReturnTypeAssignableTo(Class<?> superClass) {
            return superClass.isAssignableFrom(this.returnType.getParameterType());
        }
    }

    private class ConcurrentResultMethodParameter
    extends HandlerMethodParameter {
        @Nullable
        private final Object returnValue;
        private final ResolvableType returnType;

        public ConcurrentResultMethodParameter(Object returnValue) {
            ResolvableType resolvableType;
            super(-1);
            this.returnValue = returnValue;
            if (returnValue instanceof ReactiveTypeHandler.CollectedValuesList) {
                ReactiveTypeHandler.CollectedValuesList list = (ReactiveTypeHandler.CollectedValuesList)returnValue;
                resolvableType = list.getReturnType();
            } else {
                resolvableType = ResolvableType.forType((Type)super.getGenericParameterType()).getGeneric(new int[0]);
            }
            this.returnType = resolvableType;
        }

        public ConcurrentResultMethodParameter(ConcurrentResultMethodParameter original) {
            super(original);
            this.returnValue = original.returnValue;
            this.returnType = original.returnType;
        }

        public Class<?> getParameterType() {
            if (this.returnValue != null) {
                return this.returnValue.getClass();
            }
            if (!ResolvableType.NONE.equals((Object)this.returnType)) {
                return this.returnType.toClass();
            }
            return super.getParameterType();
        }

        public Type getGenericParameterType() {
            return this.returnType.getType();
        }

        @Override
        public <T extends Annotation> boolean hasMethodAnnotation(Class<T> annotationType) {
            return super.hasMethodAnnotation(annotationType) || annotationType == ResponseBody.class && this.returnValue instanceof ReactiveTypeHandler.CollectedValuesList;
        }

        @Override
        public ConcurrentResultMethodParameter clone() {
            return new ConcurrentResultMethodParameter(this);
        }
    }
}

