/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.method;

import infra.core.MethodIntrospector;
import infra.core.annotation.AnnotatedElementUtils;
import infra.http.InvalidMediaTypeException;
import infra.http.MediaType;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.ConcurrentLruCache;
import infra.util.comparator.ExceptionDepthComparator;
import infra.web.annotation.ExceptionHandler;
import infra.web.handler.method.ExceptionHandlerMappingInfo;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ExceptionHandlerMethodResolver {
    private static final ExceptionHandlerMappingInfo NO_MATCHING_EXCEPTION_HANDLER;
    private final HashMap<ExceptionMapping, ExceptionHandlerMappingInfo> mappedMethods = new HashMap(16);
    private final ConcurrentLruCache<ExceptionMapping, ExceptionHandlerMappingInfo> lookupCache = new ConcurrentLruCache(24, cacheKey -> this.getMappedMethod(cacheKey.exceptionType(), cacheKey.mediaType()));

    public ExceptionHandlerMethodResolver(Class<?> handlerType) {
        for (Method method2 : MethodIntrospector.filterMethods(handlerType, method -> AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, ExceptionHandler.class))) {
            ExceptionHandlerMappingInfo mappingInfo = this.detectExceptionMappings(method2);
            for (Class<? extends Throwable> exceptionType : mappingInfo.getExceptionTypes()) {
                for (MediaType producibleType : mappingInfo.getProducibleTypes()) {
                    this.addExceptionMapping(new ExceptionMapping(exceptionType, producibleType), mappingInfo);
                }
                if (!mappingInfo.getProducibleTypes().isEmpty()) continue;
                this.addExceptionMapping(new ExceptionMapping(exceptionType, MediaType.ALL), mappingInfo);
            }
        }
    }

    private ExceptionHandlerMappingInfo detectExceptionMappings(Method method) {
        ExceptionHandler exceptionHandler = this.readExceptionHandlerAnnotation(method);
        ArrayList<Class<? extends Throwable>> exceptions = new ArrayList<Class<? extends Throwable>>(Arrays.asList(exceptionHandler.exception()));
        if (exceptions.isEmpty()) {
            for (Class<?> paramType : method.getParameterTypes()) {
                if (!Throwable.class.isAssignableFrom(paramType)) continue;
                exceptions.add(paramType);
            }
        }
        if (exceptions.isEmpty()) {
            throw new IllegalStateException("No exception types mapped to " + method);
        }
        HashSet<MediaType> mediaTypes = new HashSet<MediaType>();
        for (String mediaType : exceptionHandler.produces()) {
            try {
                mediaTypes.add(MediaType.parseMediaType(mediaType));
            }
            catch (InvalidMediaTypeException exc) {
                throw new IllegalStateException("Invalid media type [%s] declared on @ExceptionHandler for %s".formatted(mediaType, method), exc);
            }
        }
        return new ExceptionHandlerMappingInfo(Set.copyOf(exceptions), mediaTypes, method);
    }

    private ExceptionHandler readExceptionHandlerAnnotation(Method method) {
        ExceptionHandler ann = (ExceptionHandler)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ExceptionHandler.class);
        Assert.state((ann != null ? 1 : 0) != 0, (String)"No ExceptionHandler annotation");
        return ann;
    }

    private void addExceptionMapping(ExceptionMapping mapping, ExceptionHandlerMappingInfo mappingInfo) {
        ExceptionHandlerMappingInfo oldMapping = this.mappedMethods.put(mapping, mappingInfo);
        if (oldMapping != null && !oldMapping.getHandlerMethod().equals(mappingInfo.getHandlerMethod())) {
            throw new IllegalStateException("Ambiguous @ExceptionHandler method mapped for [%s]: {%s, %s}".formatted(mapping, oldMapping.getHandlerMethod(), mappingInfo.getHandlerMethod()));
        }
    }

    public boolean hasExceptionMappings() {
        return !this.mappedMethods.isEmpty();
    }

    @Nullable
    public Method resolveMethod(Throwable exception) {
        ExceptionHandlerMappingInfo mappingInfo = this.resolveExceptionMapping(exception, MediaType.ALL);
        return mappingInfo != null ? mappingInfo.getHandlerMethod() : null;
    }

    @Nullable
    public ExceptionHandlerMappingInfo resolveExceptionMapping(Throwable exception, MediaType mediaType) {
        Throwable cause;
        ExceptionHandlerMappingInfo mappingInfo = this.resolveExceptionMappingByExceptionType(exception.getClass(), mediaType);
        if (mappingInfo == null && (cause = exception.getCause()) != null) {
            mappingInfo = this.resolveExceptionMapping(cause, mediaType);
        }
        return mappingInfo;
    }

    @Nullable
    public Method resolveMethodByExceptionType(Class<? extends Throwable> exceptionType) {
        ExceptionHandlerMappingInfo mappingInfo = this.resolveExceptionMappingByExceptionType(exceptionType, MediaType.ALL);
        return mappingInfo != null ? mappingInfo.getHandlerMethod() : null;
    }

    @Nullable
    public ExceptionHandlerMappingInfo resolveExceptionMappingByExceptionType(Class<? extends Throwable> exceptionType, MediaType mediaType) {
        ExceptionHandlerMappingInfo mappingInfo = (ExceptionHandlerMappingInfo)this.lookupCache.get((Object)new ExceptionMapping(exceptionType, mediaType));
        return mappingInfo != NO_MATCHING_EXCEPTION_HANDLER ? mappingInfo : null;
    }

    @Nullable
    private ExceptionHandlerMappingInfo getMappedMethod(Class<? extends Throwable> exceptionType, MediaType mediaType) {
        ArrayList<ExceptionMapping> matches = new ArrayList<ExceptionMapping>();
        for (ExceptionMapping mappingInfo : this.mappedMethods.keySet()) {
            if (!mappingInfo.exceptionType().isAssignableFrom(exceptionType) || !mappingInfo.mediaType().isCompatibleWith(mediaType)) continue;
            matches.add(mappingInfo);
        }
        if (!matches.isEmpty()) {
            if (matches.size() > 1) {
                matches.sort(new ExceptionMapingComparator(exceptionType, mediaType));
            }
            return this.mappedMethods.get(matches.get(0));
        }
        return NO_MATCHING_EXCEPTION_HANDLER;
    }

    private void noMatchingExceptionHandler() {
    }

    static {
        try {
            NO_MATCHING_EXCEPTION_HANDLER = new ExceptionHandlerMappingInfo(Set.of(), Set.of(), ExceptionHandlerMethodResolver.class.getDeclaredMethod("noMatchingExceptionHandler", new Class[0]));
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Expected method not found: " + ex);
        }
    }

    private record ExceptionMapping(Class<? extends Throwable> exceptionType, MediaType mediaType) {
        @Override
        public String toString() {
            return "ExceptionHandler{exceptionType=%s, mediaType=%s}".formatted(this.exceptionType.getCanonicalName(), this.mediaType);
        }
    }

    private static class ExceptionMapingComparator
    implements Comparator<ExceptionMapping> {
        private final ExceptionDepthComparator exceptionDepthComparator;
        private final MediaType mediaType;

        public ExceptionMapingComparator(Class<? extends Throwable> exceptionType, MediaType mediaType) {
            this.exceptionDepthComparator = new ExceptionDepthComparator(exceptionType);
            this.mediaType = mediaType;
        }

        @Override
        public int compare(ExceptionMapping o1, ExceptionMapping o2) {
            int result = this.exceptionDepthComparator.compare(o1.exceptionType(), o2.exceptionType());
            if (result != 0) {
                return result;
            }
            if (o1.mediaType.equals(this.mediaType)) {
                return -1;
            }
            if (o2.mediaType.equals(this.mediaType)) {
                return 1;
            }
            if (o1.mediaType.equals(o2.mediaType)) {
                return 0;
            }
            return o1.mediaType.isMoreSpecific(o2.mediaType) ? -1 : 1;
        }
    }
}

