/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.method;

import infra.aop.support.AopUtils;
import infra.beans.factory.BeanFactory;
import infra.beans.factory.BeanFactoryUtils;
import infra.beans.factory.InitializingBean;
import infra.context.ApplicationContext;
import infra.context.ApplicationContextAware;
import infra.context.MessageSource;
import infra.http.MediaType;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.HandlerMatchingMetadata;
import infra.web.HttpMediaTypeNotAcceptableException;
import infra.web.RequestContext;
import infra.web.accept.ContentNegotiationManager;
import infra.web.bind.resolver.ParameterResolvingRegistry;
import infra.web.handler.AbstractHandlerMethodExceptionHandler;
import infra.web.handler.method.ControllerAdviceBean;
import infra.web.handler.method.ExceptionHandlerMappingInfo;
import infra.web.handler.method.ExceptionHandlerMethodResolver;
import infra.web.handler.method.HandlerMethod;
import infra.web.handler.method.InvocableHandlerMethod;
import infra.web.handler.method.RegistryResolvableParameterFactory;
import infra.web.handler.method.ResolvableParameterFactory;
import infra.web.resource.ResourceHttpRequestHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ExceptionHandlerAnnotationExceptionHandler
extends AbstractHandlerMethodExceptionHandler
implements ApplicationContextAware,
InitializingBean {
    private final ConcurrentHashMap<Class<?>, ExceptionHandlerMethodResolver> exceptionHandlerCache = new ConcurrentHashMap(64);
    private final LinkedHashMap<ControllerAdviceBean, ExceptionHandlerMethodResolver> exceptionHandlerAdviceCache = new LinkedHashMap();
    @Nullable
    private ApplicationContext applicationContext;
    private ResolvableParameterFactory parameterFactory;
    private ContentNegotiationManager contentNegotiationManager = new ContentNegotiationManager();

    public void setParameterResolvingRegistry(ParameterResolvingRegistry registry) {
        this.parameterFactory = new RegistryResolvableParameterFactory(registry);
    }

    public void setApplicationContext(@Nullable ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setContentNegotiationManager(ContentNegotiationManager contentNegotiationManager) {
        this.contentNegotiationManager = contentNegotiationManager;
    }

    @Override
    @Nullable
    protected Object handleInternal(RequestContext context, @Nullable HandlerMethod handlerMethod, Throwable target) {
        InvocableHandlerMethod exHandler = this.getExceptionHandlerMethod(context, handlerMethod, target);
        if (exHandler == null) {
            return null;
        }
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        try {
            HandlerMatchingMetadata metadata;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using @ExceptionHandler {}", (Object)exHandler);
            }
            Throwable exToExpose = target;
            while (exToExpose != null) {
                exceptions.add(exToExpose);
                Throwable cause = exToExpose.getCause();
                exToExpose = cause != exToExpose ? cause : null;
            }
            Object[] arguments = exceptions.toArray(new Object[exceptions.size() + 2]);
            if (handlerMethod != null) {
                arguments[arguments.length - 1] = handlerMethod;
                arguments[arguments.length - 2] = handlerMethod.getMethod();
            }
            if ((metadata = context.getMatchingMetadata()) != null) {
                metadata.setHandler(exHandler);
            }
            return exHandler.invokeAndHandle(context, arguments);
        }
        catch (Throwable invocationEx) {
            if (!disconnectedClientHelper.checkAndLogClientDisconnectedException(invocationEx) && !exceptions.contains(invocationEx) && this.logger.isWarnEnabled()) {
                this.logger.warn("Failure in @ExceptionHandler {}", (Object)exHandler, (Object)invocationEx);
            }
            return null;
        }
    }

    @Nullable
    protected InvocableHandlerMethod getExceptionHandlerMethod(RequestContext context, @Nullable HandlerMethod handlerMethod, Throwable exception) {
        List<MediaType> acceptedMediaTypes;
        block7: {
            acceptedMediaTypes = List.of(MediaType.ALL);
            try {
                acceptedMediaTypes = this.contentNegotiationManager.resolveMediaTypes(context);
            }
            catch (HttpMediaTypeNotAcceptableException mediaTypeExc) {
                if (!this.logger.isDebugEnabled()) break block7;
                this.logger.debug("Could not resolve accepted media types for @ExceptionHandler [{}]", (Object)context.requestHeaders().getFirst("Accept"), (Object)mediaTypeExc);
            }
        }
        Class handlerType = null;
        if (handlerMethod != null) {
            handlerType = handlerMethod.getBeanType();
            ExceptionHandlerMethodResolver resolver = this.exceptionHandlerCache.computeIfAbsent(handlerType, ExceptionHandlerMethodResolver::new);
            for (MediaType mediaType : acceptedMediaTypes) {
                ExceptionHandlerMappingInfo mappingInfo = resolver.resolveExceptionMapping(exception, mediaType);
                if (mappingInfo == null) continue;
                return this.createHandlerMethod(mappingInfo, context, handlerMethod.getBean());
            }
            if (Proxy.isProxyClass(handlerType)) {
                handlerType = AopUtils.getTargetClass((Object)handlerMethod.getBean());
            }
        }
        for (Map.Entry<ControllerAdviceBean, ExceptionHandlerMethodResolver> entry : this.exceptionHandlerAdviceCache.entrySet()) {
            ControllerAdviceBean advice = entry.getKey();
            if (!advice.isApplicableToBeanType(handlerType)) continue;
            ExceptionHandlerMethodResolver resolver = entry.getValue();
            for (MediaType mediaType : acceptedMediaTypes) {
                ExceptionHandlerMappingInfo mappingInfo = resolver.resolveExceptionMapping(exception, mediaType);
                if (mappingInfo == null) continue;
                return this.createHandlerMethod(mappingInfo, context, advice.resolveBean());
            }
        }
        return null;
    }

    private InvocableHandlerMethod createHandlerMethod(ExceptionHandlerMappingInfo mappingInfo, RequestContext context, Object advice) {
        HandlerMatchingMetadata matchingMetadata;
        if (!mappingInfo.getProducibleTypes().isEmpty() && (matchingMetadata = context.getMatchingMetadata()) != null) {
            matchingMetadata.setProducibleMediaTypes(mappingInfo.getProducibleTypes().toArray(new MediaType[0]));
        }
        return new InvocableHandlerMethod(advice, mappingInfo.getHandlerMethod(), (MessageSource)this.applicationContext, this.parameterFactory);
    }

    @Override
    protected boolean hasGlobalExceptionHandlers() {
        return !this.exceptionHandlerAdviceCache.isEmpty();
    }

    @Override
    protected boolean shouldApplyTo(RequestContext request, @Nullable Object handler) {
        return handler instanceof ResourceHttpRequestHandler ? this.hasGlobalExceptionHandlers() : super.shouldApplyTo(request, handler);
    }

    public void afterPropertiesSet() {
        ApplicationContext context = this.applicationContext;
        Assert.state((context != null ? 1 : 0) != 0, (String)"No ApplicationContext");
        if (this.parameterFactory == null) {
            ParameterResolvingRegistry registry = (ParameterResolvingRegistry)((Object)BeanFactoryUtils.find((BeanFactory)context, ParameterResolvingRegistry.class));
            this.parameterFactory = registry != null ? new RegistryResolvableParameterFactory(registry) : new ResolvableParameterFactory();
        }
        this.initExceptionHandlerAdviceCache(context);
    }

    private void initExceptionHandlerAdviceCache(ApplicationContext applicationContext) {
        List<ControllerAdviceBean> adviceBeans = ControllerAdviceBean.findAnnotatedBeans(applicationContext, new Class[0]);
        for (ControllerAdviceBean adviceBean : adviceBeans) {
            Class<?> beanType = adviceBean.getBeanType();
            if (beanType == null) {
                throw new IllegalStateException("Unresolvable type for ControllerAdviceBean: " + adviceBean);
            }
            ExceptionHandlerMethodResolver resolver = new ExceptionHandlerMethodResolver(beanType);
            if (!resolver.hasExceptionMappings()) continue;
            this.exceptionHandlerAdviceCache.put(adviceBean, resolver);
        }
        if (this.logger.isDebugEnabled()) {
            int handlerSize = this.exceptionHandlerAdviceCache.size();
            if (handlerSize == 0) {
                this.logger.debug("ControllerAdvice beans: none");
            } else {
                this.logger.debug("ControllerAdvice beans: {} @ExceptionHandler", (Object)handlerSize);
            }
        }
    }
}

