/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.method;

import infra.context.ApplicationContext;
import infra.core.MethodIntrospector;
import infra.core.annotation.AnnotatedElementUtils;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.util.ReflectionUtils;
import infra.web.annotation.RequestMapping;
import infra.web.bind.annotation.InitBinder;
import infra.web.bind.annotation.ModelAttribute;
import infra.web.handler.method.ControllerAdviceBean;
import infra.web.handler.method.HandlerMethod;
import infra.web.handler.method.InvocableHandlerMethod;
import infra.web.handler.method.ResolvableParameterFactory;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

final class ControllerMethodResolver {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final ReflectionUtils.MethodFilter INIT_BINDER_METHODS = method -> AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, InitBinder.class);
    public static final ReflectionUtils.MethodFilter MODEL_ATTRIBUTE_METHODS = method -> !AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, RequestMapping.class) && AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, ModelAttribute.class);
    private final Map<Class<?>, Set<Method>> initBinderCache = new ConcurrentHashMap(64);
    private final LinkedHashMap<ControllerAdviceBean, Set<Method>> initBinderAdviceCache = new LinkedHashMap();
    private final ConcurrentHashMap<Class<?>, Set<Method>> modelAttributeCache = new ConcurrentHashMap(64);
    private final LinkedHashMap<ControllerAdviceBean, Set<Method>> modelAttributeAdviceCache = new LinkedHashMap();
    private final ConcurrentHashMap<HandlerMethod, InvocableHandlerMethod> invocableHandlerMethodMap = new ConcurrentHashMap();
    private final ResolvableParameterFactory resolvableParameterFactory;

    ControllerMethodResolver(@Nullable ApplicationContext context, ResolvableParameterFactory parameterFactory) {
        this.resolvableParameterFactory = parameterFactory;
        if (context != null) {
            this.initControllerAdviceCache(context);
        }
    }

    private void initControllerAdviceCache(ApplicationContext context) {
        List<ControllerAdviceBean> adviceBeans = ControllerAdviceBean.findAnnotatedBeans(context, new Class[0]);
        for (ControllerAdviceBean adviceBean : adviceBeans) {
            Set binderMethods;
            Class<?> beanType = adviceBean.getBeanType();
            if (beanType == null) {
                throw new IllegalStateException("Unresolvable type for ControllerAdviceBean: " + adviceBean);
            }
            Set attrMethods = MethodIntrospector.filterMethods(beanType, (ReflectionUtils.MethodFilter)MODEL_ATTRIBUTE_METHODS);
            if (!attrMethods.isEmpty()) {
                this.modelAttributeAdviceCache.put(adviceBean, attrMethods);
            }
            if ((binderMethods = MethodIntrospector.filterMethods(beanType, (ReflectionUtils.MethodFilter)INIT_BINDER_METHODS)).isEmpty()) continue;
            this.initBinderAdviceCache.put(adviceBean, binderMethods);
        }
        if (this.log.isDebugEnabled()) {
            int binderSize = this.initBinderAdviceCache.size();
            int modelSize = this.modelAttributeAdviceCache.size();
            if (modelSize == 0 && binderSize == 0) {
                this.log.debug("ControllerAdvice beans: none");
            } else {
                this.log.debug("ControllerAdvice beans: {} @ModelAttribute, {} @InitBinder", (Object)modelSize, (Object)binderSize);
            }
        }
    }

    public List<InvocableHandlerMethod> getModelAttributeMethods(HandlerMethod handlerMethod) {
        Set methods;
        Object bean;
        Class<?> handlerType = handlerMethod.getBeanType();
        ArrayList<InvocableHandlerMethod> attrMethods = new ArrayList<InvocableHandlerMethod>();
        if (!this.modelAttributeAdviceCache.isEmpty()) {
            for (Map.Entry<ControllerAdviceBean, Set<Method>> entry : this.modelAttributeAdviceCache.entrySet()) {
                ControllerAdviceBean controllerAdviceBean = entry.getKey();
                if (!controllerAdviceBean.isApplicableToBeanType(handlerType)) continue;
                bean = controllerAdviceBean.resolveBean();
                for (Method method : entry.getValue()) {
                    attrMethods.add(this.createHandlerMethod(bean, method));
                }
            }
        }
        if ((methods = this.modelAttributeCache.get(handlerType)) == null) {
            methods = MethodIntrospector.filterMethods(handlerType, (ReflectionUtils.MethodFilter)MODEL_ATTRIBUTE_METHODS);
            this.modelAttributeCache.put(handlerType, methods);
        }
        if (!methods.isEmpty()) {
            for (Method method : methods) {
                bean = handlerMethod.getBean();
                attrMethods.add(this.createHandlerMethod(bean, method));
            }
        }
        return attrMethods;
    }

    public List<InvocableHandlerMethod> getBinderMethods(HandlerMethod handlerMethod) {
        Class<?> handlerType = handlerMethod.getBeanType();
        Set methods = this.initBinderCache.get(handlerType);
        if (methods == null) {
            methods = MethodIntrospector.filterMethods(handlerType, (ReflectionUtils.MethodFilter)INIT_BINDER_METHODS);
            this.initBinderCache.put(handlerType, methods);
        }
        ArrayList initBinderMethods = new ArrayList();
        for (Map.Entry<ControllerAdviceBean, Set<Method>> entry : this.initBinderAdviceCache.entrySet()) {
            Set<Method> methodSet = entry.getValue();
            ControllerAdviceBean controllerAdviceBean = entry.getKey();
            if (!controllerAdviceBean.isApplicableToBeanType(handlerType)) continue;
            Object bean = controllerAdviceBean.resolveBean();
            for (Method method : methodSet) {
                initBinderMethods.add(this.createHandlerMethod(bean, method));
            }
        }
        for (Method method : methods) {
            Object bean = handlerMethod.getBean();
            initBinderMethods.add(this.createHandlerMethod(bean, method));
        }
        return initBinderMethods.isEmpty() ? Collections.emptyList() : initBinderMethods;
    }

    public InvocableHandlerMethod createHandlerMethod(HandlerMethod handlerMethod) {
        return this.invocableHandlerMethodMap.computeIfAbsent(handlerMethod, handler -> new InvocableHandlerMethod((HandlerMethod)handler, this.resolvableParameterFactory));
    }

    private InvocableHandlerMethod createHandlerMethod(Object bean, Method method) {
        return new InvocableHandlerMethod(bean, method, this.resolvableParameterFactory);
    }
}

