/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.method;

import infra.aop.support.AopUtils;
import infra.beans.BeanUtils;
import infra.beans.factory.BeanDefinitionStoreException;
import infra.beans.factory.BeanFactory;
import infra.beans.factory.BeanFactoryUtils;
import infra.beans.factory.InitializingBean;
import infra.beans.factory.support.BeanDefinitionRegistry;
import infra.context.ApplicationContext;
import infra.context.MessageSource;
import infra.context.annotation.AnnotatedBeanDefinitionReader;
import infra.core.MethodIntrospector;
import infra.core.annotation.MergedAnnotation;
import infra.core.annotation.MergedAnnotations;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.ClassUtils;
import infra.util.MapCache;
import infra.util.ObjectUtils;
import infra.util.ReflectionUtils;
import infra.web.HandlerInterceptor;
import infra.web.InfraConfigurationException;
import infra.web.RequestContext;
import infra.web.annotation.Interceptor;
import infra.web.cors.CorsConfiguration;
import infra.web.handler.AbstractHandlerMapping;
import infra.web.handler.HandlerMethodMappingNamingStrategy;
import infra.web.handler.method.HandlerMethod;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public abstract class AbstractHandlerMethodMapping<T>
extends AbstractHandlerMapping
implements InitializingBean {
    private static final String SCOPED_TARGET_NAME_PREFIX = "scopedTarget.";
    private static final HandlerMethod PREFLIGHT_AMBIGUOUS_MATCH = new HandlerMethod(new EmptyHandler(), ReflectionUtils.getMethod(EmptyHandler.class, (String)"handle", (Class[])new Class[0]));
    private static final CorsConfiguration ALLOW_CORS_CONFIG = new CorsConfiguration();
    private boolean detectHandlerMethodsInAncestorContexts = false;
    @Nullable
    private HandlerMethodMappingNamingStrategy<T> namingStrategy;
    @Nullable
    private BeanDefinitionRegistry registry;
    @Nullable
    private AnnotatedBeanDefinitionReader beanDefinitionReader;
    private boolean useInheritedInterceptor = true;
    final MappingRegistry mappingRegistry = new MappingRegistry();

    public void setDetectHandlerMethodsInAncestorContexts(boolean detectHandlerMethodsInAncestorContexts) {
        this.detectHandlerMethodsInAncestorContexts = detectHandlerMethodsInAncestorContexts;
    }

    public void setHandlerMethodMappingNamingStrategy(HandlerMethodMappingNamingStrategy<T> namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public void setUseInheritedInterceptor(boolean useInheritedInterceptor) {
        this.useInheritedInterceptor = useInheritedInterceptor;
    }

    @Nullable
    public HandlerMethodMappingNamingStrategy<T> getNamingStrategy() {
        return this.namingStrategy;
    }

    public Map<T, HandlerMethod> getHandlerMethods() {
        return Collections.unmodifiableMap(this.mappingRegistry.registrations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((MappingRegistration)entry.getValue()).handlerMethod)));
    }

    @Nullable
    public List<HandlerMethod> getHandlerMethodsForMappingName(String mappingName) {
        return this.mappingRegistry.getHandlerMethodsByMappingName(mappingName);
    }

    public void registerMapping(T mapping, Object handler, Method method) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Register \"{}\" to {}", mapping, (Object)method.toGenericString());
        }
        this.mappingRegistry.register(mapping, handler, method);
    }

    public void unregisterMapping(T mapping) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Unregister mapping \"{}\"", mapping);
        }
        this.mappingRegistry.unregister(mapping);
    }

    public void afterPropertiesSet() {
        this.initHandlerMethods();
    }

    protected void initHandlerMethods() {
        BeanFactory beanFactory = this.obtainApplicationContext().getBeanFactory();
        for (String beanName : this.getCandidateBeanNames()) {
            if (beanName.startsWith(SCOPED_TARGET_NAME_PREFIX)) continue;
            this.processCandidateBean(beanFactory, beanName);
        }
        this.handlerMethodsInitialized(this.getHandlerMethods());
    }

    protected Set<String> getCandidateBeanNames() {
        return this.detectHandlerMethodsInAncestorContexts ? BeanFactoryUtils.beanNamesForTypeIncludingAncestors((BeanFactory)this.obtainApplicationContext(), Object.class) : this.obtainApplicationContext().getBeanNamesForType(Object.class);
    }

    protected void processCandidateBean(BeanFactory beanFactory, String beanName) {
        Class beanType = null;
        try {
            beanType = beanFactory.getType(beanName);
        }
        catch (Throwable ex) {
            this.logger.trace("Could not resolve type for bean '{}'", (Object)beanName, (Object)ex);
        }
        if (beanType != null && this.isHandler(beanType)) {
            this.detectHandlerMethods(beanType, beanName);
        }
    }

    protected void detectHandlerMethods(Object handler) {
        Class handlerType;
        if (handler instanceof String) {
            String beanName = (String)handler;
            v0 = this.obtainApplicationContext().getType(beanName);
        } else {
            v0 = handlerType = handler.getClass();
        }
        if (handlerType != null) {
            this.detectHandlerMethods(handlerType, handler);
        }
    }

    private void detectHandlerMethods(Class<?> handlerType, Object handler) {
        Class userType = ClassUtils.getUserClass(handlerType);
        Map methods = MethodIntrospector.selectMethods((Class)userType, method -> {
            try {
                return this.getMappingForMethod(method, userType);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Invalid mapping on handler class [%s]: %s".formatted(userType.getName(), method), ex);
            }
        });
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.formatMappings(userType, methods));
        } else if (this.mappingsLogger.isDebugEnabled()) {
            this.mappingsLogger.debug(this.formatMappings(userType, methods));
        }
        for (Map.Entry entry : methods.entrySet()) {
            Method invocableMethod = AopUtils.selectInvocableMethod((Method)((Method)entry.getKey()), (Class)userType);
            this.registerHandlerMethod(handler, invocableMethod, entry.getValue());
        }
    }

    private String formatMappings(Class<?> userType, Map<Method, T> methods) {
        return methods.entrySet().stream().map(e -> {
            Method method = (Method)e.getKey();
            return e.getValue() + ": " + method.getName() + Arrays.stream(method.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(",", "(", ")"));
        }).collect(Collectors.joining("\n\t", "\n\t%s:\n\t".formatted(userType.getName()), ""));
    }

    protected void registerHandlerMethod(Object handler, Method method, T mapping) {
        this.mappingRegistry.register(mapping, handler, method);
    }

    protected HandlerMethod createHandlerMethod(Object handler, Method method) {
        if (handler instanceof String) {
            String beanName = (String)handler;
            ApplicationContext context = this.obtainApplicationContext();
            return new HandlerMethod(beanName, context.getBeanFactory(), (MessageSource)context, method);
        }
        return new HandlerMethod(handler, method);
    }

    @Nullable
    protected CorsConfiguration initCorsConfiguration(Object handler, HandlerMethod handlerMethod, Method method, T mapping) {
        return null;
    }

    protected void handlerMethodsInitialized(Map<T, HandlerMethod> handlerMethods) {
        int total = handlerMethods.size();
        if (this.logger.isTraceEnabled() && total == 0 || this.logger.isDebugEnabled() && total > 0) {
            this.logger.debug("{} mappings in {}", (Object)total, (Object)this.formatMappingName());
        }
    }

    @Override
    @Nullable
    protected HandlerMethod getHandlerInternal(RequestContext request) {
        Object handler;
        HandlerMethod handlerMethod = this.lookupHandlerMethod(request.getRequestPath().value(), request);
        if (handlerMethod != null && (handler = handlerMethod.getBean()) instanceof String) {
            String beanName = (String)handler;
            handler = this.obtainApplicationContext().getBean(beanName);
            return handlerMethod.withBean(handler);
        }
        return handlerMethod;
    }

    @Nullable
    protected HandlerMethod lookupHandlerMethod(String directLookupPath, RequestContext request) {
        Match<T> bestMatch;
        ArrayList<Match<T>> matches = new ArrayList<Match<T>>();
        List directPathMatches = this.mappingRegistry.getDirectPathMappings(directLookupPath);
        if (directPathMatches != null) {
            this.addMatchingMappings(directPathMatches, matches, request);
        }
        if (matches.isEmpty()) {
            this.addMatchingMappings(this.mappingRegistry.registrations.keySet(), matches, request);
        }
        if (matches.isEmpty()) {
            return this.handleNoMatch(this.mappingRegistry.registrations.keySet(), directLookupPath, request);
        }
        if (matches.size() > 1) {
            MatchComparator comparator = new MatchComparator(this.getMappingComparator(request));
            matches.sort(comparator);
            bestMatch = matches.get(0);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("{} matching mappings: {}", (Object)matches.size(), matches);
            }
            if (request.isPreFlightRequest()) {
                for (Match<T> match : matches) {
                    if (!match.hasCorsConfig()) continue;
                    return PREFLIGHT_AMBIGUOUS_MATCH;
                }
            } else {
                Match<T> secondBestMatch = matches.get(1);
                if (comparator.compare(bestMatch, secondBestMatch) == 0) {
                    Method m1 = bestMatch.getHandlerMethod().getMethod();
                    Method m2 = secondBestMatch.getHandlerMethod().getMethod();
                    String uri = request.getRequestURI();
                    throw new IllegalStateException("Ambiguous handler methods mapped for '%s': {%s, %s}".formatted(uri, m1, m2));
                }
            }
        } else {
            bestMatch = matches.get(0);
        }
        this.handleMatch(bestMatch, directLookupPath, request);
        return bestMatch.getHandlerMethod();
    }

    private void addMatchingMappings(Collection<T> mappings, ArrayList<Match<T>> matches, RequestContext request) {
        ConcurrentHashMap registrations = this.mappingRegistry.registrations;
        for (T mapping : mappings) {
            T match = this.getMatchingMapping(mapping, request);
            if (match == null) continue;
            matches.add(new Match<T>(match, registrations.get(mapping)));
        }
    }

    protected abstract void handleMatch(Match<T> var1, String var2, RequestContext var3);

    @Nullable
    protected HandlerMethod handleNoMatch(Set<T> mappings, String lookupPath, RequestContext request) {
        return null;
    }

    @Override
    protected boolean hasCorsConfigurationSource(Object handler) {
        HandlerMethod handlerMethod;
        return super.hasCorsConfigurationSource(handler) || (handlerMethod = HandlerMethod.unwrap(handler)) != null && this.mappingRegistry.getCorsConfiguration(handlerMethod) != null;
    }

    @Override
    protected CorsConfiguration getCorsConfiguration(Object handler, RequestContext request) {
        CorsConfiguration corsConfig = super.getCorsConfiguration(handler, request);
        HandlerMethod handlerMethod = HandlerMethod.unwrap(handler);
        if (handlerMethod != null) {
            if (handlerMethod.equals(PREFLIGHT_AMBIGUOUS_MATCH)) {
                return ALLOW_CORS_CONFIG;
            }
            CorsConfiguration corsConfigFromMethod = this.mappingRegistry.getCorsConfiguration(handlerMethod);
            corsConfig = corsConfig != null ? corsConfig.combine(corsConfigFromMethod) : corsConfigFromMethod;
        }
        return corsConfig;
    }

    @Override
    @Nullable
    protected HandlerInterceptor[] getHandlerInterceptors(Object handler) {
        HandlerMethod handlerMethod = HandlerMethod.unwrap(handler);
        if (handlerMethod != null) {
            return this.mappingRegistry.getHandlerInterceptors(handlerMethod);
        }
        return null;
    }

    protected List<HandlerInterceptor> getInterceptors(Class<?> controllerClass, Method action) {
        ArrayList<HandlerInterceptor> ret = new ArrayList<HandlerInterceptor>();
        ApplicationContext context = this.getApplicationContext();
        MergedAnnotations.from(controllerClass, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).stream(Interceptor.class).forEach(interceptor -> this.addInterceptors(context, ret, (MergedAnnotation<Interceptor>)interceptor));
        MergedAnnotations.from((AnnotatedElement)action, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).stream(Interceptor.class).forEach(interceptor -> {
            this.addInterceptors(context, ret, (MergedAnnotation<Interceptor>)interceptor);
            if (context != null) {
                for (Class exclude : interceptor.getClassArray("exclude")) {
                    ret.remove(context.getBean(exclude));
                }
                for (String excludeName : interceptor.getStringArray("excludeNames")) {
                    ret.remove(context.getBean(excludeName, HandlerInterceptor.class));
                }
            }
        });
        return ret;
    }

    private void addInterceptors(@Nullable ApplicationContext context, ArrayList<HandlerInterceptor> ret, MergedAnnotation<Interceptor> annotation) {
        Object[] interceptors = annotation.getClassValueArray();
        if (context == null) {
            if (ObjectUtils.isNotEmpty((Object[])interceptors)) {
                for (Object interceptor : interceptors) {
                    HandlerInterceptor instance = (HandlerInterceptor)BeanUtils.newInstance((Class)interceptor);
                    ret.add(instance);
                }
            }
            return;
        }
        if (ObjectUtils.isNotEmpty((Object[])interceptors)) {
            for (Object interceptor : interceptors) {
                HandlerInterceptor instance;
                if (this.useInheritedInterceptor) {
                    instance = (HandlerInterceptor)BeanFactoryUtils.find((BeanFactory)context, (Class)interceptor);
                    if (instance == null) {
                        this.registerInterceptorBean((Class<?>)interceptor);
                        instance = (HandlerInterceptor)context.getBean((Class)interceptor);
                    }
                    ret.add(instance);
                    continue;
                }
                if (!this.registry().containsBeanDefinition((Class)interceptor, true)) {
                    this.registerInterceptorBean((Class<?>)interceptor);
                }
                instance = (HandlerInterceptor)context.getBean((Class)interceptor);
                ret.add(instance);
            }
        }
        for (String includeName : annotation.getStringArray("includeNames")) {
            Object bean = context.getBean(includeName);
            if (!(bean instanceof HandlerInterceptor)) {
                throw new IllegalStateException("The bean '%s' is not a HandlerInterceptor".formatted(includeName));
            }
            HandlerInterceptor handlerInterceptor = (HandlerInterceptor)bean;
            ret.add(handlerInterceptor);
        }
    }

    private void registerInterceptorBean(Class<?> interceptor) {
        if (this.beanDefinitionReader == null) {
            this.beanDefinitionReader = new AnnotatedBeanDefinitionReader(this.registry());
        }
        try {
            this.beanDefinitionReader.registerBean(interceptor);
        }
        catch (BeanDefinitionStoreException e) {
            throw new InfraConfigurationException("Interceptor: [%s] register error".formatted(interceptor.getName()), e);
        }
    }

    private BeanDefinitionRegistry registry() {
        if (this.registry == null) {
            this.registry = (BeanDefinitionRegistry)this.unwrapContext(BeanDefinitionRegistry.class);
        }
        return this.registry;
    }

    protected abstract boolean isHandler(Class<?> var1);

    @Nullable
    protected abstract T getMappingForMethod(Method var1, Class<?> var2);

    protected abstract Set<String> getDirectPaths(T var1);

    @Nullable
    protected abstract T getMatchingMapping(T var1, RequestContext var2);

    protected abstract Comparator<T> getMappingComparator(RequestContext var1);

    static {
        ALLOW_CORS_CONFIG.addAllowedOriginPattern("*");
        ALLOW_CORS_CONFIG.addAllowedMethod("*");
        ALLOW_CORS_CONFIG.addAllowedHeader("*");
        ALLOW_CORS_CONFIG.setAllowCredentials(true);
    }

    final class MappingRegistry
    extends MapCache<Method, HandlerInterceptor[], HandlerMethod> {
        public final ConcurrentHashMap<T, MappingRegistration<T>> registrations = new ConcurrentHashMap(128);
        public final ConcurrentHashMap<String, List<T>> pathLookup = new ConcurrentHashMap(128);
        public final ConcurrentHashMap<String, List<HandlerMethod>> nameLookup = new ConcurrentHashMap();

        MappingRegistry() {
        }

        @Nullable
        public List<T> getDirectPathMappings(String urlPath) {
            return this.pathLookup.get(urlPath);
        }

        public List<HandlerMethod> getHandlerMethodsByMappingName(String mappingName) {
            return this.nameLookup.get(mappingName);
        }

        @Nullable
        public CorsConfiguration getCorsConfiguration(HandlerMethod handlerMethod) {
            return handlerMethod.corsConfig;
        }

        public void register(T mapping, Object handler, Method method) {
            CorsConfiguration corsConfig;
            HandlerMethod handlerMethod = AbstractHandlerMethodMapping.this.createHandlerMethod(handler, method);
            this.validateMethodMapping(handlerMethod, mapping);
            Set<String> directPaths = AbstractHandlerMethodMapping.this.getDirectPaths(mapping);
            for (String path : directPaths) {
                List mappings = this.pathLookup.get(path);
                if (mappings == null) {
                    mappings = new ArrayList(1);
                    this.pathLookup.put(path, mappings);
                }
                mappings.add(mapping);
            }
            String name = null;
            HandlerMethodMappingNamingStrategy namingStrategy = AbstractHandlerMethodMapping.this.getNamingStrategy();
            if (namingStrategy != null) {
                name = namingStrategy.getName(handlerMethod, mapping);
                this.addMappingName(name, handlerMethod);
            }
            if ((corsConfig = AbstractHandlerMethodMapping.this.initCorsConfiguration(handler, handlerMethod, method, mapping)) != null) {
                corsConfig.validateAllowCredentials();
                corsConfig.validateAllowPrivateNetwork();
                handlerMethod.corsConfig = corsConfig;
            }
            this.registrations.put(mapping, new MappingRegistration(mapping, handlerMethod, directPaths, name, corsConfig != null));
        }

        private void validateMethodMapping(HandlerMethod handlerMethod, T mapping) {
            HandlerMethod existingHandlerMethod;
            MappingRegistration registration = this.registrations.get(mapping);
            HandlerMethod handlerMethod2 = existingHandlerMethod = registration != null ? registration.handlerMethod : null;
            if (existingHandlerMethod != null && !existingHandlerMethod.equals(handlerMethod)) {
                throw new IllegalStateException("Ambiguous mapping. Cannot map '%s' method \n%s\nto %s: There is already '%s' bean method\n%s mapped.".formatted(handlerMethod.getBean(), handlerMethod, mapping, existingHandlerMethod.getBean(), existingHandlerMethod));
            }
        }

        private void addMappingName(String name, HandlerMethod handlerMethod) {
            List<HandlerMethod> oldList = this.nameLookup.get(name);
            if (oldList == null) {
                oldList = Collections.emptyList();
            }
            for (HandlerMethod current : oldList) {
                if (!handlerMethod.equals(current)) continue;
                return;
            }
            ArrayList<HandlerMethod> newList = new ArrayList<HandlerMethod>(oldList.size() + 1);
            newList.addAll(oldList);
            newList.add(handlerMethod);
            this.nameLookup.put(name, newList);
        }

        public void unregister(T mapping) {
            MappingRegistration registration = this.registrations.remove(mapping);
            if (registration == null) {
                return;
            }
            for (String path : registration.directPaths) {
                List mappings = this.pathLookup.get(path);
                if (mappings == null) continue;
                mappings.remove(registration.mapping);
                if (!mappings.isEmpty()) continue;
                this.pathLookup.remove(path);
            }
            this.removeMappingName(registration);
        }

        private void removeMappingName(MappingRegistration<T> definition) {
            String name = definition.mappingName;
            if (name == null) {
                return;
            }
            HandlerMethod handlerMethod = definition.handlerMethod;
            List<HandlerMethod> oldList = this.nameLookup.get(name);
            if (oldList == null) {
                return;
            }
            if (oldList.size() <= 1) {
                this.nameLookup.remove(name);
                return;
            }
            ArrayList<HandlerMethod> newList = new ArrayList<HandlerMethod>(oldList.size() - 1);
            for (HandlerMethod current : oldList) {
                if (current.equals(handlerMethod)) continue;
                newList.add(current);
            }
            this.nameLookup.put(name, newList);
        }

        protected HandlerInterceptor[] createValue(Method method, HandlerMethod handlerMethod) {
            Class<?> controllerClass = this.getControllerClass(method, handlerMethod);
            List<HandlerInterceptor> interceptors = AbstractHandlerMethodMapping.this.getInterceptors(controllerClass, method);
            return interceptors.toArray(HandlerInterceptor.EMPTY_ARRAY);
        }

        private Class<?> getControllerClass(Method method, @Nullable HandlerMethod handlerMethod) {
            if (handlerMethod != null) {
                return handlerMethod.getBeanType();
            }
            return ClassUtils.getUserClass(method.getDeclaringClass());
        }

        public HandlerInterceptor[] getHandlerInterceptors(HandlerMethod handlerMethod) {
            Method method = handlerMethod.getMethod();
            return (HandlerInterceptor[])this.get(method, handlerMethod);
        }
    }

    private class MatchComparator
    implements Comparator<Match<T>> {
        private final Comparator<T> comparator;

        public MatchComparator(Comparator<T> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(Match<T> match1, Match<T> match2) {
            return this.comparator.compare(match1.mapping, match2.mapping);
        }
    }

    protected static final class Match<T> {
        public final T mapping;
        public final MappingRegistration<T> registration;

        public Match(T mapping, MappingRegistration<T> registration) {
            this.mapping = mapping;
            this.registration = registration;
        }

        public HandlerMethod getHandlerMethod() {
            return this.registration.handlerMethod;
        }

        public boolean hasCorsConfig() {
            return this.registration.hasCorsConfig;
        }

        public String toString() {
            return this.mapping.toString();
        }
    }

    static class MappingRegistration<T> {
        public final T mapping;
        @Nullable
        public final String mappingName;
        public final boolean hasCorsConfig;
        public final Set<String> directPaths;
        public final HandlerMethod handlerMethod;

        MappingRegistration(T mapping, HandlerMethod handlerMethod, @Nullable Set<String> directPaths, @Nullable String mappingName, boolean hasCorsConfig) {
            Assert.notNull(mapping, (String)"Mapping is required");
            Assert.notNull((Object)handlerMethod, (String)"HandlerMethod is required");
            this.mapping = mapping;
            this.mappingName = mappingName;
            this.hasCorsConfig = hasCorsConfig;
            this.handlerMethod = handlerMethod;
            this.directPaths = directPaths != null ? directPaths : Collections.emptySet();
        }
    }

    private static class EmptyHandler {
        private EmptyHandler() {
        }

        public void handle() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

