/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.function.support;

import infra.beans.factory.InitializingBean;
import infra.context.ApplicationContext;
import infra.http.converter.AllEncompassingFormHttpMessageConverter;
import infra.http.converter.ByteArrayHttpMessageConverter;
import infra.http.converter.HttpMessageConverter;
import infra.http.converter.StringHttpMessageConverter;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.web.RequestContext;
import infra.web.handler.AbstractHandlerMapping;
import infra.web.handler.function.HandlerFunction;
import infra.web.handler.function.RouterFunction;
import infra.web.handler.function.RouterFunctions;
import infra.web.handler.function.ServerRequest;
import infra.web.util.pattern.PathPatternParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RouterFunctionMapping
extends AbstractHandlerMapping
implements InitializingBean {
    @Nullable
    private RouterFunction<?> routerFunction;
    private List<HttpMessageConverter<?>> messageConverters = Collections.emptyList();
    private boolean detectHandlerFunctionsInAncestorContexts = false;

    public RouterFunctionMapping() {
    }

    public RouterFunctionMapping(RouterFunction<?> routerFunction) {
        this.routerFunction = routerFunction;
    }

    public void setRouterFunction(@Nullable RouterFunction<?> routerFunction) {
        this.routerFunction = routerFunction;
    }

    @Nullable
    public RouterFunction<?> getRouterFunction() {
        return this.routerFunction;
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.messageConverters = messageConverters;
    }

    public void setDetectHandlerFunctionsInAncestorContexts(boolean detectHandlerFunctionsInAncestorContexts) {
        this.detectHandlerFunctionsInAncestorContexts = detectHandlerFunctionsInAncestorContexts;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.routerFunction == null) {
            this.initRouterFunctions();
        }
        if (CollectionUtils.isEmpty(this.messageConverters)) {
            this.initMessageConverters();
        }
        if (this.routerFunction != null) {
            PathPatternParser patternParser = this.getPatternParser();
            RouterFunctions.changeParser(this.routerFunction, patternParser);
        }
    }

    private void initRouterFunctions() {
        ArrayList routerFunctions = this.obtainApplicationContext().getBeanProvider(RouterFunction.class).orderedList();
        ApplicationContext parentContext = this.obtainApplicationContext().getParent();
        if (parentContext != null && !this.detectHandlerFunctionsInAncestorContexts) {
            parentContext.getBeanProvider(RouterFunction.class).stream().forEach(routerFunctions::remove);
        }
        this.routerFunction = routerFunctions.stream().reduce(RouterFunction::andOther).orElse(null);
        this.logRouterFunctions(routerFunctions);
    }

    private void logRouterFunctions(List<RouterFunction> routerFunctions) {
        if (this.mappingsLogger.isDebugEnabled()) {
            routerFunctions.forEach(function -> this.mappingsLogger.debug("Mapped {}", function));
        } else if (this.logger.isDebugEnabled()) {
            int total = routerFunctions.size();
            String message = total + " RouterFunction(s) in " + this.formatMappingName();
            if (this.logger.isTraceEnabled()) {
                if (total > 0) {
                    routerFunctions.forEach(function -> this.logger.trace("Mapped {}", function));
                } else {
                    this.logger.trace(message);
                }
            } else if (total > 0) {
                this.logger.debug(message);
            }
        }
    }

    private void initMessageConverters() {
        ArrayList messageConverters = new ArrayList(4);
        messageConverters.add(new ByteArrayHttpMessageConverter());
        messageConverters.add(new StringHttpMessageConverter());
        messageConverters.add(new AllEncompassingFormHttpMessageConverter());
        this.messageConverters = messageConverters;
    }

    @Override
    @Nullable
    protected Object getHandlerInternal(RequestContext context) throws Exception {
        if (this.routerFunction != null) {
            ServerRequest request = ServerRequest.create(context, this.messageConverters);
            HandlerFunction handlerFunction = this.routerFunction.route(request).orElse(null);
            if (handlerFunction != null) {
                context.setAttribute(RouterFunctions.REQUEST_ATTRIBUTE, request);
            }
            return handlerFunction;
        }
        return null;
    }
}

