/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.function.support;

import infra.core.Ordered;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.util.LogFormatUtils;
import infra.web.HandlerAdapter;
import infra.web.RequestContext;
import infra.web.async.WebAsyncManager;
import infra.web.handler.function.HandlerFunction;
import infra.web.handler.function.ServerRequest;
import infra.web.handler.function.ServerResponse;

public class HandlerFunctionAdapter
implements HandlerAdapter,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(HandlerFunctionAdapter.class);
    private int order = Integer.MAX_VALUE;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public boolean supports(Object handler) {
        return handler instanceof HandlerFunction;
    }

    @Override
    @Nullable
    public Object handle(RequestContext context, Object handler) throws Throwable {
        ServerResponse serverResponse;
        WebAsyncManager asyncManager = context.getAsyncManager();
        ServerRequest serverRequest = ServerRequest.findRequired(context);
        if (asyncManager.hasConcurrentResult()) {
            serverResponse = this.handleAsync(asyncManager);
        } else {
            HandlerFunction handlerFunction = (HandlerFunction)handler;
            serverResponse = handlerFunction.handle(serverRequest);
        }
        if (serverResponse != null) {
            return serverResponse.writeTo(context, serverRequest);
        }
        return NONE_RETURN_VALUE;
    }

    @Nullable
    private ServerResponse handleAsync(WebAsyncManager asyncManager) throws Throwable {
        Object result = asyncManager.getConcurrentResult();
        asyncManager.clearConcurrentResult();
        LogFormatUtils.traceDebug((Logger)logger, traceOn -> {
            String formatted = LogFormatUtils.formatValue((Object)result, (traceOn == false ? 1 : 0) != 0);
            return "Resume with async result [%s]".formatted(formatted);
        });
        if (result instanceof ServerResponse) {
            return (ServerResponse)result;
        }
        if (result instanceof Throwable) {
            throw (Throwable)result;
        }
        if (result == null) {
            return null;
        }
        throw new IllegalArgumentException("Unknown result from WebAsyncManager: [%s]".formatted(result));
    }
}

