/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.function;

import infra.http.HttpCookie;
import infra.http.HttpHeaders;
import infra.http.HttpStatusCode;
import infra.http.MediaType;
import infra.http.converter.HttpMessageConverter;
import infra.http.server.DelegatingServerHttpResponse;
import infra.http.server.ServerHttpResponse;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.MultiValueMap;
import infra.web.RequestContext;
import infra.web.async.DeferredResult;
import infra.web.handler.function.AbstractServerResponse;
import infra.web.handler.function.DefaultAsyncServerResponse;
import infra.web.handler.function.ServerResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

final class StreamingServerResponse
extends AbstractServerResponse {
    private final Consumer<ServerResponse.StreamBuilder> streamConsumer;
    @Nullable
    private final Duration timeout;

    private StreamingServerResponse(HttpStatusCode statusCode, HttpHeaders headers, MultiValueMap<String, HttpCookie> cookies, Consumer<ServerResponse.StreamBuilder> streamConsumer, @Nullable Duration timeout) {
        super(statusCode, headers, cookies);
        this.streamConsumer = streamConsumer;
        this.timeout = timeout;
    }

    static ServerResponse create(HttpStatusCode statusCode, HttpHeaders headers, MultiValueMap<String, HttpCookie> cookies, Consumer<ServerResponse.StreamBuilder> streamConsumer, @Nullable Duration timeout) {
        Assert.notNull((Object)statusCode, (String)"statusCode is required");
        Assert.notNull((Object)headers, (String)"headers is required");
        Assert.notNull(cookies, (String)"cookies is required");
        Assert.notNull(streamConsumer, (String)"streamConsumer is required");
        return new StreamingServerResponse(statusCode, headers, cookies, streamConsumer, timeout);
    }

    @Override
    @Nullable
    protected Object writeToInternal(RequestContext request, ServerResponse.Context context) throws Throwable {
        DeferredResult result = new DeferredResult(this.timeout != null ? Long.valueOf(this.timeout.toMillis()) : null);
        DefaultAsyncServerResponse.writeAsync(request, result);
        this.streamConsumer.accept(new DefaultStreamBuilder(request, context, result, this.headers()));
        return null;
    }

    private static class DefaultStreamBuilder
    implements ServerResponse.StreamBuilder {
        private final ServerHttpResponse outputMessage;
        private final DeferredResult<?> deferredResult;
        private final List<HttpMessageConverter<?>> messageConverters;
        private final HttpHeaders httpHeaders;
        private boolean sendFailed;

        public DefaultStreamBuilder(RequestContext response, ServerResponse.Context context, DeferredResult<?> deferredResult, HttpHeaders httpHeaders) {
            this.outputMessage = response.asHttpOutputMessage();
            this.deferredResult = deferredResult;
            this.messageConverters = context.messageConverters();
            this.httpHeaders = httpHeaders;
        }

        @Override
        public ServerResponse.StreamBuilder write(Object object) throws IOException {
            this.write(object, null);
            return this;
        }

        @Override
        public ServerResponse.StreamBuilder write(Object object, @Nullable MediaType mediaType) throws IOException {
            Assert.notNull((Object)object, (String)"data is required");
            try {
                if (object instanceof byte[]) {
                    byte[] bytes = (byte[])object;
                    this.outputMessage.getBody().write(bytes);
                } else if (object instanceof String) {
                    String str = (String)object;
                    this.outputMessage.getBody().write(str.getBytes(StandardCharsets.UTF_8));
                } else {
                    this.writeObject(object, mediaType);
                }
            }
            catch (IOException ex) {
                this.sendFailed = true;
                throw ex;
            }
            return this;
        }

        private void writeObject(Object data, @Nullable MediaType mediaType) throws IOException {
            Class<?> elementClass = data.getClass();
            for (HttpMessageConverter<?> converter : this.messageConverters) {
                if (!converter.canWrite(elementClass, mediaType)) continue;
                HttpMessageConverter<?> objectConverter = converter;
                MutableHeadersServerHttpResponse response = new MutableHeadersServerHttpResponse(this.outputMessage, this.httpHeaders);
                objectConverter.write(data, mediaType, response);
                return;
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.sendFailed) {
                return;
            }
            try {
                this.outputMessage.flush();
            }
            catch (IOException ex) {
                this.sendFailed = true;
                throw ex;
            }
        }

        @Override
        public void error(Throwable t) {
            if (this.sendFailed) {
                return;
            }
            this.deferredResult.setErrorResult(t);
        }

        @Override
        public void complete() {
            if (this.sendFailed) {
                return;
            }
            try {
                this.outputMessage.flush();
                this.deferredResult.setResult(null);
            }
            catch (IOException ex) {
                this.deferredResult.setErrorResult(ex);
            }
        }

        @Override
        public ServerResponse.StreamBuilder onTimeout(Runnable onTimeout) {
            this.deferredResult.onTimeout(onTimeout);
            return this;
        }

        @Override
        public ServerResponse.StreamBuilder onError(Consumer<Throwable> onError) {
            this.deferredResult.onError(onError);
            return this;
        }

        @Override
        public ServerResponse.StreamBuilder onComplete(Runnable onCompletion) {
            this.deferredResult.onCompletion(onCompletion);
            return this;
        }

        private static final class MutableHeadersServerHttpResponse
        extends DelegatingServerHttpResponse {
            private final HttpHeaders mutableHeaders = HttpHeaders.forWritable();

            public MutableHeadersServerHttpResponse(ServerHttpResponse delegate, HttpHeaders headers) {
                super(delegate);
                this.mutableHeaders.putAll((Map)((Object)delegate.getHeaders()));
                this.mutableHeaders.putAll((Map)((Object)headers));
            }

            @Override
            public HttpHeaders getHeaders() {
                return this.mutableHeaders;
            }
        }
    }
}

