/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.function;

import infra.http.CacheControl;
import infra.http.DefaultHttpHeaders;
import infra.http.HttpHeaders;
import infra.http.HttpStatus;
import infra.http.MediaType;
import infra.http.converter.HttpMessageConverter;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.async.DeferredResult;
import infra.web.handler.function.AbstractServerResponse;
import infra.web.handler.function.DefaultAsyncServerResponse;
import infra.web.handler.function.ServerResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.function.Consumer;

final class SseServerResponse
extends AbstractServerResponse {
    private final Consumer<ServerResponse.SseBuilder> sseConsumer;
    @Nullable
    private final Duration timeout;

    public SseServerResponse(Consumer<ServerResponse.SseBuilder> sseConsumer, @Nullable Duration timeout) {
        super(HttpStatus.OK, SseServerResponse.createHeaders(), null);
        Assert.notNull(sseConsumer, (String)"SseConsumer is required");
        this.sseConsumer = sseConsumer;
        this.timeout = timeout;
    }

    private static HttpHeaders createHeaders() {
        DefaultHttpHeaders headers = HttpHeaders.forWritable();
        headers.setContentType(MediaType.TEXT_EVENT_STREAM);
        headers.setCacheControl(CacheControl.noCache());
        return headers;
    }

    @Override
    protected Object writeToInternal(RequestContext request, ServerResponse.Context context) throws Exception {
        DeferredResult result = this.timeout != null ? new DeferredResult(this.timeout.toMillis()) : new DeferredResult();
        DefaultAsyncServerResponse.writeAsync(request, result);
        this.sseConsumer.accept(new DefaultSseBuilder(request, context, result));
        return NONE_RETURN_VALUE;
    }

    private static final class DefaultSseBuilder
    implements ServerResponse.SseBuilder {
        private static final byte[] NL_NL = new byte[]{10, 10};
        private final DeferredResult<?> deferredResult;
        private final List<HttpMessageConverter<?>> messageConverters;
        private final StringBuilder builder = new StringBuilder();
        private final RequestContext request;
        private boolean sendFailed;

        public DefaultSseBuilder(RequestContext request, ServerResponse.Context context, DeferredResult<?> deferredResult) {
            this.request = request;
            this.deferredResult = deferredResult;
            this.messageConverters = context.messageConverters();
        }

        @Override
        public void send(Object object) throws IOException {
            this.data(object);
        }

        @Override
        public void send() throws IOException {
            this.builder.append('\n');
            try {
                OutputStream body = this.request.getOutputStream();
                body.write(this.builderBytes());
                this.request.flush();
            }
            catch (IOException ex) {
                this.sendFailed = true;
                throw ex;
            }
            finally {
                this.builder.setLength(0);
            }
        }

        @Override
        public ServerResponse.SseBuilder id(String id) {
            Assert.hasLength((String)id, (String)"Id must not be empty");
            return this.field("id", id);
        }

        @Override
        public ServerResponse.SseBuilder event(String eventName) {
            Assert.hasLength((String)eventName, (String)"Name must not be empty");
            return this.field("event", eventName);
        }

        @Override
        public ServerResponse.SseBuilder retry(Duration duration) {
            Assert.notNull((Object)duration, (String)"Duration is required");
            String millis = Long.toString(duration.toMillis());
            return this.field("retry", millis);
        }

        @Override
        public ServerResponse.SseBuilder comment(String comment) {
            String[] lines;
            Assert.hasLength((String)comment, (String)"Comment must not be empty");
            for (String line : lines = comment.split("\n")) {
                this.field("", line);
            }
            return this;
        }

        private ServerResponse.SseBuilder field(String name, String value) {
            this.builder.append(name).append(':').append(value).append('\n');
            return this;
        }

        @Override
        public void data(Object object) throws IOException {
            this.data(object, MediaType.APPLICATION_JSON);
        }

        @Override
        public void data(Object object, @Nullable MediaType mediaType) throws IOException {
            Assert.notNull((Object)object, (String)"Object is required");
            if (object instanceof String) {
                this.writeString((String)object);
            } else {
                this.writeObject(object, mediaType);
            }
        }

        private void writeString(String string) throws IOException {
            String[] lines;
            for (String line : lines = string.split("\n")) {
                this.field("data", line);
            }
            this.send();
        }

        private void writeObject(Object data, @Nullable MediaType mediaType) throws IOException {
            this.builder.append("data:");
            try {
                OutputStream body = this.request.getOutputStream();
                body.write(this.builderBytes());
                Class<?> dataClass = data.getClass();
                for (HttpMessageConverter<?> converter : this.messageConverters) {
                    if (!converter.canWrite(dataClass, mediaType)) continue;
                    converter.write(data, mediaType, this.request.asHttpOutputMessage());
                    body.write(NL_NL);
                    this.request.flush();
                    return;
                }
            }
            catch (IOException ex) {
                this.sendFailed = true;
                throw ex;
            }
            finally {
                this.builder.setLength(0);
            }
        }

        private byte[] builderBytes() {
            return this.builder.toString().getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public void error(Throwable t) {
            if (this.sendFailed) {
                return;
            }
            this.deferredResult.setErrorResult(t);
        }

        @Override
        public void complete() {
            if (this.sendFailed) {
                return;
            }
            try {
                this.request.flush();
                this.deferredResult.setResult(null);
            }
            catch (IOException ex) {
                this.deferredResult.setErrorResult(ex);
            }
        }

        @Override
        public ServerResponse.SseBuilder onTimeout(Runnable onTimeout) {
            this.deferredResult.onTimeout(onTimeout);
            return this;
        }

        @Override
        public ServerResponse.SseBuilder onError(Consumer<Throwable> onError) {
            this.deferredResult.onError(onError);
            return this;
        }

        @Override
        public ServerResponse.SseBuilder onComplete(Runnable onCompletion) {
            this.deferredResult.onCompletion(onCompletion);
            return this;
        }
    }
}

