/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.function;

import infra.core.ParameterizedTypeReference;
import infra.http.CacheControl;
import infra.http.HttpCookie;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.http.MediaType;
import infra.http.converter.HttpMessageConverter;
import infra.lang.Nullable;
import infra.util.MultiValueMap;
import infra.web.ErrorResponse;
import infra.web.HttpRequestHandler;
import infra.web.RequestContext;
import infra.web.handler.function.AsyncServerResponse;
import infra.web.handler.function.DefaultServerResponseBuilder;
import infra.web.handler.function.SseServerResponse;
import infra.web.view.ModelAndView;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public interface ServerResponse {
    public static final Object NONE_RETURN_VALUE = HttpRequestHandler.NONE_RETURN_VALUE;

    public HttpStatusCode statusCode();

    public int rawStatusCode();

    public HttpHeaders headers();

    public MultiValueMap<String, HttpCookie> cookies();

    @Nullable
    public Object writeTo(RequestContext var1, Context var2) throws Throwable;

    public static BodyBuilder from(ServerResponse other) {
        return new DefaultServerResponseBuilder(other);
    }

    public static ServerResponse from(ErrorResponse response) {
        return ((BodyBuilder)ServerResponse.status(response.getStatusCode()).headers(response.getHeaders())).body(response.getBody());
    }

    public static BodyBuilder status(HttpStatusCode status) {
        return new DefaultServerResponseBuilder(status);
    }

    public static BodyBuilder status(int status) {
        return new DefaultServerResponseBuilder(HttpStatusCode.valueOf(status));
    }

    public static BodyBuilder ok() {
        return ServerResponse.status(HttpStatus.OK);
    }

    public static BodyBuilder created(URI location) {
        BodyBuilder builder = ServerResponse.status(HttpStatus.CREATED);
        return (BodyBuilder)builder.location(location);
    }

    public static BodyBuilder accepted() {
        return ServerResponse.status(HttpStatus.ACCEPTED);
    }

    public static HeadersBuilder<?> noContent() {
        return ServerResponse.status(HttpStatus.NO_CONTENT);
    }

    public static BodyBuilder seeOther(URI location) {
        BodyBuilder builder = ServerResponse.status(HttpStatus.SEE_OTHER);
        return (BodyBuilder)builder.location(location);
    }

    public static BodyBuilder temporaryRedirect(URI location) {
        BodyBuilder builder = ServerResponse.status(HttpStatus.TEMPORARY_REDIRECT);
        return (BodyBuilder)builder.location(location);
    }

    public static BodyBuilder permanentRedirect(URI location) {
        BodyBuilder builder = ServerResponse.status(HttpStatus.PERMANENT_REDIRECT);
        return (BodyBuilder)builder.location(location);
    }

    public static BodyBuilder badRequest() {
        return ServerResponse.status(HttpStatus.BAD_REQUEST);
    }

    public static HeadersBuilder<?> notFound() {
        return ServerResponse.status(HttpStatus.NOT_FOUND);
    }

    public static BodyBuilder unprocessableEntity() {
        return ServerResponse.status(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    public static ServerResponse async(Object asyncResponse) {
        return AsyncServerResponse.create(asyncResponse, null);
    }

    public static ServerResponse async(Object asyncResponse, @Nullable Duration timeout) {
        return AsyncServerResponse.create(asyncResponse, timeout);
    }

    public static ServerResponse sse(Consumer<SseBuilder> consumer) {
        return new SseServerResponse(consumer, null);
    }

    public static ServerResponse sse(Consumer<SseBuilder> consumer, Duration timeout) {
        return new SseServerResponse(consumer, timeout);
    }

    public static interface BodyBuilder
    extends HeadersBuilder<BodyBuilder> {
        public BodyBuilder contentLength(long var1);

        public BodyBuilder contentType(MediaType var1);

        public ServerResponse body(Object var1);

        public <T> ServerResponse body(T var1, ParameterizedTypeReference<T> var2);

        public ServerResponse render(String var1, Object ... var2);

        public ServerResponse render(String var1, Map<String, ?> var2);

        public ServerResponse render(ModelAndView var1);

        public ServerResponse stream(Consumer<StreamBuilder> var1);
    }

    public static interface HeadersBuilder<B extends HeadersBuilder<B>> {
        public B header(String var1, String ... var2);

        public B headers(Consumer<HttpHeaders> var1);

        public B headers(@Nullable HttpHeaders var1);

        public B cookie(HttpCookie var1);

        public B cookie(String var1, String ... var2);

        public B cookies(Consumer<MultiValueMap<String, HttpCookie>> var1);

        public B cookies(@Nullable Collection<HttpCookie> var1);

        public B cookies(@Nullable MultiValueMap<String, HttpCookie> var1);

        public B allow(HttpMethod ... var1);

        public B allow(Set<HttpMethod> var1);

        public B eTag(@Nullable String var1);

        public B lastModified(ZonedDateTime var1);

        public B lastModified(Instant var1);

        public B location(URI var1);

        public B cacheControl(CacheControl var1);

        public B varyBy(String ... var1);

        public ServerResponse build();

        public ServerResponse build(WriteFunction var1);

        @FunctionalInterface
        public static interface WriteFunction {
            @Nullable
            public Object write(RequestContext var1) throws Exception;
        }
    }

    public static interface Context {
        public List<HttpMessageConverter<?>> messageConverters();
    }

    public static interface StreamBuilder
    extends AsyncBuilder<StreamBuilder> {
        public StreamBuilder write(Object var1) throws IOException;

        public StreamBuilder write(Object var1, @Nullable MediaType var2) throws IOException;

        public void flush() throws IOException;
    }

    public static interface SseBuilder
    extends AsyncBuilder<SseBuilder> {
        public void send(Object var1) throws IOException;

        public void send() throws IOException;

        public SseBuilder id(String var1);

        public SseBuilder event(String var1);

        public SseBuilder retry(Duration var1);

        public SseBuilder comment(String var1);

        public void data(Object var1) throws IOException;

        public void data(Object var1, @Nullable MediaType var2) throws IOException;
    }

    public static interface AsyncBuilder<B extends AsyncBuilder<B>> {
        public void error(Throwable var1);

        public void complete();

        public B onTimeout(Runnable var1);

        public B onError(Consumer<Throwable> var1);

        public B onComplete(Runnable var1);
    }
}

