/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.function;

import infra.core.ParameterizedTypeReference;
import infra.http.HttpCookie;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpRange;
import infra.http.MediaType;
import infra.http.converter.HttpMessageConverter;
import infra.http.server.RequestPath;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.MultiValueMap;
import infra.validation.BindException;
import infra.web.RequestContext;
import infra.web.bind.WebDataBinder;
import infra.web.handler.function.DefaultServerRequest;
import infra.web.handler.function.DefaultServerRequestBuilder;
import infra.web.handler.function.RouterFunctions;
import infra.web.handler.function.ServerResponse;
import infra.web.multipart.Multipart;
import infra.web.util.UriBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Consumer;

public interface ServerRequest
extends ServerResponse.Context {
    public HttpMethod method();

    public String methodName();

    public URI uri();

    public UriBuilder uriBuilder();

    default public String path() {
        return this.requestPath().value();
    }

    default public RequestPath requestPath() {
        return this.exchange().getRequestPath();
    }

    public Headers headers();

    public MultiValueMap<String, HttpCookie> cookies();

    public Optional<InetSocketAddress> remoteAddress();

    @Override
    public List<HttpMessageConverter<?>> messageConverters();

    public <T> T body(Class<T> var1) throws IOException;

    public <T> T body(ParameterizedTypeReference<T> var1) throws IOException;

    default public <T> T bind(Class<T> bindType) throws BindException {
        return this.bind(bindType, dataBinder -> {});
    }

    public <T> T bind(Class<T> var1, Consumer<WebDataBinder> var2) throws BindException;

    @Nullable
    default public Object attribute(String name) {
        return this.attributes().get(name);
    }

    public Map<String, Object> attributes();

    default public Optional<String> param(String name) {
        List paramValues = (List)this.params().get((Object)name);
        if (CollectionUtils.isEmpty((Collection)paramValues)) {
            return Optional.empty();
        }
        String value = (String)paramValues.get(0);
        if (value == null) {
            value = "";
        }
        return Optional.of(value);
    }

    default public List<String> params(String name) {
        List paramValues = (List)this.params().get((Object)name);
        if (CollectionUtils.isEmpty((Collection)paramValues)) {
            return Collections.emptyList();
        }
        return paramValues;
    }

    public MultiValueMap<String, String> params();

    public MultiValueMap<String, Multipart> multipartData() throws IOException;

    default public String pathVariable(String name) {
        Map<String, String> pathVariables = this.pathVariables();
        if (pathVariables.containsKey(name)) {
            return pathVariables.get(name);
        }
        throw new IllegalArgumentException("No path variable with name \"%s\" available".formatted(name));
    }

    public Map<String, String> pathVariables();

    public RequestContext exchange();

    default public Optional<ServerResponse> checkNotModified(Instant lastModified) {
        Assert.notNull((Object)lastModified, (String)"LastModified is required");
        return DefaultServerRequest.checkNotModified(this.exchange(), lastModified, null);
    }

    default public Optional<ServerResponse> checkNotModified(String etag) {
        Assert.notNull((Object)etag, (String)"Etag is required");
        return DefaultServerRequest.checkNotModified(this.exchange(), null, etag);
    }

    default public Optional<ServerResponse> checkNotModified(Instant lastModified, String etag) {
        Assert.notNull((Object)etag, (String)"Etag is required");
        Assert.notNull((Object)lastModified, (String)"LastModified is required");
        return DefaultServerRequest.checkNotModified(this.exchange(), lastModified, etag);
    }

    public static ServerRequest create(RequestContext context, List<HttpMessageConverter<?>> messageReaders) {
        return new DefaultServerRequest(context, messageReaders);
    }

    public static Builder from(ServerRequest other) {
        return new DefaultServerRequestBuilder(other);
    }

    @Nullable
    public static ServerRequest find(RequestContext context) {
        Object attribute = context.getAttribute(RouterFunctions.REQUEST_ATTRIBUTE);
        if (attribute instanceof ServerRequest) {
            ServerRequest serverRequest = (ServerRequest)attribute;
            return serverRequest;
        }
        return null;
    }

    public static ServerRequest findRequired(RequestContext context) {
        ServerRequest serverRequest = ServerRequest.find(context);
        if (serverRequest == null) {
            throw new IllegalStateException("Required attribute '%s' is missing".formatted(RouterFunctions.REQUEST_ATTRIBUTE));
        }
        return serverRequest;
    }

    public static interface Builder {
        public Builder method(HttpMethod var1);

        public Builder uri(URI var1);

        public Builder header(String var1, String ... var2);

        public Builder headers(Consumer<HttpHeaders> var1);

        public Builder cookie(String var1, String ... var2);

        public Builder cookies(Consumer<MultiValueMap<String, HttpCookie>> var1);

        public Builder body(byte[] var1);

        public Builder body(String var1);

        public Builder attribute(String var1, Object var2);

        public Builder attributes(Consumer<Map<String, Object>> var1);

        public Builder param(String var1, String ... var2);

        public Builder params(Consumer<MultiValueMap<String, String>> var1);

        public Builder remoteAddress(InetSocketAddress var1);

        public ServerRequest build();
    }

    public static interface Headers {
        public List<MediaType> accept();

        public List<Charset> acceptCharset();

        public List<Locale.LanguageRange> acceptLanguage();

        public OptionalLong contentLength();

        public Optional<MediaType> contentType();

        @Nullable
        public InetSocketAddress host();

        public List<HttpRange> range();

        public List<String> header(String var1);

        @Nullable
        default public String firstHeader(String headerName) {
            List<String> list = this.header(headerName);
            return list.isEmpty() ? null : list.get(0);
        }

        public HttpHeaders asHttpHeaders();
    }
}

