/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.function;

import infra.lang.Assert;
import infra.web.handler.function.HandlerFilterFunction;
import infra.web.handler.function.HandlerFunction;
import infra.web.handler.function.RequestPredicate;
import infra.web.handler.function.RouterFunctions;
import infra.web.handler.function.ServerRequest;
import infra.web.handler.function.ServerResponse;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

@FunctionalInterface
public interface RouterFunction<T extends ServerResponse> {
    public Optional<HandlerFunction<T>> route(ServerRequest var1);

    default public RouterFunction<T> and(RouterFunction<T> other) {
        return new RouterFunctions.SameComposedRouterFunction<T>(this, other);
    }

    default public RouterFunction<?> andOther(RouterFunction<?> other) {
        return new RouterFunctions.DifferentComposedRouterFunction(this, other);
    }

    default public RouterFunction<T> andRoute(RequestPredicate predicate, HandlerFunction<T> handlerFunction) {
        return this.and(RouterFunctions.route(predicate, handlerFunction));
    }

    default public RouterFunction<T> andNest(RequestPredicate predicate, RouterFunction<T> routerFunction) {
        return this.and(RouterFunctions.nest(predicate, routerFunction));
    }

    default public <S extends ServerResponse> RouterFunction<S> filter(HandlerFilterFunction<T, S> filterFunction) {
        return new RouterFunctions.FilteredRouterFunction<T, S>(this, filterFunction);
    }

    default public void accept(RouterFunctions.Visitor visitor) {
        visitor.unknown(this);
    }

    default public RouterFunction<T> withAttribute(String name, Object value) {
        Assert.hasLength((String)name, (String)"Name must not be empty");
        Assert.notNull((Object)value, (String)"Value is required");
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributes.put(name, value);
        return new RouterFunctions.AttributesRouterFunction(this, attributes);
    }

    default public RouterFunction<T> withAttributes(Consumer<Map<String, Object>> attributesConsumer) {
        Assert.notNull(attributesConsumer, (String)"AttributesConsumer is required");
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributesConsumer.accept(attributes);
        return new RouterFunctions.AttributesRouterFunction(this, attributes);
    }
}

