/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.function;

import infra.core.io.Resource;
import infra.core.io.ResourceFilter;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpStatus;
import infra.lang.Nullable;
import infra.web.handler.function.EntityResponse;
import infra.web.handler.function.HandlerFunction;
import infra.web.handler.function.ServerRequest;
import infra.web.handler.function.ServerResponse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Set;
import java.util.function.BiConsumer;

class ResourceHandlerFunction
implements HandlerFunction<ServerResponse> {
    private static final Set<HttpMethod> SUPPORTED_METHODS = Set.of(HttpMethod.GET, HttpMethod.HEAD, HttpMethod.OPTIONS);
    private final Resource resource;
    private final BiConsumer<Resource, HttpHeaders> headersConsumer;

    public ResourceHandlerFunction(Resource resource, BiConsumer<Resource, HttpHeaders> headersConsumer) {
        this.resource = resource;
        this.headersConsumer = headersConsumer;
    }

    @Override
    public ServerResponse handle(ServerRequest request) {
        HttpMethod method = request.method();
        if (HttpMethod.GET == method) {
            return EntityResponse.fromObject(this.resource).headers(headers -> this.headersConsumer.accept(this.resource, (HttpHeaders)headers)).build();
        }
        if (HttpMethod.HEAD == method) {
            HeadMethodResource headResource = new HeadMethodResource(this.resource);
            return EntityResponse.fromObject(headResource).headers(headers -> this.headersConsumer.accept(this.resource, (HttpHeaders)headers)).build();
        }
        if (HttpMethod.OPTIONS == method) {
            return ((ServerResponse.BodyBuilder)ServerResponse.ok().allow(SUPPORTED_METHODS)).build();
        }
        return ((ServerResponse.BodyBuilder)ServerResponse.status(HttpStatus.METHOD_NOT_ALLOWED).allow(SUPPORTED_METHODS)).build();
    }

    private static class HeadMethodResource
    implements Resource {
        private static final byte[] EMPTY = new byte[0];
        private final Resource delegate;

        public HeadMethodResource(Resource delegate) {
            this.delegate = delegate;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(EMPTY);
        }

        public boolean exists() {
            return this.delegate.exists();
        }

        public boolean isDirectory() throws IOException {
            return this.delegate.isDirectory();
        }

        public String[] list() throws IOException {
            return this.delegate.list();
        }

        public Resource[] list(@Nullable ResourceFilter filter) throws IOException {
            return this.delegate.list(filter);
        }

        public URL getURL() throws IOException {
            return this.delegate.getURL();
        }

        public URI getURI() throws IOException {
            return this.delegate.getURI();
        }

        public File getFile() throws IOException {
            return this.delegate.getFile();
        }

        public long contentLength() throws IOException {
            return this.delegate.contentLength();
        }

        public long lastModified() throws IOException {
            return this.delegate.lastModified();
        }

        public Resource createRelative(String relativePath) throws IOException {
            return this.delegate.createRelative(relativePath);
        }

        @Nullable
        public String getName() {
            return this.delegate.getName();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

