/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.function;

import infra.http.HttpCookie;
import infra.http.HttpHeaders;
import infra.http.HttpStatusCode;
import infra.lang.Nullable;
import infra.util.MultiValueMap;
import infra.web.handler.function.DefaultRenderingResponseBuilder;
import infra.web.handler.function.ModelAndViewRenderingResponseBuilder;
import infra.web.handler.function.ServerResponse;
import infra.web.view.ModelAndView;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;

public interface RenderingResponse
extends ServerResponse {
    public String name();

    public Map<String, Object> model();

    public static Builder from(RenderingResponse other) {
        return new DefaultRenderingResponseBuilder(other);
    }

    public static Builder create(String name) {
        return new DefaultRenderingResponseBuilder(name);
    }

    public static ViewBuilder create(ModelAndView view) {
        return new ModelAndViewRenderingResponseBuilder(view);
    }

    public static interface ViewBuilder {
        public ViewBuilder header(String var1, String ... var2);

        public ViewBuilder headers(Consumer<HttpHeaders> var1);

        public ViewBuilder headers(@Nullable HttpHeaders var1);

        public ViewBuilder status(HttpStatusCode var1);

        public ViewBuilder status(int var1);

        public ViewBuilder cookie(HttpCookie var1);

        public ViewBuilder cookie(String var1, String ... var2);

        public ViewBuilder cookies(Consumer<MultiValueMap<String, HttpCookie>> var1);

        public ViewBuilder cookies(@Nullable Collection<HttpCookie> var1);

        public ViewBuilder cookies(@Nullable MultiValueMap<String, HttpCookie> var1);

        public RenderingResponse build();
    }

    public static interface Builder {
        public Builder modelAttribute(Object var1);

        public Builder modelAttribute(String var1, @Nullable Object var2);

        public Builder modelAttributes(Object ... var1);

        public Builder modelAttributes(Collection<?> var1);

        public Builder modelAttributes(Map<String, ?> var1);

        public Builder header(String var1, String ... var2);

        public Builder headers(Consumer<HttpHeaders> var1);

        public Builder headers(@Nullable HttpHeaders var1);

        public Builder status(HttpStatusCode var1);

        public Builder status(int var1);

        public Builder cookie(HttpCookie var1);

        public Builder cookie(String var1, String ... var2);

        public Builder cookies(Consumer<MultiValueMap<String, HttpCookie>> var1);

        public Builder cookies(@Nullable Collection<HttpCookie> var1);

        public Builder cookies(@Nullable MultiValueMap<String, HttpCookie> var1);

        public RenderingResponse build();
    }
}

