/*
 * Decompiled with CFR 0.152.
 */
package infra.web.handler.function;

import infra.core.io.Resource;
import infra.lang.Assert;
import infra.web.handler.function.RequestPredicate;
import infra.web.handler.function.ServerRequest;
import java.util.Optional;
import java.util.function.Function;

class PredicateResourceLookupFunction
implements Function<ServerRequest, Optional<Resource>> {
    private final RequestPredicate predicate;
    private final Resource resource;

    public PredicateResourceLookupFunction(RequestPredicate predicate, Resource resource) {
        Assert.notNull((Object)predicate, (String)"'predicate' is required");
        Assert.notNull((Object)resource, (String)"'resource' is required");
        this.predicate = predicate;
        this.resource = resource;
    }

    @Override
    public Optional<Resource> apply(ServerRequest serverRequest) {
        return this.predicate.test(serverRequest) ? Optional.of(this.resource) : Optional.empty();
    }
}

